/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeterBuildSettings;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

final class HttpClientMessenger
extends BlockingMessenger {
    private static final transient Logger LOG = Logger.getLogger(HttpClientMessenger.class.getName());
    private static final int MIMIMUM_POLL_INTERVAL = 5000;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int RESPONSE_TIMEOUT = 120000;
    private static final int EXTRA_RESPONSE_TIMEOUT = 120000;
    private static final long MESSENGER_IDLE_TIMEOUT = 900000L;
    private static final int CONNECT_RETRIES = 2;
    private static boolean neverWarned = true;
    private final URL senderURL;
    private final ServletHttpTransport servletHttpTransport;
    private final MessageElement srcAddressElement;
    private final EndpointAddress logicalDest;
    private TransportBindingMeter transportBindingMeter;
    private transient long lastUsed = TimeUtils.timeNow();
    private MessagePoller poller = null;

    HttpClientMessenger(ServletHttpTransport servletHttpTransport, EndpointAddress srcAddr, EndpointAddress destAddr) throws IOException {
        super(servletHttpTransport.getEndpointService().getGroup().getPeerGroupID(), destAddr, true);
        int port;
        String host;
        this.servletHttpTransport = servletHttpTransport;
        EndpointAddress srcAddress = srcAddr;
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddr.toString(), null);
        String protoAddr = destAddr.getProtocolAddress();
        int lastColon = protoAddr.lastIndexOf(58);
        if (-1 == lastColon || lastColon < protoAddr.lastIndexOf(93) || lastColon + 1 == protoAddr.length()) {
            host = protoAddr;
            port = 80;
        } else {
            host = protoAddr.substring(0, lastColon);
            port = Integer.parseInt(protoAddr.substring(lastColon + 1));
        }
        this.senderURL = new URL("http", host, port, "/");
        this.logicalDest = this.retreiveLogicalDestinationAddress();
        this.poller = new MessagePoller(srcAddr.getProtocolAddress(), destAddr);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("New messenger : " + this);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" {");
        result.append(this.getDestinationAddress());
        result.append(" / ");
        result.append(this.getLogicalDestinationAddress());
        result.append("}");
        return result.toString();
    }

    void doShutdown() {
        super.shutdown();
    }

    public synchronized void closeImpl() {
        if (this.isClosed()) {
            return;
        }
        super.close();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Close messenger to " + this.senderURL);
        }
        MessagePoller stopPoller = this.poller;
        this.poller = null;
        if (null != stopPoller) {
            stopPoller.stop();
        }
    }

    public void sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Messenger was closed, it cannot be used to send messages.", failure);
            }
            throw failure;
        }
        message = message.clone();
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), null);
        message.replaceMessageElement("jxta", dstAddressElement);
        try {
            this.doSend(message);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return this.logicalDest;
    }

    public boolean isIdleImpl() {
        return this.isClosed() || TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), this.lastUsed) > 900000L;
    }

    private EndpointAddress retreiveLogicalDestinationAddress() throws IOException {
        long beginConnectTime = 0L;
        long connectTime = 0L;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Ping (" + this.senderURL + ")");
        }
        if (TransportMeterBuildSettings.TRANSPORT_METERING) {
            beginConnectTime = TimeUtils.timeNow();
        }
        HttpURLConnection urlConn = (HttpURLConnection)this.senderURL.openConnection();
        urlConn.setRequestMethod("GET");
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setAllowUserInteraction(false);
        urlConn.setUseCaches(false);
        urlConn.setConnectTimeout(15000);
        urlConn.setReadTimeout(15000);
        try {
            String uniqueIdString;
            int bytesRead;
            int thisRead;
            int code = urlConn.getResponseCode();
            if (code != 200) {
                if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                    this.transportBindingMeter = this.servletHttpTransport.getTransportBindingMeter(null, this.getDestinationAddress());
                    if (this.transportBindingMeter != null) {
                        this.transportBindingMeter.connectionFailed(true, TimeUtils.timeNow() - beginConnectTime);
                    }
                }
                throw new IOException("Message not accepted: HTTP status code=" + code + " reason=" + urlConn.getResponseMessage());
            }
            int msglength = urlConn.getContentLength();
            if (msglength <= 0) {
                throw new IOException("Ping response was empty.");
            }
            InputStream inputStream = urlConn.getInputStream();
            byte[] uniqueIdBytes = new byte[msglength];
            for (bytesRead = 0; bytesRead < msglength && (thisRead = inputStream.read(uniqueIdBytes, bytesRead, msglength - bytesRead)) >= 0; bytesRead += thisRead) {
            }
            if (bytesRead < msglength) {
                throw new IOException("Content ended before promised Content length");
            }
            try {
                uniqueIdString = new String(uniqueIdBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException never) {
                uniqueIdString = new String(uniqueIdBytes);
            }
            if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                connectTime = TimeUtils.timeNow();
                this.transportBindingMeter = this.servletHttpTransport.getTransportBindingMeter(uniqueIdString, this.getDestinationAddress());
                if (this.transportBindingMeter != null) {
                    this.transportBindingMeter.connectionEstablished(true, connectTime - beginConnectTime);
                    this.transportBindingMeter.ping(connectTime);
                    this.transportBindingMeter.connectionClosed(true, connectTime - beginConnectTime);
                }
            }
            EndpointAddress remoteAddress = new EndpointAddress("jxta", uniqueIdString.trim(), null, null);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Ping (" + this.senderURL + ") -> " + remoteAddress);
            }
            return remoteAddress;
        }
        catch (IOException failure) {
            if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                connectTime = TimeUtils.timeNow();
                this.transportBindingMeter = this.servletHttpTransport.getTransportBindingMeter(null, this.getDestinationAddress());
                if (this.transportBindingMeter != null) {
                    this.transportBindingMeter.connectionFailed(true, connectTime - beginConnectTime);
                }
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Ping (" + this.senderURL + ") -> failed");
            }
            throw failure;
        }
    }

    /*
     * Exception decompiling
     */
    private void doSend(Message msg) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class MessageProcessor
    implements Runnable {
        private Message msg;

        MessageProcessor(Message msg) {
            this.msg = msg;
        }

        public void run() {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Demuxing " + this.msg + " from " + HttpClientMessenger.this.senderURL);
            }
            HttpClientMessenger.this.servletHttpTransport.getEndpointService().demux(this.msg);
        }
    }

    private class MessagePoller
    implements Runnable {
        private volatile boolean stopped = false;
        private Thread pollerThread;
        private final URL pollingURL;

        MessagePoller(String pollAddress, EndpointAddress destAddr) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("new MessagePoller for " + HttpClientMessenger.this.senderURL);
            }
            try {
                this.pollingURL = new URL(HttpClientMessenger.this.senderURL, "/" + pollAddress + "?" + Integer.toString(120000) + "," + Integer.toString(120000) + "," + destAddr);
            }
            catch (MalformedURLException badAddr) {
                IllegalArgumentException failure = new IllegalArgumentException("Could not construct polling URL");
                failure.initCause(badAddr);
                throw failure;
            }
            this.pollerThread = new Thread((Runnable)this, "HttpClientMessenger poller for " + HttpClientMessenger.this.senderURL);
            this.pollerThread.setDaemon(true);
            this.pollerThread.start();
        }

        protected void stop() {
            if (this.stopped) {
                return;
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Stop polling for " + HttpClientMessenger.this.senderURL);
            }
            this.stopped = true;
            Thread stopPoller = this.pollerThread;
            if (null != stopPoller) {
                stopPoller.interrupt();
            }
        }

        protected boolean isStopped() {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(this + " " + HttpClientMessenger.this.senderURL + " --> " + (this.stopped ? "stopped" : "running"));
            }
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long beginConnectTime = 0L;
                long connectTime = 0L;
                long noReconnectBefore = 0L;
                HttpURLConnection conn = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Message polling beings for " + this.pollingURL);
                }
                int connectAttempt = 1;
                while (!this.isStopped()) {
                    InputStream inputStream;
                    MimeMediaType messageType;
                    block58: {
                        if (conn == null) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Opening new connection to " + this.pollingURL);
                            }
                            conn = (HttpURLConnection)this.pollingURL.openConnection();
                            conn.setRequestMethod("GET");
                            conn.setDoOutput(false);
                            conn.setDoInput(true);
                            conn.setAllowUserInteraction(false);
                            conn.setUseCaches(false);
                            conn.setConnectTimeout(15000);
                            conn.setReadTimeout(120000);
                            if (!TransportMeterBuildSettings.TRANSPORT_METERING) continue;
                            beginConnectTime = TimeUtils.timeNow();
                            continue;
                        }
                        long untilNextConnect = TimeUtils.toRelativeTimeMillis(noReconnectBefore);
                        try {
                            if (untilNextConnect <= 0L) break block58;
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Delaying for " + untilNextConnect + "ms before reconnect to " + HttpClientMessenger.this.senderURL);
                            }
                            Thread.sleep(untilNextConnect);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                            continue;
                        }
                    }
                    try {
                        if (connectAttempt > 1 && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Reconnect attempt for " + HttpClientMessenger.this.senderURL);
                        }
                        conn.connect();
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Waiting for response code from " + HttpClientMessenger.this.senderURL);
                        }
                        int responseCode = conn.getResponseCode();
                        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                            LOG.finer("Response " + responseCode + " for Connection : " + HttpClientMessenger.this.senderURL + "\n\tContent-Type : " + conn.getHeaderField("Content-Type") + "\tContent-Length : " + conn.getHeaderField("Content-Length") + "\tTransfer-Encoding : " + conn.getHeaderField("Transfer-Encoding"));
                        }
                        connectTime = TimeUtils.timeNow();
                        noReconnectBefore = TimeUtils.toAbsoluteTimeMillis(5000L, connectTime);
                        if (0 == conn.getContentLength()) continue;
                        if (204 == responseCode) {
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && HttpClientMessenger.this.transportBindingMeter != null) {
                                HttpClientMessenger.this.transportBindingMeter.connectionClosed(true, TimeUtils.toRelativeTimeMillis(beginConnectTime, connectTime));
                            }
                            conn = null;
                            continue;
                        }
                        if (responseCode != 200) {
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && HttpClientMessenger.this.transportBindingMeter != null) {
                                HttpClientMessenger.this.transportBindingMeter.connectionClosed(true, TimeUtils.timeNow() - beginConnectTime);
                            }
                            throw new IOException("HTTP Failure: " + conn.getResponseCode() + " : " + conn.getResponseMessage());
                        }
                        String contentType = conn.getHeaderField("Content-Type");
                        messageType = null == contentType ? EndpointServiceImpl.DEFAULT_MESSAGE_TYPE : MimeMediaType.valueOf(contentType);
                        inputStream = conn.getInputStream();
                        connectAttempt = 1;
                    }
                    catch (InterruptedIOException broken) {
                        Thread.interrupted();
                        if (connectAttempt > 2) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Unable to connect to " + HttpClientMessenger.this.senderURL);
                            }
                            this.stop();
                            break;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Failed connecting to " + HttpClientMessenger.this.senderURL);
                        }
                        if (null != conn) {
                            conn.disconnect();
                        }
                        conn = null;
                        ++connectAttempt;
                        continue;
                    }
                    catch (IOException ioe) {
                        if (connectAttempt > 2) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Unable to connect to " + HttpClientMessenger.this.senderURL, ioe);
                            }
                            this.stop();
                            break;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Failed connecting to " + HttpClientMessenger.this.senderURL);
                        }
                        if (null != conn) {
                            conn.disconnect();
                        }
                        conn = null;
                        ++connectAttempt;
                        continue;
                    }
                    try {
                        while (!this.isStopped() && TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), connectTime) < 120000L) {
                            long messageReceiveStart = TimeUtils.timeNow();
                            Message incomingMsg = WireFormatMessageFactory.fromWire(inputStream, messageType, null);
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && HttpClientMessenger.this.transportBindingMeter != null) {
                                HttpClientMessenger.this.transportBindingMeter.messageReceived(true, incomingMsg, incomingMsg.getByteLength(), TimeUtils.timeNow() - messageReceiveStart);
                            }
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Received " + incomingMsg + " from " + HttpClientMessenger.this.senderURL);
                            }
                            ((HttpClientMessenger)HttpClientMessenger.this).servletHttpTransport.executor.execute(new MessageProcessor(incomingMsg));
                            HttpClientMessenger.this.lastUsed = TimeUtils.timeNow();
                        }
                        if (!TransportMeterBuildSettings.TRANSPORT_METERING || HttpClientMessenger.this.transportBindingMeter == null) continue;
                        HttpClientMessenger.this.transportBindingMeter.connectionClosed(true, TimeUtils.timeNow() - beginConnectTime);
                    }
                    catch (EOFException e) {
                        conn = null;
                    }
                    catch (InterruptedIOException broken) {
                        if (TransportMeterBuildSettings.TRANSPORT_METERING && HttpClientMessenger.this.transportBindingMeter != null) {
                            HttpClientMessenger.this.transportBindingMeter.connectionDropped(true, TimeUtils.timeNow() - beginConnectTime);
                        }
                        Thread.interrupted();
                        if (null != conn) {
                            conn.disconnect();
                        }
                        conn = null;
                    }
                    catch (IOException e) {
                        if (TransportMeterBuildSettings.TRANSPORT_METERING && HttpClientMessenger.this.transportBindingMeter != null) {
                            HttpClientMessenger.this.transportBindingMeter.connectionDropped(true, TimeUtils.timeNow() - beginConnectTime);
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Failed to read message from " + HttpClientMessenger.this.senderURL, e);
                        }
                        this.stop();
                        break;
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
            catch (Throwable argh) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Poller exiting because of uncaught exception", argh);
                }
                this.stop();
            }
            finally {
                this.pollerThread = null;
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Message polling stopped for " + HttpClientMessenger.this.senderURL);
            }
        }
    }
}

