/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.impl.endpoint.servlethttp.HttpMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.HttpServletMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeterBuildSettings;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

public class HttpMessageServlet
extends HttpServlet {
    private static final transient Logger LOG = Logger.getLogger(HttpMessageServlet.class.getName());
    private static final long MAXIMUM_RESPONSE_DURATION = 120000L;
    private HttpMessageReceiver owner = null;
    private EndpointService endpoint = null;
    private EndpointAddress localAddress = null;
    private byte[] pingResponseBytes;
    private ServletHttpTransport servletHttpTransport = null;
    private volatile boolean destroyed = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.owner = (HttpMessageReceiver)this.getServletContext().getAttribute("HttpMessageReceiver");
            if (this.owner == null) {
                throw new ServletException("Servlet Context did not contain 'HttpMessageReceiver'");
            }
        }
        catch (ClassCastException e) {
            throw new ServletException("'HttpMessageReceiver' attribute was not of the proper type in the Servlet Context");
        }
        this.servletHttpTransport = this.owner.servletHttpTransport;
        this.endpoint = this.owner.getEndpointService();
        String peerId = this.endpoint.getGroup().getPeerID().getUniqueValue().toString();
        this.localAddress = new EndpointAddress("jxta", peerId, null, null);
        try {
            this.pingResponseBytes = peerId.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("GET " + req.getRequestURI() + " thread = " + Thread.currentThread());
        }
        this.processRequest(req, res);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("GET done for thread = " + Thread.currentThread());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("POST " + req.getRequestURI() + " thread = " + Thread.currentThread());
        }
        this.processRequest(req, res);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("POST done for thread = " + Thread.currentThread());
        }
    }

    public synchronized void destroy() {
        this.destroyed = true;
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean mustSetContentLength;
        JxtaRequest currentRequest;
        TransportBindingMeter transportBindingMeter;
        block57: {
            long lastReadWriteTime;
            int requestSize = 0;
            transportBindingMeter = null;
            if (Logging.SHOW_FINEST && LOG.isLoggable(Level.FINEST)) {
                HttpMessageServlet.printRequest(req);
            }
            if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                int contentLength = req.getContentLength();
                requestSize += contentLength != -1 ? contentLength : 0;
            }
            currentRequest = new JxtaRequest(req);
            if (null == currentRequest.requestorAddr && !currentRequest.messageContent) {
                this.pingResponse(res);
                if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                    long connectionTime = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime);
                    EndpointAddress sourceAddress = new EndpointAddress("http", req.getRemoteHost(), null, null);
                    transportBindingMeter = this.servletHttpTransport.getTransportBindingMeter(null, sourceAddress);
                    if (transportBindingMeter != null) {
                        transportBindingMeter.connectionEstablished(false, currentRequest.requestStartTime);
                        transportBindingMeter.dataReceived(false, requestSize);
                        transportBindingMeter.dataSent(false, 0L);
                        transportBindingMeter.pingReceived();
                        transportBindingMeter.connectionClosed(false, connectionTime);
                    }
                }
                return;
            }
            if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                lastReadWriteTime = TimeUtils.timeNow();
                long connectTime = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime);
                EndpointAddress sourceAddress = new EndpointAddress("http", req.getRemoteHost(), null, null);
                transportBindingMeter = null != currentRequest.requestorAddr ? this.servletHttpTransport.getTransportBindingMeter(currentRequest.requestorAddr.toString(), sourceAddress) : this.servletHttpTransport.getTransportBindingMeter(req.getRemoteHost(), sourceAddress);
                if (transportBindingMeter != null) {
                    transportBindingMeter.connectionEstablished(false, connectTime);
                    transportBindingMeter.dataReceived(false, requestSize);
                }
            }
            BlockingMessenger messenger = null;
            if (null != currentRequest.requestorAddr && currentRequest.responseTimeout >= 0L && null != currentRequest.destAddr) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Creating back channel messenger for " + currentRequest.requestorAddr + " (" + currentRequest.destAddr + ")");
                }
                long messengerAliveFor = 0L == currentRequest.responseTimeout ? 0L : Math.max(currentRequest.responseTimeout, currentRequest.extraResponsesTimeout);
                messenger = new HttpServletMessenger(this.owner.servletHttpTransport.group.getPeerGroupID(), this.localAddress, currentRequest.requestorAddr, messengerAliveFor);
                boolean taken = this.owner.messengerReadyEvent((HttpServletMessenger)messenger, currentRequest.destAddr);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Incoming messenger to: " + currentRequest.requestorAddr + " taken=" + taken);
                }
                if (!taken) {
                    messenger.close();
                    messenger = null;
                }
            }
            mustSetContentLength = true;
            try {
                block56: {
                    if (currentRequest.messageContent) {
                        Message incomingMessage;
                        ServletInputStream in = req.getInputStream();
                        try {
                            String contentType = req.getContentType();
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Reading message from request : " + contentType);
                            }
                            MimeMediaType contentMimeType = EndpointServiceImpl.DEFAULT_MESSAGE_TYPE;
                            if (null != contentType) {
                                contentMimeType = MimeMediaType.valueOf(contentType);
                            }
                            try {
                                incomingMessage = WireFormatMessageFactory.fromWire((InputStream)in, contentMimeType, null);
                            }
                            catch (NoSuchElementException noValidWireFormat) {
                                IOException failure = new IOException("Unrecognized content type MIME type : " + contentType);
                                failure.initCause(noValidWireFormat);
                                throw failure;
                            }
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && transportBindingMeter != null) {
                                lastReadWriteTime = TimeUtils.timeNow();
                                long receiveTime = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime);
                                transportBindingMeter.messageReceived(false, incomingMessage, receiveTime, 0L);
                            }
                        }
                        catch (IOException e) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Malformed JXTA message, responding with BAD_REQUEST", e);
                            }
                            res.sendError(400, "Message was not a valid JXTA message");
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && transportBindingMeter != null) {
                                transportBindingMeter.connectionDropped(false, TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime));
                            }
                            if (null != messenger) {
                                messenger.close();
                            }
                            return;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Handing " + incomingMessage + " to the endpoint.");
                        }
                        try {
                            this.endpoint.demux(incomingMessage);
                        }
                        catch (Throwable e) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block56;
                            LOG.log(Level.WARNING, "Failure demuxing an incoming message", e);
                        }
                    }
                }
                boolean beganResponse = false;
                if (currentRequest.responseTimeout >= 0L && null != messenger) {
                    long quitAt;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Wait for message from the messenger. timeout = " + currentRequest.responseTimeout);
                    }
                    long l = quitAt = currentRequest.responseTimeout == 0L ? Long.MAX_VALUE : TimeUtils.toAbsoluteTimeMillis(currentRequest.requestStartTime, currentRequest.responseTimeout);
                    while (0 != (messenger.getState() & 0x3FF) && !this.destroyed) {
                        Message outMsg;
                        long remaining = TimeUtils.toRelativeTimeMillis(quitAt);
                        if (remaining <= 0L) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Terminating expired request.");
                            }
                            break block57;
                        }
                        try {
                            outMsg = ((HttpServletMessenger)messenger).waitForMessage(remaining);
                        }
                        catch (InterruptedException ie) {
                            Thread.interrupted();
                            continue;
                        }
                        if (outMsg == null) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Terminating request with no message to send.");
                            }
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && transportBindingMeter != null) {
                                transportBindingMeter.connectionClosed(false, TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime));
                            }
                            break block57;
                        }
                        long startMessageSend = TimeUtils.timeNow();
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Sending " + outMsg + " on back channel to " + req.getRemoteHost());
                        }
                        if (!beganResponse) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Sending OK in response to request");
                            }
                            beganResponse = true;
                            res.setStatus(200);
                            res.setContentType(EndpointServiceImpl.DEFAULT_MESSAGE_TYPE.toString());
                        }
                        WireFormatMessage serialed = WireFormatMessageFactory.toWire(outMsg, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
                        if (currentRequest.extraResponsesTimeout < 0L) {
                            res.setContentLength((int)serialed.getByteLength());
                        }
                        mustSetContentLength = false;
                        ServletOutputStream out = res.getOutputStream();
                        try {
                            serialed.sendToStream((OutputStream)out);
                            out.flush();
                            ((HttpServletMessenger)messenger).messageSent(true);
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Successfully sent " + outMsg + " on back channel to " + req.getRemoteHost());
                            }
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && transportBindingMeter != null) {
                                lastReadWriteTime = TimeUtils.timeNow();
                                long sendTime = TimeUtils.toRelativeTimeMillis(lastReadWriteTime, startMessageSend);
                                long bytesSent = serialed.getByteLength();
                                transportBindingMeter.messageSent(false, outMsg, sendTime, bytesSent);
                            }
                        }
                        catch (IOException ex) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Failed sending Message on back channel to " + req.getRemoteHost());
                            }
                            ((HttpServletMessenger)messenger).messageSent(false);
                            if (TransportMeterBuildSettings.TRANSPORT_METERING && transportBindingMeter != null) {
                                transportBindingMeter.connectionDropped(false, TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime));
                            }
                            throw ex;
                        }
                        finally {
                            res.flushBuffer();
                        }
                        quitAt = 0L == currentRequest.extraResponsesTimeout ? Long.MAX_VALUE : TimeUtils.toAbsoluteTimeMillis(currentRequest.requestStartTime, currentRequest.extraResponsesTimeout);
                        if (beganResponse) continue;
                        res.setStatus(204);
                    }
                    break block57;
                }
                res.setStatus(200);
            }
            finally {
                if (null != messenger) {
                    messenger.close();
                }
            }
        }
        if (mustSetContentLength) {
            res.setContentLength(0);
        }
        res.flushBuffer();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Finished processing the request from " + req.getRemoteHost());
        }
        if (TransportMeterBuildSettings.TRANSPORT_METERING && transportBindingMeter != null) {
            transportBindingMeter.connectionClosed(false, TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), currentRequest.requestStartTime));
        }
    }

    private void pingResponse(HttpServletResponse res) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Responding to 'ping' request with 200 and peerID");
        }
        res.setStatus(200);
        res.setContentLength(this.pingResponseBytes.length);
        res.setContentType(MimeMediaType.TEXTUTF8.toString());
        ServletOutputStream out = res.getOutputStream();
        out.write(this.pingResponseBytes);
        out.flush();
        out.close();
    }

    private static void printRequest(HttpServletRequest req) {
        int nl = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP request:\n");
        builder.append("  AUTH_TYPE: ").append(req.getAuthType()).append('\n');
        builder.append("  CONTEXT_PATH: ").append(req.getContextPath()).append('\n');
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                builder.append("  COOKIE[").append(i).append("]:\n");
                builder.append("    comment: ").append(cookies[i].getComment()).append('\n');
                builder.append("    domain: ").append(cookies[i].getDomain()).append('\n');
                builder.append("    max age: ").append(cookies[i].getMaxAge()).append('\n');
                builder.append("    name: ").append(cookies[i].getName()).append('\n');
                builder.append("    path: ").append(cookies[i].getPath()).append('\n');
                builder.append("    secure: ").append(cookies[i].getSecure()).append('\n');
                builder.append("    value: ").append(cookies[i].getValue()).append('\n');
                builder.append("    version: ").append(cookies[i].getVersion()).append('\n');
            }
        }
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            builder.append("  HEADER[").append(header).append("]: ").append(req.getHeader(header)).append('\n');
        }
        builder.append("  METHOD: ").append(req.getMethod()).append('\n');
        builder.append("  PATH_INFO: ").append(req.getPathInfo()).append('\n');
        builder.append("  PATH_TRANSLATED: ").append(req.getPathTranslated()).append('\n');
        builder.append("  QUERY_STRING: ").append(req.getQueryString()).append('\n');
        builder.append("  REMOTE_USER: ").append(req.getRemoteUser()).append('\n');
        builder.append("  REQUESTED_SESSION_ID: ").append(req.getRequestedSessionId()).append('\n');
        builder.append("  REQUEST_URI: ").append(req.getRequestURI()).append('\n');
        builder.append("  SERVLET_PATH: ").append(req.getServletPath()).append('\n');
        builder.append("  REMOTE_USER: ").append(req.getRemoteUser()).append('\n');
        builder.append("  isSessionIdFromCookie: ").append(req.isRequestedSessionIdFromCookie()).append('\n');
        builder.append("  isSessionIdFromURL: ").append(req.isRequestedSessionIdFromURL()).append('\n');
        builder.append("  isSessionIdValid: ").append(req.isRequestedSessionIdValid()).append('\n');
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            builder.append("  ATTRIBUTE[").append(attribute).append("]: ").append(req.getAttribute(attribute)).append('\n');
        }
        builder.append("  ENCODING: ").append(req.getCharacterEncoding()).append('\n');
        builder.append("  CONTENT_LENGTH: ").append(req.getContentLength()).append('\n');
        builder.append("  CONTENT_TYPE: ").append(req.getContentType()).append('\n');
        builder.append("  LOCALE: ").append(req.getLocale().toString()).append('\n');
        Enumeration parameters = req.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter2 = (String)parameters.nextElement();
            builder.append("  PARAMETER[").append(parameter2).append("]: ").append(req.getParameter(parameter2)).append('\n');
        }
        builder.append("  PROTOCOL: ").append(req.getProtocol()).append('\n');
        builder.append("  REMOTE_ADDR: ").append(req.getRemoteAddr()).append('\n');
        builder.append("  REMOTE_HOST: ").append(req.getRemoteHost()).append('\n');
        builder.append("  SCHEME: ").append(req.getScheme()).append('\n');
        builder.append("  SERVER_NAME: ").append(req.getServerName()).append('\n');
        builder.append("  SERVER_PORT: ").append(req.getServerPort()).append('\n');
        builder.append("  isSecure: ").append(req.isSecure());
        LOG.finest(builder.toString());
    }

    private static class JxtaRequest {
        final long requestStartTime = TimeUtils.timeNow();
        final EndpointAddress requestorAddr;
        final long responseTimeout;
        final long extraResponsesTimeout;
        final EndpointAddress destAddr;
        final boolean messageContent;

        JxtaRequest(HttpServletRequest req) {
            String requestorPeerId = JxtaRequest.getRequestorPeerId(req);
            this.requestorAddr = null != requestorPeerId ? new EndpointAddress("jxta", requestorPeerId, null, null) : null;
            String queryString = req.getQueryString();
            if (queryString != null) {
                int commaIndex = queryString.indexOf(44);
                if (commaIndex == -1) {
                    this.responseTimeout = JxtaRequest.getResponseTimeout(queryString);
                    this.extraResponsesTimeout = -1L;
                    this.destAddr = null;
                } else {
                    this.responseTimeout = JxtaRequest.getResponseTimeout(queryString.substring(0, commaIndex));
                    String moreQueryParams = queryString.substring(commaIndex + 1);
                    if ((commaIndex = moreQueryParams.indexOf(44)) == -1) {
                        this.extraResponsesTimeout = JxtaRequest.getExtraResponsesTimeout(moreQueryParams);
                        this.destAddr = null;
                    } else {
                        this.extraResponsesTimeout = JxtaRequest.getExtraResponsesTimeout(moreQueryParams.substring(0, commaIndex));
                        this.destAddr = new EndpointAddress(moreQueryParams.substring(commaIndex + 1));
                    }
                }
            } else {
                this.responseTimeout = 0L;
                this.extraResponsesTimeout = -1L;
                this.destAddr = null;
            }
            this.messageContent = JxtaRequest.hasMessageContent(req);
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("New JXTA Request for Requestor=" + this.requestorAddr + "\n\tResponse Timeout=" + this.responseTimeout + "\tAdditional Response Timeout=" + this.extraResponsesTimeout + "\tRequest Destination Address=" + this.destAddr + "\tHas Message Content=" + Boolean.toString(this.messageContent));
            }
        }

        private static String getRequestorPeerId(HttpServletRequest req) {
            String requestorPeerId = req.getPathInfo();
            if (null != requestorPeerId) {
                int begin;
                int end = requestorPeerId.length();
                for (begin = 0; begin < end && requestorPeerId.charAt(begin) == '/'; ++begin) {
                }
                while (end - begin > 0 && requestorPeerId.charAt(end - 1) == '/') {
                    --end;
                }
                requestorPeerId = begin == end ? null : requestorPeerId.substring(begin, end);
            }
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("requestorPeerId = " + requestorPeerId);
            }
            return requestorPeerId;
        }

        private static long getResponseTimeout(String requestTimeoutString) {
            long timeout;
            block4: {
                timeout = -1L;
                try {
                    timeout = Long.parseLong(requestTimeoutString);
                    if (timeout > 120000L || timeout == 0L) {
                        timeout = 120000L;
                    }
                }
                catch (NumberFormatException e) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                    LOG.warning("The requestTimeout does not contain a decimal number " + requestTimeoutString);
                }
            }
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("requestTimeout = " + timeout);
            }
            return timeout;
        }

        private static long getExtraResponsesTimeout(String extraResponseTimeoutString) {
            long timeout;
            block4: {
                timeout = -1L;
                try {
                    timeout = Long.parseLong(extraResponseTimeoutString);
                    if (timeout > 120000L || timeout == 0L) {
                        timeout = 120000L;
                    }
                }
                catch (NumberFormatException e) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                    LOG.warning("The extraResponseTimeoutString does not contain a decimal number " + extraResponseTimeoutString);
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("extraResponseTimeout = " + timeout);
            }
            return timeout;
        }

        private static boolean hasMessageContent(HttpServletRequest req) {
            boolean hasContent = false;
            int contentLength = req.getContentLength();
            if (contentLength > 0) {
                hasContent = true;
            } else if (contentLength == -1) {
                String transferEncoding = req.getHeader("Transfer-Encoding");
                hasContent = "chunked".equals(transferEncoding);
            }
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("hasMessageContent = " + hasContent);
            }
            return hasContent;
        }
    }
}

