/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMetric;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportMetric
implements DocumentSerializable {
    private String protocol;
    private EndpointAddress endpointAddress;
    private HashMap<EndpointAddress, TransportBindingMetric> transportBindingMetrics = new HashMap();

    public TransportMetric(TransportMeter transportMeter) {
        this.endpointAddress = transportMeter.getEndpointAddress();
        this.protocol = transportMeter.getProtocol();
    }

    public TransportMetric() {
    }

    public TransportMetric(TransportMetric prototype) {
        this.endpointAddress = prototype.endpointAddress;
        this.protocol = prototype.protocol;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransportMetric) {
            TransportMetric other = (TransportMetric)obj;
            return this.protocol.equals(other.protocol) && this.endpointAddress.equals(other.endpointAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.endpointAddress.hashCode();
    }

    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public synchronized void addTransportBindingMetric(TransportBindingMetric transportBindingMetric) {
        this.transportBindingMetrics.put(transportBindingMetric.getEndpointAddress(), transportBindingMetric);
    }

    public TransportBindingMetric getTransportBindingMetric(EndpointAddress endpointAddress) {
        return this.transportBindingMetrics.get(endpointAddress);
    }

    public TransportBindingMetric getTransportBindingMetric(TransportBindingMetric prototype) {
        return this.getTransportBindingMetric(prototype.getEndpointAddress());
    }

    public Iterator<TransportBindingMetric> getTransportBindingMetrics() {
        return this.transportBindingMetrics.values().iterator();
    }

    public int getTransportBindingMetricsCount() {
        return this.transportBindingMetrics.size();
    }

    @Override
    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "endpointAddress", this.endpointAddress.toString());
        DocumentSerializableUtilities.addString(element2, "protocol", this.protocol);
        Iterator<TransportBindingMetric> i = this.getTransportBindingMetrics();
        while (i.hasNext()) {
            TransportBindingMetric transportBindingMetric = i.next();
            DocumentSerializableUtilities.addDocumentSerializable(element2, "binding", transportBindingMetric);
        }
    }

    @Override
    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("endpointAddress")) {
                String endpointAddressString = DocumentSerializableUtilities.getString(childElement);
                this.endpointAddress = new EndpointAddress(endpointAddressString);
                continue;
            }
            if (tagName.equals("protocol")) {
                this.protocol = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (!tagName.equals("binding")) continue;
            TransportBindingMetric transportBindingMetric = (TransportBindingMetric)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, TransportBindingMetric.class);
            this.transportBindingMetrics.put(transportBindingMetric.getEndpointAddress(), transportBindingMetric);
        }
    }

    void mergeMetrics(TransportMetric otherTransportMetric) {
        Iterator<TransportBindingMetric> i = otherTransportMetric.getTransportBindingMetrics();
        while (i.hasNext()) {
            TransportBindingMetric otherTransportBindingMetric = i.next();
            TransportBindingMetric transportBindingMetric = this.getTransportBindingMetric(otherTransportBindingMetric.getEndpointAddress());
            if (transportBindingMetric == null) {
                transportBindingMetric = new TransportBindingMetric(otherTransportBindingMetric);
                this.addTransportBindingMetric(transportBindingMetric);
            }
            transportBindingMetric.mergeMetrics(otherTransportBindingMetric);
        }
    }
}

