/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.CBID;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.util.logging.Logger;
import net.jxta.id.ID;
import net.jxta.impl.id.CBID.IDFormat;
import net.jxta.impl.id.CBID.PeerGroupID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public class CodatID
extends net.jxta.impl.id.UUID.CodatID {
    private static final transient Logger LOG = Logger.getLogger(CodatID.class.getName());

    protected CodatID() {
    }

    protected CodatID(IDBytes id) {
        super(id);
    }

    public CodatID(PeerGroupID groupID) {
        super(groupID.getUUID(), UUIDFactory.newUUID());
    }

    public CodatID(PeerGroupID groupID, byte[] seed) {
        this();
        UUID groupCBID = groupID.getUUID();
        this.id.longIntoBytes(0, groupCBID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupCBID.getLeastSignificantBits());
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException caught) {
            digester = null;
        }
        if (digester == null) {
            throw new ProviderException("SHA1 digest algorithm not found");
        }
        byte[] digest = digester.digest(seed);
        byte[] buf16 = new byte[16];
        System.arraycopy(digest, 0, buf16, 0, 16);
        UUID peerCBID = UUIDFactory.newUUID(buf16);
        this.id.longIntoBytes(16, peerCBID.getMostSignificantBits());
        this.id.longIntoBytes(24, peerCBID.getLeastSignificantBits());
    }

    public CodatID(PeerGroupID groupID, InputStream in) throws IOException {
        super((net.jxta.impl.id.UUID.PeerGroupID)groupID, in);
    }

    public CodatID(PeerGroupID groupID, byte[] seed, InputStream in) throws IOException {
        this(groupID, seed);
        this.setHash(in);
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public ID getPeerGroupID() {
        UUID groupCBID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupCBID);
        return IDFormat.translateToWellKnown(groupID);
    }

    public UUID getUUID() {
        return new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
    }
}

