/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public class PipeID
extends net.jxta.pipe.PipeID {
    protected static final int groupIdOffset = 0;
    protected static final int idOffset = 16;
    protected static final int padOffset = 32;
    protected static final int padSize = 31;
    protected IDBytes id;

    protected PipeID() {
        this.id = new IDBytes(4);
    }

    protected PipeID(IDBytes id) {
        this.id = id;
    }

    protected PipeID(UUID groupUUID, UUID idUUID) {
        this();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, idUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, idUUID.getLeastSignificantBits());
    }

    public PipeID(PeerGroupID groupID) {
        this(groupID.getUUID(), UUIDFactory.newUUID());
    }

    public PipeID(PeerGroupID groupID, byte[] seed) {
        this();
        UUID groupUUID = groupID.getUUID();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        for (int copySeed = Math.min(16, seed.length) - 1; copySeed >= 0; --copySeed) {
            this.id.bytes[copySeed + 16] = seed[copySeed];
        }
        this.id.bytes[22] = (byte)(this.id.bytes[22] & 0xF);
        this.id.bytes[22] = (byte)(this.id.bytes[22] | 0x40);
        this.id.bytes[24] = (byte)(this.id.bytes[24] & 0x3F);
        this.id.bytes[24] = (byte)(this.id.bytes[24] | 0x80);
        this.id.bytes[26] = (byte)(this.id.bytes[26] & 0x3F);
        this.id.bytes[26] = (byte)(this.id.bytes[26] | 0x80);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof PipeID) {
            PipeID pipeTarget = (PipeID)target;
            return this.id.equals(pipeTarget.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public ID getPeerGroupID() {
        UUID groupUUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return IDFormat.translateToWellKnown(groupID);
    }
}

