/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.binaryID.BinaryID;
import net.jxta.impl.id.binaryID.BinaryIDFactory;
import net.jxta.impl.id.binaryID.IDFormat;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;

public final class PeerBinaryID
extends PeerID {
    private static final transient Logger LOG = Logger.getLogger(PeerBinaryID.class.getName());
    private String id;

    private PeerBinaryID() {
    }

    protected PeerBinaryID(String id) {
        this.id = id;
    }

    public PeerBinaryID(BinaryID binaryID) {
        this.id = binaryID.getID();
    }

    public PeerBinaryID(PeerGroupID parent, byte[] data, boolean lengthIncluded) {
        this();
        String parentStr = IDFormat.childGroup(parent);
        this.id = BinaryIDFactory.newBinaryID((byte)98, data, lengthIncluded).getID() + "." + parentStr.replace('-', '.');
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        return target instanceof PeerBinaryID && this.getUniqueValue().equals(((PeerBinaryID)target).getUniqueValue());
    }

    public int hashCode() {
        return this.getUniqueValue().hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        if (null == this.id) {
            return ID.nullID.getUniqueValue();
        }
        return this.getIDFormat() + "-" + this.id;
    }

    public ID getPeerGroupID() {
        try {
            if (this.id == null) {
                return ID.nullID;
            }
            String idd = this.id;
            int parentStart = idd.indexOf(46);
            if (parentStart == -1) {
                return null;
            }
            idd = idd.substring(parentStart + 1);
            URI url = new URI("urn:jxta:" + idd.replace('.', '-'));
            PeerGroupID peerGroupID = (PeerGroupID)IDFactory.fromURI(url);
            return peerGroupID;
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("cannot convert sub group. ID value = " + this.id);
            }
            return null;
        }
    }

    protected String getID() {
        return this.id;
    }
}

