/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdPeerGroup
extends GenericPeerGroup {
    private static final transient Logger LOG;
    public static final XMLDocument STD_COMPAT;
    public static final String MODULE_IMPL_STD_URI = "http://jxta-jxse.dev.java.net/download/jxta.jar";
    public static final String MODULE_IMPL_STD_PROVIDER = "sun.com";
    protected static final String STD_COMPAT_FORMAT = "Efmt";
    protected static final String STD_COMPAT_FORMAT_VALUE = "JDK1.4.1";
    protected static final String STD_COMPAT_BINDING = "Bind";
    protected static final String STD_COMPAT_BINDING_VALUE = "V2.0 Ref Impl";
    private volatile boolean started = false;
    private final int COREPOOLSIZE = 5;
    private final int MAXPOOLSIZE = 50;
    private final long KEEPALIVETIME = 15L;
    private final List<ModuleClassID> moduleStartOrder = new ArrayList<ModuleClassID>();
    private final Map<ModuleClassID, Object> messageTransports = new HashMap<ModuleClassID, Object>();
    private final Map<ModuleClassID, Object> applications = new HashMap<ModuleClassID, Object>();
    private Cm cm = null;
    private ThreadPoolExecutor threadPool;
    private BlockingQueue<Runnable> taskQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerFromFile(URI providerList) {
        boolean registeredSomething = false;
        InputStream urlStream = null;
        try {
            String provider;
            urlStream = providerList.toURL().openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream, "UTF-8"));
            while ((provider = reader.readLine()) != null) {
                int comment = provider.indexOf(35);
                if (comment != -1) {
                    provider = provider.substring(0, comment);
                }
                if ((provider = provider.trim()).length() <= 0) continue;
                try {
                    String[] parts = provider.split("\\s", 3);
                    if (3 == parts.length) {
                        ModuleSpecID msid = ModuleSpecID.create(URI.create(parts[0]));
                        ModuleImplAdvertisement moduleImplAdv = StdPeerGroup.mkImplAdvBuiltin(msid, parts[1], parts[2]);
                        StdPeerGroup.getJxtaLoader().defineClass(moduleImplAdv);
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("Registered Module " + msid + " : " + parts[1]);
                        continue;
                    }
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Failed to register '" + provider + "'");
                }
                catch (Exception allElse) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Failed to register '" + provider + "'", allElse);
                }
            }
        }
        catch (IOException ex) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to read provider list " + providerList, ex);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != urlStream) {
                try {
                    urlStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return registeredSomething;
    }

    private static XMLDocument mkCS() {
        XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Comp");
        Object e = doc.createElement(STD_COMPAT_FORMAT, STD_COMPAT_FORMAT_VALUE);
        doc.appendChild(e);
        e = doc.createElement(STD_COMPAT_BINDING, STD_COMPAT_BINDING_VALUE);
        doc.appendChild(e);
        return doc;
    }

    protected static ModuleImplAdvertisement mkImplAdvBuiltin(ModuleSpecID specID, String code, String descr) {
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        implAdv.setModuleSpecID(specID);
        implAdv.setCompat(STD_COMPAT);
        implAdv.setCode(code);
        implAdv.setUri(MODULE_IMPL_STD_URI);
        implAdv.setProvider(MODULE_IMPL_STD_PROVIDER);
        implAdv.setDescription(descr);
        return implAdv;
    }

    @Override
    public boolean compatible(Element compat) {
        return StdPeerGroup.isCompatible(compat);
    }

    static boolean isCompatible(Element compat) {
        boolean formatOk = false;
        boolean bindingOk = false;
        try {
            Enumeration hisChildren = compat.getChildren();
            int i = 0;
            while (hisChildren.hasMoreElements()) {
                if (++i > 2) {
                    return false;
                }
                Element e = (Element)hisChildren.nextElement();
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                if (STD_COMPAT_FORMAT.equals(key)) {
                    String version;
                    boolean specMatches;
                    Package javaLangPackage = Package.getPackage("java.lang");
                    if (val.startsWith("JDK") || val.startsWith("JRE")) {
                        specMatches = true;
                        version = val.substring(3).trim();
                    } else if (val.startsWith(javaLangPackage.getSpecificationTitle())) {
                        specMatches = true;
                        version = val.substring(javaLangPackage.getSpecificationTitle().length()).trim();
                    } else {
                        specMatches = false;
                        version = null;
                    }
                    formatOk = specMatches && javaLangPackage.isCompatibleWith(version);
                    continue;
                }
                if (STD_COMPAT_BINDING.equals(key) && STD_COMPAT_BINDING_VALUE.equals(val)) {
                    bindingOk = true;
                    continue;
                }
                return false;
            }
        }
        catch (Exception any) {
            return false;
        }
        return formatOk && bindingOk;
    }

    protected void loadAllModules(Map<ModuleClassID, Object> modules, boolean privileged) {
        Iterator<Map.Entry<ModuleClassID, Object>> eachModule = modules.entrySet().iterator();
        while (eachModule.hasNext()) {
            Map.Entry<ModuleClassID, Object> anEntry = eachModule.next();
            ModuleClassID classID = anEntry.getKey();
            Object value = anEntry.getValue();
            if (value instanceof Module) continue;
            try {
                Module theModule = null;
                if (value instanceof ModuleImplAdvertisement) {
                    theModule = this.loadModule((ID)classID, (ModuleImplAdvertisement)value, privileged);
                } else if (value instanceof ModuleSpecID) {
                    theModule = this.loadModule(classID, (ModuleSpecID)value, 1, privileged);
                } else {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Skipping: " + classID + " Unsupported module descriptor : " + value.getClass().getName());
                    }
                    eachModule.remove();
                    continue;
                }
                if (theModule == null) {
                    throw new PeerGroupException("Could not find a loadable implementation for : " + classID);
                }
                anEntry.setValue(theModule);
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Could not load module for class ID : " + classID, e);
                    if (value instanceof ModuleImplAdvertisement) {
                        LOG.log(Level.WARNING, "Will be missing from peer group : " + ((ModuleImplAdvertisement)value).getDescription());
                    } else {
                        LOG.log(Level.WARNING, "Will be missing from peer group: " + value);
                    }
                }
                eachModule.remove();
            }
        }
    }

    @Override
    public int startApp(String[] arg) {
        if (!this.initComplete) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Group has not been initialized or init failed.");
            }
            return -1;
        }
        if (this.started) {
            return 0;
        }
        this.started = true;
        int res = super.startApp(arg);
        if (0 != res) {
            return res;
        }
        this.loadAllModules(this.applications, false);
        res = 0;
        Iterator<ModuleClassID> appKeys = this.applications.keySet().iterator();
        while (appKeys.hasNext()) {
            ModuleClassID appKey = appKeys.next();
            Module app = (Module)this.applications.get(appKey);
            int tmp = app.startApp(arg);
            if (tmp != 0) {
                appKeys.remove();
            } else {
                this.applications.put(appKey, app);
            }
            res += tmp;
        }
        return res;
    }

    @Override
    public void stopApp() {
        for (Object o : this.applications.values()) {
            Module module = null;
            try {
                module = (Module)o;
                module.stopApp();
            }
            catch (Exception any) {
                if (module == null || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Failed to stop application: " + module.getClass().getName(), any);
            }
        }
        this.applications.clear();
        this.threadPool.shutdownNow();
        Collections.reverse(this.moduleStartOrder);
        for (ModuleClassID aModule : this.moduleStartOrder) {
            try {
                if (this.messageTransports.containsKey(aModule)) {
                    Module theMessageTransport = (Module)this.messageTransports.remove(aModule);
                    theMessageTransport.stopApp();
                    continue;
                }
                this.removeService(aModule);
            }
            catch (Exception any) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Failed to stop module: " + aModule, any);
            }
        }
        this.moduleStartOrder.clear();
        if (!this.messageTransports.isEmpty()) {
            LOG.warning(this.messageTransports.size() + " message transports could not be shut down during peer group stop.");
        }
        this.messageTransports.clear();
        super.stopApp();
        if (this.cm != null) {
            this.cm.stop();
            this.cm = null;
        }
    }

    @Override
    protected synchronized void initFirst(PeerGroup parent, ID assignedID, Advertisement impl) throws PeerGroupException {
        block31: {
            if (this.initComplete) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("You cannot initialize a PeerGroup more than once !");
                }
                return;
            }
            super.initFirst(parent, assignedID, impl);
            assignedID = this.getPeerGroupID();
            this.taskQueue = new ArrayBlockingQueue<Runnable>(100);
            this.threadPool = new ThreadPoolExecutor(5, 50, 15L, TimeUnit.SECONDS, this.taskQueue, new PeerGroupThreadFactory(this.getHomeThreadGroup()), new CallerBlocksPolicy(50));
            try {
                this.cm = new Cm(this.getHomeThreadGroup(), this.getStoreHome(), assignedID.getUniqueValue().toString(), 3600000L, false);
            }
            catch (Exception e) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Error during creation of local store", e);
                }
                throw new PeerGroupException("Error during creation of local store", e);
            }
            SrdiIndex.clearSrdi(this);
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(implAdv.getParam());
            HashMap<ModuleClassID, Object> initServices = new HashMap<ModuleClassID, Object>(paramAdv.getServices());
            initServices.putAll(paramAdv.getProtos());
            ConfigParams conf = this.getConfigAdvertisement();
            if (conf != null) {
                for (Map.Entry<ID, StructuredDocument> anEntry : conf.getServiceParamsEntrySet()) {
                    Element e = anEntry.getValue();
                    if (!e.getChildren("isOff").hasMoreElements()) continue;
                    Object value = initServices.remove((ModuleClassID)anEntry.getKey());
                    if (value instanceof ModuleImplAdvertisement) {
                        if (!Logging.SHOW_CONFIG || !LOG.isLoggable(Level.CONFIG)) continue;
                        LOG.config("Module disabled by configuration : " + ((ModuleImplAdvertisement)value).getDescription());
                        continue;
                    }
                    if (!Logging.SHOW_CONFIG || !LOG.isLoggable(Level.CONFIG)) continue;
                    LOG.config("Module disabled by configuration : " + value);
                }
            }
            this.loadAllModules(initServices, true);
            this.applications.putAll(paramAdv.getApps());
            int iterations = 0;
            int maxIterations = initServices.size() * initServices.size() + iterations + 1;
            boolean progress = true;
            while (!initServices.isEmpty() && (progress || iterations < maxIterations)) {
                progress = false;
                ++iterations;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine(MessageFormat.format("Service startApp() round {0} of {1}(max)", iterations, maxIterations));
                }
                Iterator eachService = initServices.entrySet().iterator();
                block15: while (eachService.hasNext()) {
                    int res;
                    Map.Entry anEntry = eachService.next();
                    ModuleClassID mcid = (ModuleClassID)anEntry.getKey();
                    Module aModule = (Module)anEntry.getValue();
                    try {
                        res = aModule.startApp(null);
                    }
                    catch (Throwable all) {
                        if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.log(Level.SEVERE, "Exception in startApp() : " + aModule, all);
                        }
                        res = -1;
                    }
                    switch (res) {
                        case 0: {
                            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                                LOG.info("Module started : " + aModule);
                            }
                            if (aModule instanceof Service) {
                                this.addService(mcid, (Service)aModule);
                            } else {
                                this.messageTransports.put(mcid, aModule);
                            }
                            this.moduleStartOrder.add(mcid);
                            eachService.remove();
                            progress = true;
                            continue block15;
                        }
                        case 1: {
                            progress = true;
                            continue block15;
                        }
                        case 2: {
                            continue block15;
                        }
                    }
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Service failed to start (" + res + ") : " + aModule);
                    }
                    eachService.remove();
                    progress = true;
                }
                if (!progress) continue;
                maxIterations = initServices.size() * initServices.size() + iterations + 1;
            }
            if (!initServices.isEmpty()) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    StringBuilder failed = new StringBuilder("No progress is being made in starting services after " + iterations + " iterations. Giving up.");
                    failed.append("\nThe following services could not be started : ");
                    for (Map.Entry aService : initServices.entrySet()) {
                        failed.append("\n\t");
                        failed.append(aService.getKey());
                        failed.append(" : ");
                        failed.append(aService.getValue());
                    }
                    LOG.severe(failed.toString());
                }
                throw new PeerGroupException("No progress is being made in starting services. Giving up.");
            }
            try {
                this.checkServices();
            }
            catch (ServiceNotFoundException e) {
                LOG.log(Level.SEVERE, "Missing peer group service", e);
                throw new PeerGroupException("Missing peer group service", e);
            }
            DiscoveryService discoveryService = this.getDiscoveryService();
            if (discoveryService != null) {
                try {
                    discoveryService.publish(discoveryService.getImplAdvertisement(), 31536000000L, 1209600000L);
                    discoveryService.publish(implAdv, 31536000000L, 1209600000L);
                }
                catch (Exception nevermind) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block31;
                    LOG.log(Level.WARNING, "Failed to publish Impl adv within group.", nevermind);
                }
            }
        }
    }

    @Override
    protected synchronized void initLast() throws PeerGroupException {
        super.initLast();
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Group : " + this.getPeerGroupID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tCompatibility Statement :\n\t\t\t");
            StringBuilder indent = new StringBuilder(STD_COMPAT.toString().trim());
            int from = indent.length();
            while (from > 0) {
                int returnAt = indent.lastIndexOf("\n", from);
                from = returnAt - 1;
                if (returnAt < 0 || returnAt == indent.length()) continue;
                indent.insert(returnAt + 1, "\t\t\t");
            }
            configInfo.append((CharSequence)indent);
            Iterator<Map.Entry<ModuleClassID, Object>> eachProto = this.messageTransports.entrySet().iterator();
            if (eachProto.hasNext()) {
                configInfo.append("\n\t\tMessage Transports :");
            }
            while (eachProto.hasNext()) {
                Map.Entry<ModuleClassID, Object> anEntry = eachProto.next();
                ModuleClassID aMCID = anEntry.getKey();
                Module anMT = (Module)anEntry.getValue();
                configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(anMT instanceof MessageTransport ? ((MessageTransport)((Object)anMT)).getProtocolName() : anMT.getClass().getName());
            }
            Iterator<Map.Entry<ModuleClassID, Object>> eachApp = this.applications.entrySet().iterator();
            if (eachApp.hasNext()) {
                configInfo.append("\n\t\tApplications :");
            }
            while (eachApp.hasNext()) {
                Map.Entry<ModuleClassID, Object> anEntry = eachApp.next();
                ModuleClassID aMCID = anEntry.getKey();
                Object anApp = anEntry.getValue();
                if (anApp instanceof ModuleImplAdvertisement) {
                    ModuleImplAdvertisement adv = (ModuleImplAdvertisement)anApp;
                    configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(adv.getCode());
                    continue;
                }
                configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(anApp.getClass().getName());
            }
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() {
        JxtaLoader loader = StdPeerGroup.getJxtaLoader();
        ModuleImplAdvertisement implAdv = loader.findModuleImplAdvertisement(PeerGroup.allPurposePeerGroupSpecID);
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        ModuleImplAdvertisement moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refEndpointSpecID);
        paramAdv.addService(PeerGroup.endpointClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refResolverSpecID);
        paramAdv.addService(PeerGroup.resolverClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refMembershipSpecID);
        paramAdv.addService(PeerGroup.membershipClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refAccessSpecID);
        paramAdv.addService(PeerGroup.accessClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refDiscoverySpecID);
        paramAdv.addService(PeerGroup.discoveryClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refRendezvousSpecID);
        paramAdv.addService(PeerGroup.rendezvousClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refPipeSpecID);
        paramAdv.addService(PeerGroup.pipeClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refPeerinfoSpecID);
        paramAdv.addService(PeerGroup.peerinfoClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refShellSpecID);
        if (null != moduleAdv) {
            paramAdv.addApp(PeerGroup.applicationClassID, moduleAdv);
        }
        XMLElement paramElement = (XMLElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public Cm getCacheManager() {
        return this.cm;
    }

    public Map<ModuleClassID, Object> getApplications() {
        return Collections.unmodifiableMap(this.applications);
    }

    public Executor getExecutor() {
        return this.threadPool;
    }

    static {
        block5: {
            LOG = Logger.getLogger(StdPeerGroup.class.getName());
            STD_COMPAT = StdPeerGroup.mkCS();
            try {
                Enumeration<URL> providerLists = GenericPeerGroup.class.getClassLoader().getResources("META-INF/services/net.jxta.platform.Module");
                while (providerLists.hasMoreElements()) {
                    try {
                        URI providerList = providerLists.nextElement().toURI();
                        StdPeerGroup.registerFromFile(providerList);
                    }
                    catch (URISyntaxException badURI) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "Failed to convert service URI", badURI);
                    }
                }
            }
            catch (IOException ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Failed to locate provider lists", ex);
            }
        }
    }

    static class PeerGroupThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final ThreadGroup threadgroup;

        PeerGroupThreadFactory(ThreadGroup threadgroup) {
            this.threadgroup = threadgroup;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadgroup, r, "Executor - " + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class CallerBlocksPolicy
    implements RejectedExecutionHandler {
        private final int MAXPOOLSIZE;

        private CallerBlocksPolicy(int maxPoolSize) {
            this.MAXPOOLSIZE = maxPoolSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            while (!executor.isShutdown()) {
                executor.purge();
                try {
                    boolean pushed = queue.offer(runnable, 500L, TimeUnit.MILLISECONDS);
                    if (pushed) {
                        break;
                    }
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                    continue;
                }
                ThreadPoolExecutor threadPoolExecutor = executor;
                synchronized (threadPoolExecutor) {
                    int currentMax = executor.getMaximumPoolSize();
                    int newMax = Math.min(currentMax + 1, this.MAXPOOLSIZE * 2);
                    if (newMax != currentMax) {
                        executor.setMaximumPoolSize(newMax);
                    }
                    if (newMax == this.MAXPOOLSIZE * 2) {
                        int newCore;
                        int currentCore = executor.getCorePoolSize();
                        if (currentCore != (newCore = Math.min(currentCore + 1, this.MAXPOOLSIZE * 2))) {
                            executor.setCorePoolSize(newCore);
                        } else {
                            continue;
                        }
                    }
                }
                executor.execute(runnable);
                break;
            }
        }
    }
}

