/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.protocol.RdvAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaseResponseMsg {
    private static final transient Logger LOG = Logger.getLogger(LeaseResponseMsg.class.getName());
    private static final String OFFERED_LEASE_ATTR = "offeredLease";
    private static final String SERVER_ID_ATTR = "serverID";
    private static final String SERVER_ADV_TAG = "serverAdv";
    private static final String ADV_GEN_ATTR = "advGen";
    private static final String ADV_EXP_ATTR = "expiration";
    private static final String REFERRAL_ADV_TAG = "referralAdv";
    private static final String SERVER_CRED_TAG = "credential";
    private ID serverID = null;
    private RdvAdvertisement serverAdv = null;
    private long serverAdvExp = Long.MIN_VALUE;
    private UUID serverAdvGen = null;
    private XMLElement credential = null;
    private List<RdvAdvertisement> referralAdvs = new ArrayList<RdvAdvertisement>();
    private List<Long> referralAdvExps = new ArrayList<Long>();
    private long offeredLease = Long.MIN_VALUE;

    public LeaseResponseMsg() {
    }

    public LeaseResponseMsg(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doc.getName().equals(LeaseResponseMsg.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + doc.getName() + "'. Should be : " + LeaseResponseMsg.getMessageType());
        }
        Enumeration<Attribute> eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute aRdvAttr = eachAttr.nextElement();
            if (SERVER_ID_ATTR.equals(aRdvAttr.getName())) {
                try {
                    URI srcURI = new URI(aRdvAttr.getValue());
                    ID srcID = IDFactory.fromURI(srcURI);
                    this.setServerID(srcID);
                    continue;
                }
                catch (URISyntaxException badID) {
                    IllegalArgumentException iae = new IllegalArgumentException("Bad server ID in message");
                    iae.initCause(badID);
                    throw iae;
                }
            }
            if (OFFERED_LEASE_ATTR.equals(aRdvAttr.getName())) {
                this.offeredLease = Long.valueOf(aRdvAttr.getValue());
                continue;
            }
            if ("type".equals(aRdvAttr.getName()) || "xmlns:jxta".equals(aRdvAttr.getName()) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Attribute: " + aRdvAttr.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Element: " + elem.toString());
        }
        if (null == this.serverID) {
            throw new IllegalArgumentException("Missing Server ID.");
        }
        if (null != this.serverAdv && null == this.serverAdvGen) {
            throw new IllegalArgumentException("Missing Server Advertisement Generation.");
        }
        if (null != this.serverAdv && Long.MIN_VALUE == this.serverAdvExp) {
            throw new IllegalArgumentException("Missing Server Advertisement Expiration.");
        }
        if (null != this.serverAdv && this.serverAdvExp <= 0L) {
            throw new IllegalArgumentException("Illegal Server Advertisement Expiration.");
        }
        if (this.offeredLease < 0L && Long.MIN_VALUE != this.offeredLease) {
            throw new IllegalArgumentException("Illegal Lease offered.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LeaseResponseMsg clone = (LeaseResponseMsg)super.clone();
        clone.setServerID(this.getServerID());
        clone.setServerAdv(this.getServerAdv(), this.getServerAdvGen(), this.getServerAdvExp());
        clone.setCredential(this.getCredential());
        clone.addReferralAdvs(Arrays.asList(this.getReferralAdvs()), Arrays.asList(this.getReferralAdvExps()));
        clone.setOfferedLease(this.getOfferedLease());
        return clone;
    }

    public ID getServerID() {
        return this.serverID;
    }

    public void setServerID(ID serverID) {
        this.serverID = serverID;
    }

    public RdvAdvertisement getServerAdv() {
        return this.serverAdv;
    }

    public UUID getServerAdvGen() {
        return this.serverAdvGen;
    }

    public long getServerAdvExp() {
        return this.serverAdvExp;
    }

    public void setServerAdv(RdvAdvertisement serverAdv, UUID serverAdvGen, long serverAdvExp) {
        this.serverAdv = serverAdv;
        this.serverAdvGen = serverAdvGen;
        this.serverAdvExp = serverAdvExp;
    }

    public RdvAdvertisement[] getReferralAdvs() {
        return this.referralAdvs.toArray(new RdvAdvertisement[this.referralAdvs.size()]);
    }

    public Long[] getReferralAdvExps() {
        return this.referralAdvExps.toArray(new Long[this.referralAdvExps.size()]);
    }

    public void addReferralAdv(RdvAdvertisement referralAdv, long referralAdvExp) {
        this.referralAdvs.add(referralAdv);
        this.referralAdvExps.add(referralAdvExp);
    }

    public void addReferralAdvs(List<RdvAdvertisement> referralAdvs, List<Long> referralAdvExps) {
        this.referralAdvs.addAll(referralAdvs);
        this.referralAdvExps.addAll(referralAdvExps);
    }

    public void clearReferralAdvs() {
        this.referralAdvs.clear();
        this.referralAdvExps.clear();
    }

    public long getOfferedLease() {
        return this.offeredLease;
    }

    public void setOfferedLease(long offeredLease) {
        this.offeredLease = offeredLease;
    }

    public XMLElement getCredential() {
        return (XMLElement)((Object)(null != this.credential ? StructuredDocumentUtils.copyAsDocument(this.credential) : null));
    }

    public void setCredential(XMLElement newCred) {
        this.credential = (XMLElement)((Object)(null != newCred ? StructuredDocumentUtils.copyAsDocument(newCred) : null));
    }

    public static String getMessageType() {
        return "jxta:LeaseResponseMsg";
    }

    protected boolean handleElement(XMLElement elem) {
        if (SERVER_ADV_TAG.equals(elem.getName())) {
            Enumeration<Attribute> eachAttr = elem.getAttributes();
            while (eachAttr.hasMoreElements()) {
                Attribute anAdvAttr = eachAttr.nextElement();
                if (ADV_GEN_ATTR.equals(anAdvAttr.getName())) {
                    this.serverAdvGen = UUID.fromString(anAdvAttr.getValue());
                    continue;
                }
                if (ADV_EXP_ATTR.equals(anAdvAttr.getName())) {
                    this.serverAdvExp = Long.valueOf(anAdvAttr.getValue());
                    continue;
                }
                if ("type".equals(anAdvAttr.getName()) || "xmlns:jxta".equals(anAdvAttr.getName()) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Attribute: " + anAdvAttr.getName());
            }
            this.serverAdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(elem);
            return true;
        }
        if (REFERRAL_ADV_TAG.equals(elem.getName())) {
            long expiration = Long.MIN_VALUE;
            Enumeration<Attribute> eachAttr = elem.getAttributes();
            while (eachAttr.hasMoreElements()) {
                Attribute anAdvAttr = eachAttr.nextElement();
                if (ADV_EXP_ATTR.equals(anAdvAttr.getName())) {
                    expiration = Long.valueOf(anAdvAttr.getValue());
                    continue;
                }
                if ("type".equals(anAdvAttr.getName()) || "xmlns:jxta".equals(anAdvAttr.getName()) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Attribute: " + anAdvAttr.getName());
            }
            if (Long.MIN_VALUE == expiration) {
                throw new IllegalArgumentException("Missing Referral Advertisement Expiration.");
            }
            if (expiration <= 0L) {
                throw new IllegalArgumentException("Illegal Referral Advertisement Expiration.");
            }
            RdvAdvertisement referralAdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(elem);
            referralAdv.getRouteAdv().setDestPeerID(referralAdv.getPeerID());
            this.referralAdvs.add(referralAdv);
            this.referralAdvExps.add(expiration);
            return true;
        }
        if (SERVER_CRED_TAG.equals(elem.getName())) {
            this.credential = (XMLElement)((Object)StructuredDocumentUtils.copyAsDocument(elem));
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType mediaType) {
        Element e;
        if (null == this.serverID) {
            throw new IllegalStateException("Missing Server ID.");
        }
        if (null != this.serverAdv && null == this.serverAdvGen) {
            throw new IllegalStateException("Missing Server Advertisement Generation.");
        }
        if (null != this.serverAdv && Long.MIN_VALUE == this.serverAdvExp) {
            throw new IllegalStateException("Missing Server Advertisement Expiration.");
        }
        if (null != this.serverAdv && this.serverAdvExp <= 0L) {
            throw new IllegalStateException("Illegal Server Advertisement Expiration.");
        }
        if (this.offeredLease < 0L && Long.MIN_VALUE != this.offeredLease) {
            throw new IllegalStateException("Illegal Lease offered.");
        }
        StructuredDocument msg = StructuredDocumentFactory.newStructuredDocument(mediaType, LeaseResponseMsg.getMessageType());
        if (!(msg instanceof Attributable)) {
            throw new UnsupportedOperationException("Only 'Attributable' document types are supported.");
        }
        if (msg instanceof XMLDocument) {
            ((XMLDocument)msg).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        ((Attributable)((Object)msg)).addAttribute(SERVER_ID_ATTR, this.getServerID().toString());
        if (Long.MIN_VALUE != this.offeredLease) {
            ((Attributable)((Object)msg)).addAttribute(OFFERED_LEASE_ATTR, Long.toString(this.getOfferedLease()));
        }
        if (null != this.credential) {
            StructuredDocumentUtils.copyElements(msg, msg, this.credential, SERVER_CRED_TAG);
        }
        if (null != this.serverAdv) {
            e = StructuredDocumentUtils.copyElements(msg, msg, (StructuredDocument)this.serverAdv.getDocument(mediaType), SERVER_ADV_TAG);
            if (null != this.getServerAdvGen()) {
                ((Attributable)((Object)e)).addAttribute(ADV_GEN_ATTR, this.getServerAdvGen().toString());
            }
            if (Long.MIN_VALUE != this.getServerAdvExp()) {
                ((Attributable)((Object)e)).addAttribute(ADV_EXP_ATTR, Long.toString(this.getServerAdvExp()));
            }
        }
        Iterator<Long> eachReferralAdvExp = this.referralAdvExps.iterator();
        for (RdvAdvertisement aReferralAdv : this.referralAdvs) {
            e = StructuredDocumentUtils.copyElements(msg, msg, (StructuredDocument)aReferralAdv.getDocument(mediaType), REFERRAL_ADV_TAG);
            long expiration = eachReferralAdvExp.next();
            if (Long.MIN_VALUE == expiration) {
                throw new IllegalStateException("Missing Referral Advertisement Expiration.");
            }
            if (expiration <= 0L) {
                throw new IllegalStateException("Illegal Referral Advertisement Expiration.");
            }
            ((Attributable)((Object)e)).addAttribute(ADV_EXP_ATTR, Long.toString(expiration));
        }
        return msg;
    }
}

