/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.rdv.RdvPeerRdvService;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeterBuildSettings;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StdRendezVousService
extends RendezVousServiceProvider {
    private static final Logger LOG = Logger.getLogger(StdRendezVousService.class.getName());
    public static final String ConnectRequest = "Connect";
    public static final String DisconnectRequest = "Disconnect";
    public static final String ConnectedPeerReply = "ConnectedPeer";
    public static final String ConnectedLeaseReply = "ConnectedLease";
    public static final String ConnectedRdvAdvReply = "RdvAdvReply";
    protected static final int DEFAULT_MAX_TTL = 200;
    protected final String pName;
    protected final String pParam;
    private StdRdvProtocolListener handler;
    protected final Timer timer;

    protected StdRendezVousService(PeerGroup group, RendezVousServiceImpl rdvService) {
        super(group, rdvService);
        this.MAX_TTL = 200;
        this.pName = rdvService.getAssignedID().toString();
        this.pParam = group.getPeerGroupID().getUniqueValue().toString();
        this.timer = new Timer("StdRendezVousService Timer for " + group.getPeerGroupID(), true);
    }

    protected int startApp(String[] argv, StdRdvProtocolListener handler) {
        this.handler = handler;
        this.rdvService.endpoint.addIncomingMessageListener(handler, this.pName, null);
        return super.startApp(argv);
    }

    @Override
    public void stopApp() {
        EndpointListener shouldbehandler = this.rdvService.endpoint.removeIncomingMessageListener(this.pName, null);
        if (this.handler != shouldbehandler && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unregistered listener was not as expected." + this.handler + " != " + shouldbehandler);
        }
        this.timer.cancel();
        super.stopApp();
    }

    @Override
    public void processReceivedMessage(Message message, RendezVousPropagateMessage propHdr, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (srcAddr.getProtocolName().equalsIgnoreCase("jxta")) {
            ID peerid;
            String idstr = "urn:jxta:" + srcAddr.getProtocolAddress();
            try {
                peerid = IDFactory.fromURI(new URI(idstr));
            }
            catch (URISyntaxException badID) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Bad ID in message", badID);
                }
                return;
            }
            if (!this.group.getPeerID().equals(peerid)) {
                PeerConnection pConn = this.getPeerConnection(peerid);
                if (null == pConn) {
                    PeerViewElement pve = this instanceof RdvPeerRdvService ? ((RdvPeerRdvService)this).rpv.getPeerViewElement(peerid) : null;
                    if (null == pve) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Received " + message + " (" + propHdr.getMsgId() + ") from unrecognized peer : " + peerid);
                        }
                        propHdr.setTTL(Math.min(propHdr.getTTL(), 3));
                        if (this.rdvService.isRendezVous() || this.getPeerConnections().length > 0) {
                            this.sendDisconnect(peerid, null);
                        }
                    } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Received " + message + " (" + propHdr.getMsgId() + ") from " + pve);
                    }
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Received " + message + " (" + propHdr.getMsgId() + ") from " + pConn);
                }
            } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received " + message + " (" + propHdr.getMsgId() + ") from loopback.");
            }
        } else {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received " + message + " (" + propHdr.getMsgId() + ") from network -- repropagating with TTL 2");
            }
            propHdr.setTTL(Math.min(propHdr.getTTL(), 3));
        }
        super.processReceivedMessage(message, propHdr, srcAddr, dstAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(Enumeration<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int initialTTL) {
        block18: {
            RendezVousPropagateMessage propHdr;
            msg = msg.clone();
            int useTTL = Math.min(initialTTL, this.MAX_TTL);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Propagating " + msg + "(TTL=" + useTTL + ") to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
            }
            if (null != (propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, useTTL))) {
                int numPeers = 0;
                block7: while (true) {
                    while (destPeerIDs.hasMoreElements()) {
                        ID dest = destPeerIDs.nextElement();
                        try {
                            block17: {
                                PeerConnection pConn = this.getPeerConnection(dest);
                                if (null == pConn) {
                                    EndpointAddress addr;
                                    Messenger messenger;
                                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                        LOG.fine("Sending " + msg + " (" + propHdr.getMsgId() + ") to " + dest);
                                    }
                                    if (null == (messenger = this.rdvService.endpoint.getMessengerImmediate(addr = StdRendezVousService.mkAddress(dest, "JxtaPropagate", this.PropPName), null))) continue block7;
                                    try {
                                        messenger.sendMessage(msg);
                                        break block17;
                                    }
                                    catch (IOException ignored) {
                                        continue;
                                    }
                                }
                                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("Sending " + msg + " (" + propHdr.getMsgId() + ") to " + pConn);
                                }
                                if (!pConn.isConnected()) continue;
                                pConn.sendMessage(msg.clone(), "JxtaPropagate", this.PropPName);
                            }
                            ++numPeers;
                            continue block7;
                        }
                        catch (Exception failed) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                            LOG.warning("Failed to send " + msg + " (" + propHdr.getMsgId() + ") to " + dest);
                        }
                    }
                    break block18;
                    {
                        continue block7;
                        break;
                    }
                    break;
                }
                finally {
                    if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                        this.rendezvousMeter.propagateToPeers(numPeers);
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Propagated " + msg + " (" + propHdr.getMsgId() + ") to " + numPeers + " peers.");
                    }
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Declined to send " + msg + " ( no propHdr )");
            }
        }
    }

    @Override
    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        RendezVousPropagateMessage propHdr;
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Propagating " + msg + "(TTL=" + useTTL + ") to neighbors to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        if (null != (propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, useTTL))) {
            try {
                this.sendToNetwork(msg, propHdr);
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                    this.rendezvousMeter.propagateToNeighbors();
                }
            }
            catch (IOException failed) {
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                    this.rendezvousMeter.propagateToNeighborsFailed();
                }
                throw failed;
            }
        }
    }

    @Override
    protected void repropagate(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam) {
        block8: {
            msg = msg.clone();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Repropagating " + msg + " (" + propHdr.getMsgId() + ")");
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.receivedMessageRepropagatedInGroup();
            }
            try {
                propHdr = this.updatePropHeader(msg, propHdr, serviceName, serviceParam, this.MAX_TTL);
                if (null != propHdr) {
                    this.sendToNetwork(msg, propHdr);
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No propagate header, declining to repropagate " + msg + ")");
                }
            }
            catch (Exception ez1) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block8;
                if (propHdr != null) {
                    LOG.log(Level.WARNING, "Failed to repropagate " + msg + " (" + propHdr.getMsgId() + ")", ez1);
                }
                LOG.log(Level.WARNING, "Could to repropagate " + msg, ez1);
            }
        }
    }

    public abstract PeerConnection getPeerConnection(ID var1);

    protected abstract PeerConnection[] getPeerConnections();

    protected int sendToEachConnection(Message msg, RendezVousPropagateMessage propHdr) {
        List<PeerConnection> peers = Arrays.asList(this.getPeerConnections());
        int sentToPeers = 0;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + msg + "(" + propHdr.getMsgId() + ") to " + peers.size() + " peers.");
        }
        for (PeerConnection pConn : peers) {
            if (!pConn.isConnected()) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Skipping " + pConn + " for " + msg + "(" + propHdr.getMsgId() + ") -- disconnected.");
                continue;
            }
            if (propHdr.isVisited(pConn.getPeerID().toURI())) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Skipping " + pConn + " for " + msg + "(" + propHdr.getMsgId() + ") -- already visited.");
                continue;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending " + msg + "(" + propHdr.getMsgId() + ") to " + pConn);
            }
            if (!pConn.sendMessage(msg.clone(), "JxtaPropagate", this.PropPName)) continue;
            ++sentToPeers;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sent " + msg + "(" + propHdr.getMsgId() + ") to " + sentToPeers + " of " + peers.size() + " peers.");
        }
        return sentToPeers;
    }

    protected void sendDisconnect(ID peerid, PeerAdvertisement padv) {
        block5: {
            Message msg = new Message();
            try {
                Messenger messenger;
                msg.replaceMessageElement("jxta", new TextDocumentMessageElement(DisconnectRequest, this.getPeerAdvertisementDoc(), null));
                EndpointAddress addr = StdRendezVousService.mkAddress(peerid, null, null);
                RouteAdvertisement hint = null;
                if (null != padv) {
                    hint = EndpointUtils.extractRouteAdv(padv);
                }
                if (null == (messenger = this.rdvService.endpoint.getMessengerImmediate(addr, hint))) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Could not get messenger for " + peerid);
                    }
                    return;
                }
                messenger.sendMessage(msg, this.pName, this.pParam);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "sendDisconnect failed", e);
            }
        }
    }

    protected void sendDisconnect(PeerConnection pConn) {
        block2: {
            Message msg = new Message();
            try {
                msg.replaceMessageElement("jxta", new TextDocumentMessageElement(DisconnectRequest, this.getPeerAdvertisementDoc(), null));
                pConn.sendMessage(msg, this.pName, this.pParam);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "sendDisconnect failed", e);
            }
        }
    }

    protected static interface StdRdvProtocolListener
    extends EndpointListener {
    }
}

