/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvWalker;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;

public class LimitedRangeWalker
implements RdvWalker {
    private static final transient Logger LOG = Logger.getLogger(LimitedRangeWalker.class.getName());
    private final LimitedRangeWalk walk;

    public LimitedRangeWalker(LimitedRangeWalk walk) {
        this.walk = walk;
    }

    public void stop() {
    }

    private void walkMessage(Message msg, LimitedRangeRdvMsg rdvMsg) throws IOException {
        PeerViewElement downPeer;
        Message newMsg;
        PeerViewElement upPeer;
        LimitedRangeRdvMsg.WalkDirection dir = rdvMsg.getDirection();
        if ((dir == LimitedRangeRdvMsg.WalkDirection.BOTH || dir == LimitedRangeRdvMsg.WalkDirection.UP) && (upPeer = this.walk.getPeerView().getUpPeer()) != null && upPeer.isAlive()) {
            newMsg = msg.clone();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Walking " + newMsg + " [UP] to " + upPeer);
            }
            rdvMsg.setDirection(LimitedRangeRdvMsg.WalkDirection.UP);
            this.updateRdvMessage(newMsg, rdvMsg);
            upPeer.sendMessage(newMsg, this.walk.getWalkServiceName(), this.walk.getWalkServiceParam());
        }
        if ((dir == LimitedRangeRdvMsg.WalkDirection.BOTH || dir == LimitedRangeRdvMsg.WalkDirection.DOWN) && (downPeer = this.walk.getPeerView().getDownPeer()) != null && downPeer.isAlive()) {
            newMsg = msg.clone();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Walking " + newMsg + " [DOWN] to " + downPeer);
            }
            rdvMsg.setDirection(LimitedRangeRdvMsg.WalkDirection.DOWN);
            this.updateRdvMessage(newMsg, rdvMsg);
            downPeer.sendMessage(newMsg, this.walk.getWalkServiceName(), this.walk.getWalkServiceParam());
        }
    }

    public void walkMessage(PeerID destination, Message msg, String srcSvcName, String srcSvcParam, int ttl) throws IOException {
        LimitedRangeRdvMsg rdvMsg;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Walking " + msg + " to " + srcSvcName + "/" + srcSvcParam);
        }
        if ((rdvMsg = LimitedRangeWalk.getRdvMessage(msg)) == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating new Walk Header for " + msg + " with TTL=" + ttl);
            }
            rdvMsg = new LimitedRangeRdvMsg();
            rdvMsg.setTTL(Integer.MAX_VALUE);
            rdvMsg.setDirection(LimitedRangeRdvMsg.WalkDirection.BOTH);
            rdvMsg.setSrcPeerID(this.walk.getPeerGroup().getPeerID());
            rdvMsg.setSrcSvcName(srcSvcName);
            rdvMsg.setSrcSvcParams(srcSvcParam);
        } else {
            rdvMsg.setTTL(rdvMsg.getTTL() - 1);
        }
        int useTTL = Math.min(ttl, rdvMsg.getTTL());
        useTTL = Math.min(useTTL, this.walk.getPeerView().getView().size() + 1);
        rdvMsg.setTTL(useTTL);
        if (useTTL <= 0) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("LimitedRangeWalker was not able to send " + msg + " : No TTL remaining");
            }
            return;
        }
        if (null != destination) {
            Message tmp = msg.clone();
            this.updateRdvMessage(tmp, rdvMsg);
            this.sendToPeer(destination, this.walk.getWalkServiceName(), this.walk.getWalkServiceParam(), tmp);
        } else {
            this.walkMessage(msg, rdvMsg);
        }
    }

    private Message updateRdvMessage(Message msg, LimitedRangeRdvMsg rdvMsg) {
        XMLDocument asDoc = (XMLDocument)rdvMsg.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement el = new TextDocumentMessageElement("LimitedRangeRdvMessage", asDoc, null);
        msg.replaceMessageElement("jxta", el);
        return msg;
    }

    private void sendToPeer(PeerID dest, String svcName, String svcParam, Message msg) throws IOException {
        PeerViewElement pve = this.walk.getPeerView().getPeerViewElement(dest);
        if (null == pve) {
            throw new IOException("LimitedRangeWalker was not able to send " + msg + " : no pve");
        }
        if (!pve.sendMessage(msg, svcName, svcParam)) {
            throw new IOException("LimitedRangeWalker was not able to send " + msg + " : send failed");
        }
    }
}

