/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra;

import com.sun.genericra.XAResourceType;
import javax.jms.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class AbstractXAResourceType
implements XAResourceType,
XAResource {
    private Connection con;
    private String rmPolicy;

    public abstract Object getWrappedObject();

    public abstract int prepare(Xid var1) throws XAException;

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void rollback(Xid var1) throws XAException;

    public abstract void start(Xid var1, int var2) throws XAException;

    public abstract void setToRollback(boolean var1);

    public abstract boolean endCalled();

    public abstract void startDelayedXA();

    public void setConnection(Connection con) {
        this.con = con;
    }

    public Connection getConnection() {
        return this.con;
    }

    public void setRMPolicy(String policy) {
        this.rmPolicy = policy;
    }

    public String getRMPolicy() {
        return this.rmPolicy;
    }

    public boolean compare(XAResourceType type) {
        String rmPerMc = "OnePerPhysicalConnection";
        if (rmPerMc.equalsIgnoreCase(this.rmPolicy) || rmPerMc.equalsIgnoreCase(type.getRMPolicy())) {
            return type.getConnection().equals(this.getConnection());
        }
        return true;
    }

    public String printXid(Xid xid) {
        if (xid == null) {
            return "null";
        }
        String hextab = "0123456789ABCDEF";
        StringBuffer data = new StringBuffer(256);
        try {
            int value;
            int i;
            if (xid.getFormatId() == -1) {
                return "-1";
            }
            for (i = 0; i < xid.getBranchQualifier().length; ++i) {
                value = xid.getBranchQualifier()[i] & 0xFF;
                data.append(hextab.charAt(value / 16));
                data.append(hextab.charAt(value & 0xF));
            }
            for (i = 0; i < xid.getGlobalTransactionId().length; ++i) {
                value = xid.getGlobalTransactionId()[i] & 0xFF;
                data.append(hextab.charAt(value / 16));
                data.append(hextab.charAt(value & 0xF));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new String(data);
    }
}

