/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.HashMap;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.EJBQueryImpl;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.sessions.Session;

public class EJBQLPlaceHolderQuery
extends DatabaseQuery {
    private String ejbQLString;
    private Boolean flushOnExecute;
    private HashMap hints;

    public EJBQLPlaceHolderQuery() {
    }

    public EJBQLPlaceHolderQuery(String ejbQLString) {
        this.ejbQLString = ejbQLString;
    }

    public EJBQLPlaceHolderQuery(String name, String ejbql, HashMap hints) {
        this.name = name;
        this.ejbQLString = ejbql;
        this.flushOnExecute = null;
        this.hints = hints;
    }

    public EJBQLPlaceHolderQuery(String name, String ejbql, Boolean flushOnExecute, HashMap hints) {
        this.name = name;
        this.ejbQLString = ejbql;
        this.flushOnExecute = flushOnExecute;
        this.hints = hints;
    }

    public String getEJBQLString() {
        return this.ejbQLString;
    }

    public void setEJBQLString(String ejbQLString) {
        this.ejbQLString = ejbQLString;
    }

    public HashMap getHints() {
        return this.hints;
    }

    public void setHints(HashMap hints) {
        this.hints = hints;
    }

    public DatabaseQuery processEjbQLQuery(Session session) {
        ClassLoader classloader = session.getDatasourcePlatform().getConversionManager().getLoader();
        DatabaseQuery ejbquery = EJBQueryImpl.buildEJBQLDatabaseQuery(this.getName(), this.ejbQLString, this.flushOnExecute, session, this.hints, classloader);
        ejbquery.setName(this.getName());
        return ejbquery;
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        DatabaseQuery ejbquery = this.processEjbQLQuery(this.getSession());
        return ejbquery.executeDatabaseQuery();
    }
}

