/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sequencing;

import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.queryframework.ValueReadQuery;
import oracle.toplink.essentials.sequencing.QuerySequence;

public class NativeSequence
extends QuerySequence {
    public NativeSequence() {
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name) {
        super(name);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, int size) {
        super(name, size);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, int size, int initialValue) {
        super(name, size, initialValue);
        this.setShouldSkipUpdate(true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NativeSequence) {
            return NativeSequence.equalNameAndSize(this, (NativeSequence)obj);
        }
        return false;
    }

    protected ValueReadQuery buildSelectQuery() {
        return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForNativeSequence();
    }

    protected ValueReadQuery buildSelectQuery(String seqName, Integer size) {
        return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForNativeSequence(seqName, size);
    }

    public void onConnect() {
        DatabasePlatform dbPlatform;
        block4: {
            dbPlatform = null;
            try {
                dbPlatform = (DatabasePlatform)this.getDatasourcePlatform();
            }
            catch (ClassCastException ex) {
                if (this.getSelectQuery() != null) break block4;
                throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
            }
        }
        if (!dbPlatform.supportsNativeSequenceNumbers() && this.getSelectQuery() == null) {
            throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
        }
        super.onConnect();
        if (dbPlatform != null) {
            this.setShouldAcquireValueAfterInsert(dbPlatform.shouldNativeSequenceAcquireValueAfterInsert());
            this.setShouldUseTransaction(dbPlatform.shouldNativeSequenceUseTransaction());
        }
    }

    public void onDisconnect() {
        this.setShouldAcquireValueAfterInsert(false);
        this.setShouldUseTransaction(false);
        super.onDisconnect();
    }
}

