/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr;

public class CharQueue {
    protected char[] buffer;
    private int sizeLessOne;
    private int offset;
    protected int nbrEntries;

    public CharQueue(int minSize) {
        int size;
        if (minSize < 0) {
            this.init(16);
            return;
        }
        if (minSize >= 0x3FFFFFFF) {
            this.init(Integer.MAX_VALUE);
            return;
        }
        for (size = 2; size < minSize; size *= 2) {
        }
        this.init(size);
    }

    public final void append(char tok) {
        if (this.nbrEntries == this.buffer.length) {
            this.expand();
        }
        this.buffer[this.offset + this.nbrEntries & this.sizeLessOne] = tok;
        ++this.nbrEntries;
    }

    public final char elementAt(int idx) {
        return this.buffer[this.offset + idx & this.sizeLessOne];
    }

    private final void expand() {
        char[] newBuffer = new char[this.buffer.length * 2];
        for (int i = 0; i < this.buffer.length; ++i) {
            newBuffer[i] = this.elementAt(i);
        }
        this.buffer = newBuffer;
        this.sizeLessOne = this.buffer.length - 1;
        this.offset = 0;
    }

    public void init(int size) {
        this.buffer = new char[size];
        this.sizeLessOne = size - 1;
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void reset() {
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void removeFirst() {
        this.offset = this.offset + 1 & this.sizeLessOne;
        --this.nbrEntries;
    }
}

