/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class StopInstanceCommand
extends S1ASCommand {
    public static final String KILL = "kill";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private void printDebug(MBeanServerConnection mbsc, String objectName) throws Exception {
        CLILogger.getInstance().printDebugMessage("********** queryNames **********");
        CLILogger.getInstance().printDebugMessage("LIST OF ALL REGISTERED MBEANS:");
        Set<ObjectName> allMBeans = mbsc.queryNames(null, null);
        int jj = 1;
        for (ObjectName name : allMBeans) {
            CLILogger.getInstance().printDebugMessage("(" + jj++ + ")  " + name.toString());
        }
        CLILogger.getInstance().printDebugMessage("********** getMBeanInfo **********");
        MBeanInfo mbinfo = mbsc.getMBeanInfo(new ObjectName(objectName));
        CLILogger.getInstance().printDebugMessage("Description = " + mbinfo.getDescription());
        CLILogger.getInstance().printDebugMessage("Classname = " + mbinfo.getClassName());
        MBeanOperationInfo[] mboinfo = mbinfo.getOperations();
        for (int ii = 0; ii < mboinfo.length; ++ii) {
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Description = " + mboinfo[ii].getDescription());
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Name = " + mboinfo[ii].getName());
        }
    }
}

