/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import java.util.Hashtable;
import java.util.Properties;

class ConfigAttributeManager {
    static final ConfigAttribute[] configAttributes = new ConfigAttribute[]{new ConfigAttribute("ConnectionTrace", ReadWriteEnum.READWRITE), new ConfigAttribute("CoreFile", ReadWriteEnum.READWRITE), new ConfigAttribute("DatabaseName", ReadWriteEnum.READONLY), new ConfigAttribute("DataBufferPoolSize", ReadWriteEnum.READWRITE), new ConfigAttribute("DataDeviceSize", ReadWriteEnum.READWRITE), new ConfigAttribute("DevicePath", ReadWriteEnum.READWRITE), new ConfigAttribute("EagerSessionThreshold", ReadWriteEnum.READWRITE), new ConfigAttribute("EagerSessionTimeout", ReadWriteEnum.READWRITE), new ConfigAttribute("EventBufferSize", ReadWriteEnum.READWRITE), new ConfigAttribute("HistoryPath", ReadWriteEnum.READWRITE), new ConfigAttribute("InternalLogBufferSize", ReadWriteEnum.READWRITE), new ConfigAttribute("JdbcUrl", ReadWriteEnum.READONLY), new ConfigAttribute("LogBufferSize", ReadWriteEnum.READWRITE), new ConfigAttribute("MaxTables", ReadWriteEnum.READWRITE), new ConfigAttribute("NumberOfDatadevices", ReadWriteEnum.READWRITE), new ConfigAttribute("NumberOfLocks", ReadWriteEnum.READWRITE), new ConfigAttribute("NumberOfSessions", ReadWriteEnum.READWRITE), new ConfigAttribute("PackageName", ReadWriteEnum.READWRITE), new ConfigAttribute("PortBase", ReadWriteEnum.READONLY), new ConfigAttribute("RelalgDeviceSize", ReadWriteEnum.READWRITE), new ConfigAttribute("SQLTraceMode", ReadWriteEnum.READWRITE), new ConfigAttribute("SessionTimeout", ReadWriteEnum.READWRITE), new ConfigAttribute("StartRepairDelay", ReadWriteEnum.READWRITE), new ConfigAttribute("StatInterval", ReadWriteEnum.READWRITE), new ConfigAttribute("SyslogFacility", ReadWriteEnum.READWRITE), new ConfigAttribute("SyslogLevel", ReadWriteEnum.READWRITE), new ConfigAttribute("SyslogPrefix", ReadWriteEnum.READWRITE), new ConfigAttribute("TakeoverTime", ReadWriteEnum.READWRITE)};
    private Hashtable<String, String> props;
    private Properties readonlyAttributes;
    private Properties readwriteAttributes;

    ConfigAttributeManager(Properties Props) {
        this.props = HADBUtils.props2hash(Props);
        this.readonlyAttributes = new Properties();
        this.readwriteAttributes = new Properties();
        this.makeProps();
    }

    Properties getReadOnlyAttributes() {
        return this.readonlyAttributes;
    }

    Properties getReadWriteAttributes() {
        return this.readwriteAttributes;
    }

    private void makeProps() {
        for (ConfigAttribute att : configAttributes) {
            String val = this.props.get(att.name.toLowerCase());
            if (val == null || val.length() <= 0) continue;
            if (att.rw == ReadWriteEnum.READWRITE) {
                this.readwriteAttributes.setProperty(att.name, val);
                continue;
            }
            this.readonlyAttributes.setProperty(att.name, val);
        }
    }

    public static void main(String[] notUsed) {
        Properties p = new Properties();
        p.setProperty("ConnectionTrace", "xxx");
        p.setProperty("CoreFile", "xxx");
        p.setProperty("DatabaseName", "xxx");
        p.setProperty("DataBufferPoolSize", "xxx");
        p.setProperty("DataDeviceSize", "xxx");
        p.setProperty("DevicePath", "xxx");
        p.setProperty("EagerSessionThreshold", "xxx");
        p.setProperty("EagerSessionTimeout", "xxx");
        p.setProperty("EventBufferSize", "xxx");
        p.setProperty("HistoryPath", "xxx");
        p.setProperty("InternalLogBufferSize", "xxx");
        p.setProperty("JdbcUrl", "xxx");
        p.setProperty("LogBufferSize", "xxx");
        p.setProperty("MaxTables", "xxx");
        p.setProperty("NumberOfDatadevices", "xxx");
        p.setProperty("NumberOfLocks", "xxx");
        p.setProperty("NumberOfSessions", "xxx");
        p.setProperty("PackageName", "xxx");
        p.setProperty("PortBase", "xxx");
        p.setProperty("RelalgDeviceSize", "xxx");
        p.setProperty("SQLTraceMode", "xxx");
        p.setProperty("SessionTimeout", "xxx");
        p.setProperty("StartRepairDelay", "xxx");
        p.setProperty("StatInterval", "xxx");
        p.setProperty("SyslogFacility", "xxx");
        p.setProperty("SyslogLevel", "xxx");
        p.setProperty("SyslogPrefix", "xxx");
        p.setProperty("TakeoverTime", "xxx");
        ConfigAttributeManager cam = new ConfigAttributeManager(p);
        System.out.println("Original Attributes:");
        System.out.println(p);
        System.out.println("\nREADONLY Attributes:");
        System.out.println(cam.getReadOnlyAttributes());
        System.out.println("\nREADWRITE Attributes:");
        System.out.println(cam.getReadWriteAttributes());
    }

    private static class ConfigAttribute {
        String name;
        ReadWriteEnum rw;

        ConfigAttribute(String Name2, ReadWriteEnum RW) {
            this.name = Name2;
            this.rw = RW;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadWriteEnum {
        READWRITE,
        READONLY;

    }
}

