/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBPingAgent;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBResourceManager;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;

public class HADBRemoveCluster {
    private HADBInfo info;

    public HADBRemoveCluster(HADBInfo info) {
        this.info = info;
    }

    public Object[] remove() throws HADBSetupException {
        boolean doDeleteDB = true;
        try {
            HADBPingAgent pa = new HADBPingAgent(this.info);
            Object[] result = pa.ping();
            if (result == null || result.length < 2 || result[0].equals("false")) {
                throw new HADBSetupException("hadbmgmt-res.PingBad", new Object[]{this.info.getClusterName(), result[1]});
            }
        }
        catch (HADBSetupException hse) {
            String s = hse.getMessage();
            s = s + "  ";
            String s2 = StringHelper.get("hadbmgmt-res.RemoveMAIsDead");
            this.info.addMsg(s + s2);
            LoggerHelper.warning(s2);
            doDeleteDB = false;
        }
        if (doDeleteDB) {
            this.deleteDB();
        }
        this.deleteResources();
        return this.info.prepMsgs();
    }

    private void deleteDB() throws HADBSetupException {
        HADBUtils.setPhonyReturnValue(0);
        String[] commands = this.info.getStopCommands();
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            this.info.addMsg(StringHelper.get("hadbmgmt-res.StopFailed", this.info.getClusterName()));
        } else {
            this.info.addMsg(StringHelper.get("hadbmgmt-res.StopSucceeded", this.info.getClusterName()));
        }
        commands = this.info.getDeleteCommands();
        HADBUtils.setPhonyReturnValue(0);
        exec = new HADBMExecutor(this.info.getExecutable(), commands);
        exitValue = exec.exec();
        if (exitValue != 0) {
            String s = StringHelper.get("hadbmgmt-res.DeleteFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
            LoggerHelper.warning(s);
            this.info.addMsg(s);
        } else {
            String s = StringHelper.get("hadbmgmt-res.DeleteDBOutput", exec.getStdout(), exec.getStderr());
            LoggerHelper.fine(s);
            this.info.addMsg(s);
        }
    }

    private void deleteResources() throws HADBSetupException {
        HADBResourceManager mgr = new HADBResourceManager(this.info);
        try {
            mgr.deletePool();
            this.info.addMsg(StringHelper.get("hadbmgmt-res.DeletePoolSuccess"));
        }
        catch (HADBSetupException hse) {
            String s = StringHelper.get("hadbmgmt-res.DeletePoolFailed", hse.toString());
            LoggerHelper.warning(s);
            this.info.addMsg(s);
        }
        mgr.enableAvailabilityService(false);
    }
}

