/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.lifecycle;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.ee.admin.lbadmin.lifecycle.LoadbalancerAdminEventListener;
import com.sun.enterprise.server.ServerContext;

public class LoadbalancerAdminLifeCycle
extends ServerLifecycleImpl {
    public static final byte STATUS_NOT_STARTED = 0;
    public static final byte STATUS_SHUTDOWN = 1;
    public static final byte STATUS_INITED = 2;
    public static final byte STATUS_STARTED = 4;
    public static final byte STATUS_READY = 8;
    public static final byte STATUS_TERMINATED = 0;
    private byte serverStatus = 0;

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        if ((this.serverStatus & 2) == 2) {
            throw new IllegalStateException("load balancer Admin is already initialized");
        }
        this.serverStatus = (byte)2;
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 4);
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 8);
        AdminService adminService = AdminService.getAdminService();
        if (adminService.isDas()) {
            ConfigContext ctx = adminService.getAdminContext().getAdminConfigContext();
            LoadbalancerAdminEventListener el = new LoadbalancerAdminEventListener();
            ctx.addConfigContextEventListener((ConfigContextEventListener)el);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 1);
    }

    public void onTermination() throws ServerLifecycleException {
        this.serverStatus = 0;
    }
}

