/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.config.serverbeans.LoadBalancers;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

public final class LoadBalancersAdminConfig
extends BaseConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(LoadBalancersAdminConfig.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    public String[] listLoadBalancers(String lbConfigName) throws MBeanException {
        _logger.log(Level.FINE, "[LBAdminMBean] listLBConfigs called");
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Domain domain = (Domain)ctx.getRootConfigBean();
            LoadBalancers loadbalancers = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
            if (loadbalancers == null) {
                _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.NoLbConfigs"));
                return null;
            }
            String[] names = null;
            ArrayList<String> namesList = new ArrayList<String>();
            LoadBalancer[] lbArray = loadbalancers.getLoadBalancer();
            if (lbArray.length == 0) {
                _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.NoLbConfigs"));
                return null;
            }
            for (LoadBalancer lb : lbArray) {
                String configName = lb.getLbConfigName();
                if (lbConfigName != null && !lbConfigName.equals("") && !lbConfigName.equals(configName)) continue;
                namesList.add(lb.getName());
            }
            names = new String[namesList.size()];
            names = namesList.toArray(names);
            return names;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }
}

