/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.InstanceReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.transform.InstanceVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.util.i18n.StringManager;

public class InstanceReaderImpl
implements InstanceReader {
    ConfigContext _ctx = null;
    ServerRef _sRef = null;
    Server _s = null;
    private static final StringManager _localStrMgr = StringManager.getManager(InstanceReaderImpl.class);
    private final String HTTP_PROTO = "http://";
    private final String HTTPS_PROTO = "https://";

    public InstanceReaderImpl(ConfigContext ctx, ClusterRef cRef, Server s) {
        if (ctx == null || cRef == null || s == null) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }
        this._ctx = ctx;
        this._s = s;
        Cluster c = null;
        try {
            c = ClusterHelper.getClusterByName((ConfigContext)this._ctx, (String)cRef.getRef());
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("InstanceNotFound", (Object)s.getName(), (Object)cRef.getRef());
            throw new IllegalArgumentException(msg);
        }
        this._sRef = c.getServerRefByRef(s.getName());
        if (this._sRef == null) {
            String msg = _localStrMgr.getString("ServerRefNotFound", (Object)s.getName(), (Object)cRef.getRef());
            throw new IllegalArgumentException(msg);
        }
    }

    public InstanceReaderImpl(ConfigContext ctx, ServerRef sRef) {
        if (ctx == null || sRef == null) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }
        this._ctx = ctx;
        this._sRef = sRef;
        try {
            this._s = ServerHelper.getServerByName((ConfigContext)this._ctx, (String)sRef.getRef());
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("InstanceNotFound", (Object)sRef.getRef(), (Object)"");
            throw new IllegalArgumentException(msg);
        }
        if (this._s == null) {
            String msg = _localStrMgr.getString("ServerRefNotFound", (Object)sRef.getRef(), (Object)"");
            throw new IllegalArgumentException(msg);
        }
    }

    public String getName() throws LbReaderException {
        return this._sRef.getRef();
    }

    public boolean getLbEnabled() throws LbReaderException {
        return this._sRef.isLbEnabled();
    }

    public String getDisableTimeoutInMinutes() throws LbReaderException {
        return this._sRef.getDisableTimeoutInMinutes();
    }

    public String getWeight() throws LbReaderException {
        return this._s.getLbWeight();
    }

    public String getListeners() throws LbReaderException {
        String listenerStr = "";
        String sName = this._sRef.getRef();
        Config c = null;
        try {
            c = ServerHelper.getConfigForServer((ConfigContext)this._ctx, (String)sName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("ConfigNotFound", (Object)sName);
            throw new LbReaderException(msg, ce);
        }
        HttpService httpSvc = c.getHttpService();
        HttpListener[] lstnrs = httpSvc.getHttpListener();
        for (int i = 0; i < lstnrs.length; ++i) {
            if (i != 0) {
                listenerStr = listenerStr + " ";
            }
            listenerStr = lstnrs[i].isSecurityEnabled() ? listenerStr + "https://" : listenerStr + "http://";
            String hostName = this.getHostNameForServerInstance(this._ctx, sName);
            listenerStr = listenerStr + hostName + ":";
            String port = lstnrs[i].getPort();
            if (port != null && port.length() > 1 && port.charAt(0) == '$' && port.charAt(1) == '{' && port.charAt(port.length() - 1) == '}') {
                String portVar = port.substring(2, port.length() - 1);
                String sVar = null;
                PropertyResolver propResolver = null;
                try {
                    propResolver = new PropertyResolver(this._ctx, sName);
                }
                catch (ConfigException ce) {
                    // empty catch block
                }
                if (propResolver != null) {
                    sVar = propResolver.getPropertyValue(portVar);
                }
                if (sVar != null) {
                    listenerStr = listenerStr + sVar;
                    continue;
                }
                listenerStr = listenerStr + port;
                continue;
            }
            listenerStr = listenerStr + port;
        }
        return listenerStr;
    }

    public void accept(Visitor v) {
        InstanceVisitor pv = (InstanceVisitor)v;
        pv.visit(this);
    }

    private String getHostNameForServerInstance(ConfigContext ctx, String serverName) throws LbReaderException {
        try {
            JMXConnectorConfig info = ServerHelper.getJMXConnectorInfo((ConfigContext)ctx, (String)serverName);
            String host = info.getHost();
            return host;
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("GetHostNameFailed");
            throw new LbReaderException(msg, e);
        }
    }
}

