/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.writer;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.ee.admin.lbadmin.beans.Loadbalancer;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LoadbalancerReader;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigExporter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class LbConfigWriter {
    Loadbalancer _lb = null;
    String _path = null;
    String _name = null;
    ConfigContext _ctx = null;
    String _f = "loadbalancer.xml";
    private static final StringManager _strMgr = StringManager.getManager(LbConfigWriter.class);

    public LbConfigWriter(ConfigContext ctx, String lbConfigName, String path) {
        if (path == null || "".equals(path) || "null".equals(path)) {
            String iRoot = System.getProperty("com.sun.aas.instanceRoot");
            this._path = iRoot + File.separator + "generated" + File.separator + this._f + "." + lbConfigName;
        } else {
            File f = new File(path);
            this._path = f.isDirectory() ? path + File.separator + this._f + "." + lbConfigName : path;
        }
        this._name = lbConfigName;
        this._ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write() throws IOException, ConfigException, Schema2BeansException {
        LoadbalancerReader lbr = LbConfigExporter.getLbReader(this._ctx, this._name);
        File f = new File(this._path);
        if (f.isDirectory()) {
            f = new File(f, this._f);
        }
        if (f.exists()) {
            String msg = _strMgr.getString("FileExists", (Object)f.getPath());
            throw new IOException(msg);
        }
        if (!f.getParentFile().exists()) {
            String msg = _strMgr.getString("ParentFileMissing", (Object)f.getParent());
            throw new IOException(msg);
        }
        FileOutputStream fo = null;
        try {
            String fAbsPath;
            fo = new FileOutputStream(f);
            String footer = _strMgr.getString("GeneratedFileFooter", (Object)new Date().toString());
            LbConfigExporter.exportXml(lbr, fo);
            String string = fAbsPath = f.getAbsolutePath();
            return string;
        }
        finally {
            if (fo != null) {
                fo.close();
                fo = null;
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            return;
        }
        try {
            String cPath = "domain.xml";
            ConfigContext ctx = null;
            try {
                ctx = ConfigFactory.createConfigContext((String)cPath);
            }
            catch (ConfigException ce) {
                ce.printStackTrace();
            }
            LbConfigWriter lbw = new LbConfigWriter(ctx, args[0], args[1]);
            lbw.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

