/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.ee.admin.mbeans.EJBTimerManagementMBean;
import com.sun.enterprise.ee.admin.proxy.InstanceProxy;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;

public class EETransactionsRecoveryMBean
extends EEBaseConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(EJBTimerManagementMBean.class);

    public void recoverTransactions(String serverToRecover, String destinationServer, String transactionLogDir) throws MBeanConfigException {
        this.fine("TrasactionsRecoverytMBean.recoveryTransactions for server: " + serverToRecover + " destinationServer" + destinationServer + " transactionLogDir" + transactionLogDir);
        if (serverToRecover == null) {
            throw new MBeanConfigException(_strMgr.getString("tx.noServerToRecover"));
        }
        if (!this.isServer(serverToRecover)) {
            throw new MBeanConfigException(_strMgr.getString("tx.ServerBeRecoveredIsNotKnown", (Object)serverToRecover));
        }
        if (this.isServerRunning(serverToRecover)) {
            if (destinationServer != null && !serverToRecover.equals(destinationServer)) {
                throw new MBeanConfigException(_strMgr.getString("tx.runningServerBeRecoveredFromAnotherServer", (Object)serverToRecover, (Object)destinationServer));
            }
            if (transactionLogDir != null) {
                throw new MBeanConfigException(_strMgr.getString("tx.logDirShouldNotBeSpecifiedForSelfRecovering", (Object)serverToRecover));
            }
        } else {
            if (destinationServer == null) {
                throw new MBeanConfigException(_strMgr.getString("tx.noDestinationServer", (Object)serverToRecover));
            }
            if (!this.isServerRunning(destinationServer)) {
                throw new MBeanConfigException(_strMgr.getString("tx.destinationServerIsNotAlive", (Object)serverToRecover));
            }
            if (transactionLogDir == null) {
                throw new MBeanConfigException(_strMgr.getString("tx.logDirNotSpecified", (Object)serverToRecover));
            }
        }
        if (destinationServer != null && !this.isServer(destinationServer)) {
            throw new MBeanConfigException(_strMgr.getString("tx.DestinationServerIsNotKnown", (Object)destinationServer));
        }
        if (destinationServer == null) {
            destinationServer = serverToRecover;
        }
        this.fine("TrasactionsRecoverytMBean.recoveryTransactions: Sending Notification to server" + destinationServer);
        this.sendTransactionsRecoveryEvent(destinationServer, serverToRecover, transactionLogDir);
    }

    private boolean isServer(String target) {
        try {
            return ServerHelper.isAServer((ConfigContext)this.getConfigContext(), (String)target);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isServerRunning(String server) {
        try {
            ServerRuntimeMBean serverMBean = InstanceProxy.getInstanceProxy(server);
            Status status = serverMBean.getRuntimeStatus().getStatus();
            if (status.getStatusCode() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void sendTransactionsRecoveryEvent(String destinationServer, String serverToRecover, String transactionLogDir) throws MBeanConfigException {
        TransactionsRecoveryEvent event = new TransactionsRecoveryEvent(this.getServerName(), serverToRecover, transactionLogDir);
        event.setTargetDestination(destinationServer);
        AdminEventResult res = this.forwardEvent((AdminEvent)event);
        if (!"success".equals(res.getResultCode())) {
            Throwable exc = res.getFirstThrowable();
            if (exc != null) {
                throw new MBeanConfigException(_strMgr.getString("tx.exceptionInTargetServer", (Object)exc.getMessage()));
            }
            throw new MBeanConfigException(_strMgr.getString("tx.notSuccessInSendReturn", (Object)res.getResultCode()));
        }
    }

    private AdminEventResult forwardEvent(AdminEvent e) {
        AdminEventResult result = null;
        result = AdminEventMulticaster.multicastEvent((AdminEvent)e);
        return result;
    }

    private void fine(String s) {
        _sLogger.log(Level.FINE, s);
    }

    private String getServerName() {
        return ApplicationServer.getServerContext().getInstanceName();
    }
}

