/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.mbeans.custom.BasicCustomMBeanOperations;
import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanOperationsMBean;
import com.sun.enterprise.admin.mbeans.custom.MBeanValidator;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseCustomMBeanOperations
extends BasicCustomMBeanOperations
implements CustomMBeanOperationsMBean {
    private final TargetType[] vTargets = new TargetType[4];
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public EnterpriseCustomMBeanOperations() {
        this.vTargets[0] = TargetType.DOMAIN;
        this.vTargets[1] = TargetType.DAS;
        this.vTargets[2] = TargetType.SERVER;
        this.vTargets[3] = TargetType.CLUSTER;
    }

    public String createMBean(String target, Map<String, String> params, Map<String, String> attributes) throws CustomMBeanException {
        boolean mbeanDefinitionCreated = false;
        try {
            Target t = TargetBuilder.INSTANCE.createTarget(target, this.vTargets, target, this.acc);
            TargetType pType = t.getType();
            String newTarget = t.getName();
            mbeanDefinitionCreated = this.createMBeanDefinitionIfAbsent(newTarget, params, attributes);
            String name = params.get("name");
            if (!TargetType.DOMAIN.equals((Object)pType)) {
                if (TargetType.DAS.equals((Object)pType) || TargetType.SERVER.equals((Object)pType)) {
                    if (TargetType.SERVER.equals((Object)pType)) {
                        EnterpriseCustomMBeanOperations.checkClusteredInstance(this.acc, newTarget);
                    }
                    this.createMBeanReferenceForServer(newTarget, name);
                } else if (TargetType.CLUSTER.equals((Object)pType)) {
                    if (ServerBeansFactory.isReferencedMBeanInCluster((ConfigContext)this.acc, (String)newTarget, (String)name)) {
                        throw new CustomMBeanException(CMBStrings.get((String)"cmb.ee.local.MbeanAlreadyExistsInCluster", (Object[])new Object[]{name, newTarget}));
                    }
                    this.createMBeanReferencesInCluster(newTarget, name);
                } else {
                    throw new RuntimeException(CMBStrings.get((String)"cmb.ee.local.targetProcessBad", (Object[])new Object[]{target}));
                }
            }
            return name;
        }
        catch (CustomMBeanException cmbe) {
            throw cmbe;
        }
        catch (Exception e) {
            if (mbeanDefinitionCreated) {
                try {
                    ServerBeansFactory.removeMbeanDefinition((ConfigContext)this.acc, (String)params.get("name"));
                }
                catch (Exception ee) {
                    throw new RuntimeException(ee);
                }
            }
            throw new CustomMBeanException((Throwable)e);
        }
    }

    public String createMBean(String target, Map<String, String> params) throws CustomMBeanException {
        Map<String, String> ea = Collections.emptyMap();
        return this.createMBean(target, params, ea);
    }

    public void deleteMBeanRef(String target, String ref) throws CustomMBeanException {
        throw new UnsupportedOperationException(CMBStrings.get((String)"InternalError", (Object[])new Object[]{"Not implemented yet."}));
    }

    public String deleteMBean(String target, String name) throws CustomMBeanException {
        if (name == null) {
            throw new IllegalArgumentException(CMBStrings.get((String)"InternalError", (Object[])new Object[]{"null argument"}));
        }
        try {
            Target t = TargetBuilder.INSTANCE.createTarget(target, this.vTargets, target, this.acc);
            TargetType pType = t.getType();
            if (TargetType.DAS.equals((Object)pType) || TargetType.SERVER.equals((Object)pType)) {
                if (TargetType.SERVER.equals((Object)pType)) {
                    EnterpriseCustomMBeanOperations.checkClusteredInstance(this.acc, t.getName());
                }
                this.deleteMBeanFromServer(t.getName(), name);
            } else if (TargetType.DOMAIN.equals((Object)t.getType())) {
                this.checkReferencingServers(name);
                ServerBeansFactory.removeMbeanDefinition((ConfigContext)this.acc, (String)name);
            } else if (TargetType.CLUSTER.equals((Object)t.getType())) {
                this.deleteMBeanFromCluster(target, name);
            } else {
                throw new RuntimeException(CMBStrings.get((String)"cmb.ee.local.targetProcessBad", (Object[])new Object[]{target}));
            }
            return name;
        }
        catch (Exception e) {
            throw new CustomMBeanException((Throwable)e);
        }
    }

    public void createMBeanRef(String target, String ref) throws CustomMBeanException {
        throw new UnsupportedOperationException(CMBStrings.get((String)"InternalError", (Object[])new Object[]{"Not implemented yet."}));
    }

    public String createMBean(String target, String className) throws CustomMBeanException {
        String cnk = "impl-class-name";
        String nk = "name";
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("name", className);
        tmp.put("impl-class-name", className);
        Map<String, String> attributes = Collections.emptyMap();
        return this.createMBean(target, tmp, attributes);
    }

    static void checkClusteredInstance(ConfigContext cc, String server) throws RuntimeException {
        try {
            if (ServerHelper.isServerClustered((ConfigContext)cc, (String)server)) {
                String cluster = ClusterHelper.getClusterForInstance((ConfigContext)cc, (String)server).getName();
                String msg = CMBStrings.get((String)"cmb.ee.local.badTarget.ClusteredServer", (Object[])new Object[]{server, cluster});
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean createMBeanDefinitionIfAbsent(String target, Map<String, String> params, Map<String, String> attributes) throws Exception {
        boolean definitionCreated = false;
        Map mm = super.checkAndModifyParamsForName(params);
        ObjectName onPostReg = super.selectObjectName(mm, attributes);
        String name = (String)mm.get("name");
        params.put("name", name);
        params.put("object-name", onPostReg.toString());
        if (ServerBeansFactory.getMBeanDefinition((ConfigContext)this.acc, (String)name) == null) {
            this.checkObjectNameUniquenessForSameTarget(target, onPostReg);
            Mbean md = MBeanValidator.toMbean(params, attributes, (boolean)true);
            ServerBeansFactory.addMbeanDefinition((ConfigContext)this.acc, (Mbean)md);
            definitionCreated = true;
        } else {
            String msg = CMBStrings.get((String)"cmb.ee.defExists", (Object[])new Object[]{name});
            logger.info(msg);
        }
        return definitionCreated;
    }

    private void checkObjectNameUniquenessForSameTarget(String target, ObjectName on) throws Exception {
        Target t = TargetBuilder.INSTANCE.createTarget(target, this.vTargets, target, this.acc);
        TargetType pType = t.getType();
        String msg = CMBStrings.get((String)"cmb.ee.objNameExists", (Object[])new Object[]{on.toString(), target});
        logger.info(msg);
        if (TargetType.DOMAIN.equals((Object)pType)) {
            List mds = ServerBeansFactory.getAllMBeanDefinitions((ConfigContext)this.acc);
            for (Mbean md : mds) {
                String ons = md.getObjectName();
                ObjectName ton = new ObjectName(ons);
                if (!ton.equals(on)) continue;
                throw new RuntimeException(msg);
            }
        } else if (TargetType.DAS.equals((Object)pType) || TargetType.STANDALONE_SERVER.equals((Object)pType) || TargetType.SERVER.equals((Object)pType)) {
            if (super.onExists(t.getName(), on)) {
                throw new RuntimeException(msg);
            }
        } else if (TargetType.CLUSTER.equals((Object)pType)) {
            Server[] ss = ServerHelper.getServersInCluster((ConfigContext)this.acc, (String)target);
            if (ss.length < 1) {
                throw new RuntimeException(CMBStrings.get((String)"cmb.ee.local.emptyCluster", (Object[])new Object[]{target}));
            }
            String s = ss[0].getName();
            if (super.onExists(s, on)) {
                throw new RuntimeException(msg);
            }
        }
    }

    private void deleteMBeanFromServer(String sName, String name) throws Exception {
        if (!ServerBeansFactory.isReferencedMBean((ConfigContext)this.acc, (String)sName, (String)name)) {
            String msg = CMBStrings.get((String)"cmb.ee.local.notReferenced", (Object[])new Object[]{name, sName});
            throw new CustomMBeanException(msg);
        }
        ServerBeansFactory.removeMbeanReference((ConfigContext)this.acc, (String)name, (String)sName);
        this.deleteMBeanDefinitionIfNoMoreReferences(name);
    }

    private void deleteMBeanDefinitionIfNoMoreReferences(String name) throws Exception {
        Server[] ss = ServerBeansFactory.getServersReferencingMBeanDefinition((ConfigContext)this.acc, (String)name);
        if (ss.length == 0) {
            ServerBeansFactory.removeMbeanDefinition((ConfigContext)this.acc, (String)name);
        }
    }

    private void checkReferencingServers(String mbeanName) throws Exception {
        Server[] ss = ServerBeansFactory.getServersReferencingMBeanDefinition((ConfigContext)this.acc, (String)mbeanName);
        if (ss.length != 0) {
            StringBuilder sb = new StringBuilder();
            for (Server s : ss) {
                sb.append(s.getName()).append("  ");
            }
            String msg = CMBStrings.get((String)"cmb.ee.local.referencedByServers", (Object[])new Object[]{mbeanName, sb.toString()});
            throw new RuntimeException(msg);
        }
    }

    private void createMBeanReferencesInCluster(String cluster, String name) throws RuntimeException {
        Server[] ss = null;
        try {
            for (Server s : ss = ServerHelper.getServersInCluster((ConfigContext)this.acc, (String)cluster)) {
                this.createMBeanReferenceForServer(s.getName(), name);
            }
            ServerBeansFactory.addClusterMbeanReference((ConfigContext)this.acc, (String)name, (String)cluster);
        }
        catch (Exception e) {
            for (Server s : ss) {
                try {
                    this.deleteMBeanReferenceFromServer(s.getName(), name);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            try {
                ServerBeansFactory.removeClusterMbeanReference((ConfigContext)this.acc, (String)name, (String)cluster);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    private void createMBeanReferenceForServer(String target, String ref) throws Exception {
        Mbean m = null;
        m = ServerBeansFactory.getMBeanDefinition((ConfigContext)this.acc, (String)ref);
        if (m == null) {
            String msg = CMBStrings.get((String)"cmb.ee.local.mustCreateDefinition", (Object[])new Object[]{ref});
            throw new CustomMBeanException(msg);
        }
        if (ServerBeansFactory.isReferencedMBean((ConfigContext)this.acc, (String)target, (String)ref)) {
            String msg = CMBStrings.get((String)"cmb.ee.local.refExists", (Object[])new Object[]{target, ref});
            throw new CustomMBeanException(msg);
        }
        ServerBeansFactory.addMbeanReference((ConfigContext)this.acc, (String)ref, (String)target);
    }

    private void deleteMBeanFromCluster(String cluster, String name) throws Exception {
        ServerBeansFactory.removeClusterMbeanReference((ConfigContext)this.acc, (String)name, (String)cluster);
        Server[] ss = null;
        for (Server s : ss = ServerHelper.getServersInCluster((ConfigContext)this.acc, (String)cluster)) {
            this.deleteMBeanFromServer(s.getName(), name);
        }
    }

    private void deleteMBeanReferenceFromServer(String server, String name) throws RuntimeException {
        try {
            if (ServerBeansFactory.isReferencedMBean((ConfigContext)this.acc, (String)server, (String)name)) {
                ServerBeansFactory.removeMbeanReference((ConfigContext)this.acc, (String)name, (String)server);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

