/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfigValidator;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.EEDomainsManager;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.ee.admin.servermgmt.EEScriptsTokens;
import com.sun.enterprise.ee.admin.servermgmt.NodeAgentPropertyReader;
import com.sun.enterprise.ee.security.NssStore;
import com.sun.enterprise.util.JvmInfoUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManager
extends EEInstancesManager {
    private static final StringManager _strMgr = StringManager.getManager(AgentManager.class);

    public AgentManager(AgentConfig config) {
        super(config);
        this.setMessages(new RepositoryManager.RepositoryManagerMessages((RepositoryManager)this, _strMgr, "illegalAgentName", "agentName", "agentRoot", "agentExists", "agentDoesntExist", "agentDirNotValid", "cannotDeleteAgentDir", "invalidAgentDir", "listAgentElement", "cannotDeleteAgent_invalidState", "agentStartupException", "cannotStartAgent_invalidState", "startAgentTimeOut", "portConflict", "agentStartupFailed", "cannotStopAgent_invalidState", "cannotStopAgent", "agentTimeoutStarting"));
    }

    public void validateNodeAgent(AgentConfig config, boolean agentExists) throws AgentException {
        try {
            this.checkRepository(config, agentExists, agentExists);
        }
        catch (RepositoryException ex) {
            throw new AgentException(ex);
        }
    }

    public void validateAdminUserAndPassword(AgentConfig config) throws AgentException {
        block2: {
            try {
                this.validateAdminUserAndPassword(config, (String)config.get("agent.das.user"), (String)config.get("agent.das.password"));
            }
            catch (RepositoryException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof ConfigException) break block2;
                throw new AgentException(ex);
            }
        }
    }

    public void validateMasterPassword(AgentConfig config, boolean mustValidate) throws AgentException {
        if (mustValidate || this.getFileLayout().getPasswordAliasKeystore().exists()) {
            try {
                this.validateMasterPassword(config, this.getMasterPasswordClear(config));
            }
            catch (RepositoryException ex) {
                throw new AgentException(ex);
            }
        }
    }

    @Override
    public String getNativeName() {
        return "appservAgent";
    }

    public void createNodeAgent() throws AgentException {
        try {
            this.getFileLayout().createRepositoryRoot();
            new AgentConfigValidator().validate((Object)this.getAgentConfig());
            this.checkRepository(this.getAgentConfig(), false);
        }
        catch (Exception ex) {
            throw new AgentException(ex);
        }
        try {
            AgentConfig config = this.getAgentConfig();
            this.getEEFileLayout().createNodeAgentDirectories();
            this.createDASConfiguration();
            this.createNodeAgentConfiguration();
            this.createStartAgent();
            this.createStopAgent();
            this.createServerPolicyFile(config);
            if (this.saveMasterPassword(config)) {
                this.createMasterPasswordFile(config, this.getMasterPasswordClear(config));
            }
            this.setPermissions(config);
        }
        catch (AgentException ex) {
            FileUtils.liquidate((File)this.getAgentDir());
            throw ex;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)this.getAgentDir());
            throw new AgentException(ex);
        }
    }

    public void deleteNodeAgent() throws AgentException {
        try {
            this.deleteRepository(this.getAgentConfig(), false);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public String[] listNodeAgents() throws AgentException {
        try {
            return this.listRepository(this.getAgentConfig());
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    @Override
    protected RepositoryConfig getConfigForRepositoryStatus(RepositoryConfig config, String repository) {
        return new RepositoryConfig(repository, config.getRepositoryRoot(), config.getInstanceName());
    }

    public String[] listNodeAgentsAndStatusAsString() throws AgentException {
        try {
            return this.listDomainsAndStatusAsString(this.getAgentConfig());
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public void startNodeAgent() throws AgentException {
        this.startNodeAgent(null, null);
    }

    public void startNodeAgent(String startInstancesOverride, String syncInstancesOverride) throws AgentException {
        try {
            ArrayList<String> commandLineArgs = new ArrayList<String>();
            if (startInstancesOverride != null) {
                commandLineArgs.add(" startInstancesOverride=" + startInstancesOverride);
            }
            if (syncInstancesOverride != null) {
                commandLineArgs.add("syncInstances=" + syncInstancesOverride);
            }
            RepositoryConfig config = this.getConfig();
            String[] options = this.getInteractiveOptions((String)config.get((Object)"agent.das.user"), (String)config.get((Object)"agent.das.password"), (String)config.get((Object)"agent.masterpassword"), (HashMap)config.get((Object)"agent.extraPasswords"));
            String[] commLineArgs = new String[commandLineArgs.size()];
            for (int i = 0; i < commandLineArgs.size(); ++i) {
                commLineArgs[i] = (String)commandLineArgs.get(i);
            }
            this.startInstance(options, commLineArgs, this.getEnvProps());
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public void stopNodeAgent() throws AgentException {
        try {
            this.stopInstance();
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public void stopNodeAgentForcibly(int timeout) throws AgentException {
        try {
            boolean stopped = false;
            if (timeout > 0) {
                stopped = this.stopInstanceWithinTime(timeout);
            }
            if (!stopped) {
                System.out.println("Killing Forcibly...");
                this.killRelatedProcesses();
            }
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    protected List<String> getPIDsToBeKilled() throws InstanceException {
        File[] serverDirs;
        ArrayList<String> pids = new ArrayList();
        pids = super.getPIDsToBeKilled();
        File agentDir = this.getAgentDir();
        for (File serverDir : serverDirs = agentDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.equalsIgnoreCase("agent");
            }
        })) {
            int serverPid = this.getServerPID(serverDir);
            if (serverPid == -1) continue;
            pids.add("" + serverPid);
        }
        return pids;
    }

    protected int getServerPID(File serverDir) {
        File pidFileDir = new File(serverDir, "config");
        File pidFile = new File(pidFileDir, ".__com_sun_appserv_pid");
        if (!this.isPIDFileValid(pidFileDir, pidFile)) {
            return -1;
        }
        return JvmInfoUtil.getPIDfromFileAndDelete((File)pidFile);
    }

    @Override
    protected boolean isValidRepository(File f) {
        return new File(new File(new File(f, "agent"), "bin"), PEFileLayout.START_SERV_OS).exists();
    }

    @Override
    protected boolean isValidRepository(RepositoryConfig config) {
        return this.getFileLayout(config).getStartServ().exists();
    }

    public void changeMasterPassword(AgentConfig config) throws AgentException {
        String oldInstanceName = config.getInstanceName();
        try {
            int status = this.getInstancesManager(config).getInstanceStatus();
            if (status != 3) {
                throw new AgentException(_strMgr.getString("cannotChangePassword_invalidState", (Object)config.getDisplayName(), (Object)Status.getStatusString((int)status)));
            }
            String newPass = AgentManager.getNewMasterPasswordClear(config);
            String oldPass = this.getMasterPasswordClear(config);
            boolean saveMasterPassword = this.saveMasterPassword(config);
            this.changeMasterPasswordInMasterPasswordFile(config, newPass, this.saveMasterPassword(config));
            this.changePasswordAliasKeystorePassword(config, oldPass, newPass);
            EEDomainsManager mgr = new EEDomainsManager();
            mgr.changeSSLCertificateDatabasePassword(config, oldPass, newPass);
            EEInstancesManager eeInstancesManager = (EEInstancesManager)mgr.getInstancesManager(config);
            String[] instances = eeInstancesManager.listInstances();
            for (int i = 0; i < instances.length; ++i) {
                config.setInstanceName(instances[i]);
                mgr.changeSSLCertificateDatabasePassword(config, oldPass, newPass);
                this.changePasswordAliasKeystorePassword(config, oldPass, newPass);
            }
        }
        catch (Exception ex) {
            throw new AgentException(_strMgr.getString("masterPasswordNotChanged"), ex);
        }
        finally {
            config.setInstanceName(oldInstanceName);
        }
    }

    private void createDASConfiguration() throws AgentException {
        String dasHost = (String)this.getAgentConfig().get("agent.das.host");
        String dasPort = (String)this.getAgentConfig().get("agent.das.port");
        String dasUser = (String)this.getAgentConfig().get("agent.das.user");
        String dasPassword = (String)this.getAgentConfig().get("agent.das.password");
        if (dasHost != null) {
            try {
                new DASPropertyReader(this.getAgentConfig()).write();
            }
            catch (Exception ex) {
                throw new AgentException(_strMgr.getString("dasConfigurationNotCreated"), ex);
            }
        }
    }

    private void createNodeAgentConfiguration() throws AgentException {
        try {
            new NodeAgentPropertyReader(this.getAgentConfig()).write();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AgentException(_strMgr.getString("nodeAgentConfigurationNotCreated"), ex);
        }
    }

    private void createStopAgent() throws AgentException {
        try {
            TokenValueSet tokens = EEScriptsTokens.getTokenValueSet(this.getAgentConfig());
            File stopAgentTemplate = this.getEEFileLayout().getStopAgentTemplate();
            File stopAgent = this.getEEFileLayout().getStopAgent();
            this.generateFromTemplate(tokens, stopAgentTemplate, stopAgent);
        }
        catch (Exception e) {
            throw new AgentException(_strMgr.getString("stopAgentNotCreated"), e);
        }
    }

    private void createStartAgent() throws AgentException {
        try {
            TokenValueSet tokens = EEScriptsTokens.getTokenValueSet(this.getAgentConfig());
            File startAgentTemplate = this.getEEFileLayout().getStartAgentTemplate();
            File startAgent = this.getEEFileLayout().getStartAgent();
            this.generateFromTemplate(tokens, startAgentTemplate, startAgent);
        }
        catch (Exception e) {
            throw new AgentException(_strMgr.getString("startAgentNotCreated"), e);
        }
    }

    private String getAgentUser() {
        return (String)this.getAgentConfig().get("agent.user");
    }

    private String getAgentPasswordClear() {
        return (String)this.getAgentConfig().get("agent.password");
    }

    @Override
    protected File getRepositoryRootDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryRootDir();
    }

    @Override
    protected File getRepositoryDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryDir().getParentFile();
    }

    private File getAgentDir() {
        return this.getRepositoryDir(this.getAgentConfig());
    }

    private File getAgentRoot() {
        return this.getRepositoryRootDir(this.getAgentConfig());
    }

    private AgentConfig getAgentConfig() {
        return (AgentConfig)this.getConfig();
    }

    private String getMasterPasswordClear(AgentConfig config) {
        return (String)config.get("agent.masterpassword");
    }

    private boolean saveMasterPassword(AgentConfig config) {
        Boolean b = (Boolean)config.get("agent.saveMasterPassword");
        return b;
    }

    protected static String getNewMasterPasswordClear(AgentConfig config) {
        return (String)config.get("agent.newmasterpassword");
    }

    public String[] getExtraPasswordOptions(AgentConfig config) throws AgentException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        File nssDb = layout.getNSSCertDBFile();
        if (nssDb.exists()) {
            try {
                NssStore nssStore = NssStore.getInstance(nssDb.getParentFile().getAbsolutePath(), false, this.getMasterPasswordClear(config));
                String[] result = nssStore.getTokenNamesAsArray();
                NssStore.closeInstance();
                return result;
            }
            catch (Exception ex) {
                throw new AgentException(ex);
            }
        }
        return null;
    }

    @Override
    protected Properties getEnvProps() {
        RepositoryConfig cfg = this.getConfig();
        Properties p = new Properties();
        p.setProperty("com.sun.aas.processName", "s1as8-nodeagent");
        p.setProperty("com.sun.aas.instanceName", cfg.getRepositoryName());
        p.setProperty("com.sun.aas.instanceRoot", cfg.getRepositoryRoot() + File.separator + cfg.getRepositoryName() + File.separator + "agent");
        return p;
    }
}

