/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.InvalidTargetException;
import com.sun.enterprise.diagnostics.PERemoteTargetResolver;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.ee.diagnostics.EEExecutionContext;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EERemoteTargetResolver
extends PERemoteTargetResolver {
    private static final String AGENT_CONFIG_CLASS_NAME = "com.sun.enterprise.ee.admin.servermgmt.AgentConfig";
    private static final String GET_AGENT_ROOT_METHOD = "getAgentRoot";
    private static final String GET_AGENT_NAME = "getAgentName";

    public EERemoteTargetResolver(String target, String repositoryDir, List<String> instances, TargetType type) {
        super(target, repositoryDir, false);
        this.type = type;
        this.instances = instances;
        this.setExecutionContext();
    }

    public boolean validateTarget() throws DiagnosticException {
        this.determineTargetType(this.target, this.repositoryDir);
        return this.type != null;
    }

    protected void setExecutionContext() {
        if (this.context == null) {
            if (this.instances == null && this.type == null) {
                this.instances = new ArrayList(1);
                this.context = EEExecutionContext.DAS_EC;
                this.logger.log(Level.FINEST, "diagnostic_service.execution_context_das");
            } else {
                this.context = EEExecutionContext.NODEAGENT_EC;
                this.logger.log(Level.FINEST, "diagnostic-service.execution_context_nondas");
            }
        }
    }

    protected void determineRepositoryDetails() {
        if (this.context.equals((Object)EEExecutionContext.DAS_EC)) {
            super.determineRepositoryDetails();
        } else {
            try {
                Class<?> classObj = Class.forName(AGENT_CONFIG_CLASS_NAME);
                Constructor<?> constructorObj = classObj.getDeclaredConstructor(new Class[0]);
                Object obj = constructorObj.newInstance(new Object[0]);
                Method method = classObj.getMethod(GET_AGENT_ROOT_METHOD, null);
                this.repositoryDir = (String)method.invoke(obj, null);
                method = classObj.getMethod(GET_AGENT_NAME, null);
                this.repositoryName = (String)method.invoke(obj, null);
                this.logger.log(Level.FINEST, "diagnostic-service.repository_dir", this.repositoryDir);
                if (this.type.equals((Object)EETargetType.INSTANCE)) {
                    this.repositoryDir = this.repositoryDir + File.separator + this.repositoryName;
                    this.repositoryName = this.target;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "nodeAgent.nodeagent_properties_not_found", e);
            }
        }
        this.logger.log(Level.FINEST, "diagnostic-service.repository_dir", this.repositoryDir);
        this.logger.log(Level.FINEST, "diagnostic-service.repository", this.repositoryName);
    }

    protected void determineTargetType(String targetName, String taretDir) throws DiagnosticException {
        this.logger.log(Level.FINEST, "diagnostic-service.target_type", this.type);
        if (this.type == null) {
            ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            try {
                if (targetName.equals(EETargetType.DAS.getType())) {
                    this.setTargetType(EETargetType.DAS);
                } else if (ServerHelper.isAServer((ConfigContext)configContext, (String)targetName)) {
                    this.setTargetType(EETargetType.INSTANCE);
                } else if (NodeAgentHelper.isANodeAgent((ConfigContext)configContext, (String)targetName)) {
                    this.setTargetType(EETargetType.NODEAGENT);
                } else if (ClusterHelper.isACluster((ConfigContext)configContext, (String)targetName)) {
                    this.setTargetType(EETargetType.CLUSTER);
                } else if (super.validateTarget()) {
                    this.setTargetType(EETargetType.DOMAIN);
                }
            }
            catch (ConfigException ce) {
                throw new DiagnosticException(ce.getMessage());
            }
            if (this.type == null) {
                throw new InvalidTargetException("Invalid Target :" + this.target);
            }
        }
    }

    protected void determineServiceConfigs() {
        EEExecutionContext eeContext = (EEExecutionContext)this.context;
        this.logger.log(Level.FINEST, "diagnostic-service.execution_context", eeContext.getContext());
        if (eeContext.equals(EEExecutionContext.DAS_EC) && (this.type.equals((Object)EETargetType.DOMAIN) || this.type.equals((Object)EETargetType.DAS))) {
            this.addServiceConfig("server");
        }
    }

    protected void determineInstances() {
        if (this.context.equals((Object)EEExecutionContext.DAS_EC)) {
            Server[] servers = null;
            ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (this.type.equals((Object)EETargetType.CLUSTER)) {
                try {
                    servers = ServerHelper.getServersInCluster((ConfigContext)configContext, (String)this.target);
                    this.instances = this.getInstanceNames(servers);
                }
                catch (ConfigException ce) {
                    this.logger.log(Level.WARNING, "Error occured while retrieving servers for a cluseter");
                }
            } else if (this.type.equals((Object)EETargetType.NODEAGENT)) {
                try {
                    servers = ServerHelper.getServersOfANodeAgent((ConfigContext)configContext, (String)this.target);
                    this.instances = this.getInstanceNames(servers);
                }
                catch (ConfigException ce) {
                    this.logger.log(Level.WARNING, "Error occured while retrieving servers for a node agent");
                }
            } else if (this.type.equals((Object)EETargetType.DOMAIN)) {
                try {
                    servers = ServerHelper.getServersInDomain((ConfigContext)configContext);
                    this.instances = this.getInstanceNames(servers);
                }
                catch (ConfigException ce) {
                    this.logger.log(Level.WARNING, "Error occured while retrieving servers for a domain");
                }
            } else if (this.type.equals((Object)EETargetType.INSTANCE) || this.type.equals((Object)EETargetType.DAS)) {
                if (this.instances == null) {
                    this.instances = new ArrayList(1);
                }
                this.instances.add(this.target);
            }
        }
    }

    private List<String> getInstanceNames(Server[] servers) {
        if (servers != null && servers.length > 0) {
            ArrayList<String> instances = new ArrayList<String>(5);
            for (int index = 0; index < servers.length; ++index) {
                instances.add(servers[index].getName());
            }
            return instances;
        }
        return null;
    }
}

