/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics.collect;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.diagnostics.CLIOptions;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeAgentDataCollector
implements Collector {
    private List<String> instances;
    private ConfigContext configContext;
    private String nodeAgent;
    private MBeanServerConnection mbsc;
    private Map customerInput;
    private Map configs;
    private String targetType;
    private static final String TARGET = "target";
    private static final String LOCAL = "local";
    private static final String NA_MBEAN_NAME = "com.sun.appserver.nodeagent:type=NodeAgentDiagnostic,";
    private static final String NA_MBEAN_CLASS = "com.sun.enterprise.ee.nodeagent.mbeans.NodeAgentDiagnostic";
    private static final String NA_REGISTRY_CLASS = "com.sun.enterprise.ee.admin.clientreg.NodeAgentRegistry";
    private static final String GET_NA_CONNECTION_METHOD = "getNodeAgentConnection";
    public static final String CONFIGS = "configs";
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");

    public NodeAgentDataCollector(CLIOptions options, String nodeAgent, List<String> instances, String targetType) {
        this.instances = instances;
        this.nodeAgent = nodeAgent;
        this.targetType = targetType;
        this.customerInput = options.getMap();
    }

    public Data capture() throws DiagnosticException {
        if (this.nodeAgent != null) {
            this.initialize();
            try {
                ObjectName objName = new ObjectName("com.sun.appserver.nodeagent:type=NodeAgentDiagnostic,name=" + this.nodeAgent + ",category=config");
                if (!this.targetType.equals(EETargetType.INSTANCE.getType())) {
                    this.customerInput.put(TARGET, this.nodeAgent);
                }
                this.addServiceConfigurations();
                Object[] params = new Object[]{this.customerInput, this.instances, this.targetType};
                String[] signature = new String[]{"java.util.Map", "java.util.List", "java.lang.String"};
                if (!this.mbsc.isRegistered(objName)) {
                    try {
                        logger.log(Level.INFO, "diagnostic-service.create_na_diagnostic_mbean", this.nodeAgent);
                        this.mbsc.createMBean(NA_MBEAN_CLASS, objName);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "diagnostic-service.error_creating_na_diagnostic_mbean", e);
                    }
                }
                String returnValue = (String)this.mbsc.invoke(objName, "generateReport", params, signature);
                logger.log(Level.INFO, "after collecting data from nodeagent : " + this.nodeAgent);
                if (returnValue != null) {
                    return new FileData(returnValue, "node agent details");
                }
                logger.log(Level.WARNING, "Error collecting data from node agent " + this.nodeAgent);
            }
            catch (Exception e) {
                throw new DiagnosticException(e.getMessage());
            }
        }
        return null;
    }

    private void initialize() throws DiagnosticException {
        try {
            Class<?> classObj = Class.forName(NA_REGISTRY_CLASS);
            Method method = classObj.getMethod(GET_NA_CONNECTION_METHOD, String.class);
            Object obj = method.invoke(classObj, this.nodeAgent);
            this.mbsc = (MBeanServerConnection)obj;
        }
        catch (Exception e) {
            throw new DiagnosticException(" Error while reaching : " + this.nodeAgent + e.getMessage());
        }
    }

    private void addServiceConfigurations() {
        if (this.configs == null) {
            this.configs = new HashMap();
            this.customerInput.put(CONFIGS, this.configs);
        }
        for (String instance : this.instances) {
            try {
                HashMap<String, Object> instanceMap = new HashMap<String, Object>(8);
                ServiceConfig config = new ServiceConfig(false, null, instance);
                instanceMap.put("capture-app-dd", new Boolean(config.isCaptureAppDDEnabled()));
                instanceMap.put("compute-checksum", new Boolean(config.isCaptureChecksumEnabled()));
                instanceMap.put("capture-system-info", new Boolean(config.isCaptureSystemInfoEnabled()));
                instanceMap.put("capture-hadb-info", new Boolean(config.isCaptureHadbInfoEnabled()));
                instanceMap.put("capture-install-log", new Boolean(config.isCaptureInstallLogEnabled()));
                instanceMap.put("verify-config", new Boolean(config.isVerifyDomainEnabled()));
                instanceMap.put("max-log-entries", new Integer(config.getMaxNoOfEntries()));
                instanceMap.put("min-log-level", new Integer(config.getMinLogLevel()));
                instanceMap.put("log-file", config.getLogFile());
                this.configs.put(instance, instanceMap);
            }
            catch (DiagnosticException diagnosticException) {}
        }
    }
}

