/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.ejb.iiop;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceBase;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.FailureNotificationAction;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationAction;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownAction;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.ext.IiopInfo;
import com.sun.enterprise.iiop.ASORBUtilities;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IiopFolbGmsClient
extends LocalObject
implements Action,
FailureNotificationAction,
FailureNotificationActionFactory,
JoinNotificationAction,
JoinNotificationActionFactory,
PlannedShutdownAction,
PlannedShutdownActionFactory,
GroupInfoService {
    private static Logger _logger = null;
    private GroupManagementService gms = null;
    private Map<String, ClusterInstanceInfo> currentMembers;
    private GIS gis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IiopFolbGmsClient() {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient->: " + this.gms);
            }
            this.gms = GMSFactory.getGMSModule();
            this.gms.addActionFactory((FailureNotificationActionFactory)this);
            this.gms.addActionFactory((JoinNotificationActionFactory)this);
            this.gms.addActionFactory((PlannedShutdownActionFactory)this);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient: GMS action factories added");
            }
            this.gis = new GIS();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient: IIOP GIS created");
            }
            this.currentMembers = new HashMap<String, ClusterInstanceInfo>();
            Set entrySet = this.gms.getAllMemberDetails((Serializable)((Object)"IIOPListenerEndPoints")).entrySet();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient: initializing to: " + entrySet.toString());
            }
            for (Map.Entry entry : entrySet) {
                ClusterInstanceInfo cii = this.convert((String)entry.getKey(), (List)entry.getValue());
                this.currentMembers.put(cii.name, cii);
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient<-: " + this.gms);
            }
        }
    }

    public Action produceAction() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) {
        try {
            signal.acquire();
            this.handleSignal(signal);
        }
        catch (SignalAcquireException e) {
            _logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
        finally {
            try {
                signal.release();
            }
            catch (SignalReleaseException e) {
                _logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
    }

    public boolean addObserver(GroupInfoServiceObserver x) {
        return this.gis.addObserver(x);
    }

    public void notifyObservers() {
        this.gis.notifyObservers();
    }

    public List<ClusterInstanceInfo> getClusterInstanceInfo(String[] adapterName) {
        return this.gis.getClusterInstanceInfo(adapterName);
    }

    public boolean shouldAddAddressesToNonReferenceFactory(String[] x) {
        return this.gis.shouldAddAddressesToNonReferenceFactory(x);
    }

    public boolean shouldAddMembershipLabel(String[] adapterName) {
        return this.gis.shouldAddMembershipLabel(adapterName);
    }

    private void handleSignal(Signal signal) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IiopFolbGmsClient.handleSignal: signal from: " + signal.getMemberToken());
            _logger.log(Level.FINE, "IiopFolbGmsClient.handleSignal: map entryset: " + signal.getMemberDetails().entrySet());
        }
        if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
            this.removeMember(signal);
        } else if (signal instanceof JoinNotificationSignal) {
            this.addMember(signal);
        } else {
            _logger.log(Level.SEVERE, "IiopFolbGmsClient.handleSignal: unknown signal: " + signal.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(Signal signal) {
        String instanceName = signal.getMemberToken();
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.removeMember->: " + instanceName);
            }
            Map<String, ClusterInstanceInfo> map = this.currentMembers;
            synchronized (map) {
                if (this.currentMembers.get(instanceName) != null) {
                    this.currentMembers.remove(instanceName);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.removeMember: " + instanceName + " removed - notifying listeners");
                    }
                    this.gis.notifyObservers();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.removeMember: " + instanceName + " - notification complete");
                    }
                } else if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IiopFolbGmsClient.removeMember: " + instanceName + " not present: no action");
                }
            }
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.removeMember<-: " + instanceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMember(Signal signal) {
        String instanceName = signal.getMemberToken();
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.addMember->: " + instanceName);
            }
            Map<String, ClusterInstanceInfo> map = this.currentMembers;
            synchronized (map) {
                if (this.currentMembers.get(instanceName) != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.addMember: " + instanceName + " already present: no action");
                    }
                } else {
                    ClusterInstanceInfo clusterInstanceInfo = this.convert(signal);
                    this.currentMembers.put(clusterInstanceInfo.name, clusterInstanceInfo);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.addMember: " + instanceName + " added - notifying listeners");
                    }
                    this.gis.notifyObservers();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.addMember: " + instanceName + " - notification complete");
                    }
                }
            }
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.addMember<-: " + instanceName);
            }
        }
    }

    private ClusterInstanceInfo convert(Signal signal) {
        return this.convert(signal.getMemberToken(), (List)signal.getMemberDetails().get("IIOPListenerEndPoints"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterInstanceInfo convert(String instanceName, List<IiopInfo> iiopInfoList) {
        int weight;
        LinkedList<SocketInfo> listOfSocketInfo;
        ClusterInstanceInfo clusterInstanceInfo;
        block15: {
            clusterInstanceInfo = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.convert->: " + instanceName);
            }
            listOfSocketInfo = new LinkedList<SocketInfo>();
            weight = -1;
            if (iiopInfoList != null) break block15;
            _logger.fine("GMS did not return the list of members. list is empty.");
            ClusterInstanceInfo clusterInstanceInfo2 = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.convert<-: " + instanceName + ": " + ASORBUtilities.toString(clusterInstanceInfo));
            }
            return clusterInstanceInfo2;
        }
        try {
            for (IiopInfo iiopInfo : iiopInfoList) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IiopFolbGmsClient.convert: " + instanceName + ": " + iiopInfo.toString());
                }
                if (weight == -1) {
                    weight = iiopInfo.getWeight();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.convert: " + instanceName + ": weight: " + Integer.toString(weight));
                    }
                }
                String type = iiopInfo.getID();
                String host = iiopInfo.getAddress();
                String port = iiopInfo.getPort();
                if ("0.0.0.0".equals(host)) {
                    String hostname = iiopInfo.getHostName();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IiopFolbGmsClient.convert: " + instanceName + ": host is: " + host + "; changing to: " + hostname);
                    }
                    host = hostname;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IiopFolbGmsClient.convert: " + instanceName + ": type/host/port:" + " " + type + " " + host + " " + port);
                }
                listOfSocketInfo.add(new SocketInfo(type, host, Integer.valueOf(port).intValue()));
            }
            SocketInfo[] arrayOfSocketInfo = new SocketInfo[listOfSocketInfo.size()];
            int i = 0;
            for (SocketInfo si : listOfSocketInfo) {
                arrayOfSocketInfo[i++] = si;
            }
            ClusterInstanceInfo clusterInstanceInfo3 = clusterInstanceInfo = new ClusterInstanceInfo(instanceName, weight, arrayOfSocketInfo);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.convert<-: " + instanceName + ": " + ASORBUtilities.toString((ClusterInstanceInfo)clusterInstanceInfo));
            }
            return clusterInstanceInfo3;
        }
        catch (Throwable throwable) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient.convert<-: " + instanceName + ": " + ASORBUtilities.toString(clusterInstanceInfo));
            }
            throw throwable;
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.resource.corba");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GIS
    extends GroupInfoServiceBase {
        private GIS() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ClusterInstanceInfo> getClusterInstanceInfo(String[] adapterName) {
            if (adapterName == null) {
                adapterName = new String[]{};
            }
            LinkedList<ClusterInstanceInfo> result = new LinkedList<ClusterInstanceInfo>();
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IiopFolbGmsClient.getClusterInstanceInfo->: " + ORBUtility.formatStringArray((String[])adapterName));
                }
                Map map = IiopFolbGmsClient.this.currentMembers;
                synchronized (map) {
                    for (ClusterInstanceInfo cii : IiopFolbGmsClient.this.currentMembers.values()) {
                        result.add(cii);
                    }
                    LinkedList<ClusterInstanceInfo> linkedList = result;
                    return linkedList;
                }
            }
            finally {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IiopFolbGmsClient.getClusterInstanceInfo<-: " + ORBUtility.formatStringArray((String[])adapterName) + ": " + result);
                }
            }
        }

        public boolean shouldAddAddressesToNonReferenceFactory(String[] adaptername) {
            return false;
        }

        public boolean shouldAddMembershipLabel(String[] adapterName) {
            return true;
        }
    }
}

