/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.ee.selfmanagement.actions.ThreadHangActionMBean;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;

public class ThreadHangAction
implements ThreadHangActionMBean,
MonitoringLevelListener,
MBeanRegistration,
NotificationListener {
    private static Logger _logger = null;
    private static StringManager localStrings = null;
    private static String msgPrefix = null;
    private static String instanceName = null;
    private static String clusterName = null;
    private long thresholdWaitWindow = 0L;
    private boolean isMonitoringEnabled = false;
    private MBeanServer mbeanServer = null;
    private final long DEFAULT_LB_TIMEOUT = 60000L;
    private final String TYPE_KEY_NAME = "type";
    private final String REQ_PROCESSOR_TYPE = "RequestProcessor";
    private final String REQ_URI = "currentUri";
    private final String REQ_PROSTIME = "requestProcessingTime";
    private final String REQ_COMPTIME = "requestCompletionTime";
    private final String REQ_THREAD = "workerThreadID";
    private final String REQ_SERVER_PORT = "serverPort";
    private boolean stopThread = false;
    private String alertRef = null;
    private String domainName = null;
    private ObjectName objPattern = null;

    public ThreadHangAction() {
        try {
            String domain = ApplicationServer.getServerContext().getDefaultDomainName();
            ObjectName objName = new ObjectName(domain, "type", "RequestProcessor");
            String concat = objName.toString() + ",*";
            this.objPattern = new ObjectName(concat);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    public long getThresholdWait() {
        return this.thresholdWaitWindow;
    }

    public synchronized void setThresholdWait(long value) {
        try {
            long lbTimeout = 0L;
            ConfigContext cfgCtx = ApplicationServer.getServerContext().getConfigContext();
            Set lbs = ServerBeansFactory.getLbConfigs((ConfigContext)cfgCtx);
            LbConfig selectLb = null;
            for (LbConfig lb : lbs) {
                if (lb.getClusterRefByRef(clusterName) != null) {
                    selectLb = lb;
                    break;
                }
                if (lb.getServerRefByRef(instanceName) == null) continue;
                selectLb = lb;
                break;
            }
            if (selectLb != null) {
                String val = selectLb.getResponseTimeoutInSeconds();
                lbTimeout = Long.parseLong(val);
            }
            if (lbTimeout == 0L) {
                if (value < 60000L) {
                    _logger.log(Level.WARNING, "sgmt.threadhangaction_deftimeout", new Object[]{msgPrefix, Long.toString(value), Long.toString(60000L)});
                    value = 60000L;
                }
            } else if (value < lbTimeout) {
                _logger.log(Level.WARNING, "sgmt.threadhangaction_lbtimeout", new Object[]{msgPrefix, Long.toString(value), Long.toString(lbTimeout)});
                value = lbTimeout;
            }
            this.thresholdWaitWindow = value;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName objName) throws Exception {
        this.mbeanServer = mbs;
        this.isMonitoringEnabled = this.checkMonitoringEnabled();
        if (!this.isMonitoringEnabled) {
            _logger.log(Level.WARNING, "sgmt.threadhangaction_nostats");
        }
        return objName;
    }

    boolean checkMonitoringEnabled() throws ConfigException {
        ModuleMonitoringLevels levels;
        ServerContext srCtx = ApplicationServer.getServerContext();
        ConfigContext cfgCtx = srCtx.getConfigContext();
        Config instanceCfg = ServerBeansFactory.getConfigBean((ConfigContext)cfgCtx);
        MonitoringLevel monitoringLevel = MonitoringLevel.OFF;
        if (instanceCfg.getMonitoringService() != null && (levels = instanceCfg.getMonitoringService().getModuleMonitoringLevels()) != null) {
            monitoringLevel = MonitoringLevel.instance((String)levels.getHttpService());
        }
        this.isMonitoringEnabled = !MonitoringLevel.OFF.equals((Object)monitoringLevel);
        return this.isMonitoringEnabled;
    }

    public void postRegister(Boolean isRegistrationDone) {
        this.registerMonitoringLevelListener();
    }

    public void registerMonitoringLevelListener() {
        MonitoringRegistry monitoringRegistry = ApplicationServer.getServerContext().getMonitoringRegistry();
        monitoringRegistry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.HTTP_LISTENER);
    }

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (MonitoredObjectType.HTTP_LISTENER.equals(type)) {
            if (MonitoringLevel.OFF.equals((Object)to)) {
                if (this.isMonitoringEnabled) {
                    this.isMonitoringEnabled = false;
                    _logger.log(Level.INFO, "sgmt.threadhangaction_statsdisabled");
                }
            } else if (!this.isMonitoringEnabled) {
                this.isMonitoringEnabled = true;
                _logger.log(Level.INFO, "sgmt.threadhangaction_statsenabled");
            }
        }
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public synchronized void handleNotification(Notification notif, Object notifObj) {
        int potentialCount = 0;
        try {
            if (this.isMonitoringEnabled) {
                Set<ObjectName> requestObjs = this.mbeanServer.queryNames(this.objPattern, null);
                if (requestObjs.size() != 0) {
                    for (ObjectName request : requestObjs) {
                        Long completionTime = (Long)this.mbeanServer.getAttribute(request, "requestCompletionTime");
                        Long processingTime = (Long)this.mbeanServer.getAttribute(request, "requestProcessingTime");
                        Long workerThreadId = (Long)this.mbeanServer.getAttribute(request, "workerThreadID");
                        if (completionTime != 0L || processingTime <= this.thresholdWaitWindow) continue;
                        ++potentialCount;
                        Integer port = (Integer)this.mbeanServer.getAttribute(request, "serverPort");
                        String uri = (String)this.mbeanServer.getAttribute(request, "currentUri");
                        _logger.log(Level.WARNING, "sgmt.threadhangaction_potentialthread", new Object[]{msgPrefix, port, uri});
                        if (!this.stopThread) continue;
                        String domain = ApplicationServer.getServerContext().getDefaultDomainName();
                        ObjectName oname = new ObjectName(domain + ":" + "type=Selector,name=http" + port);
                        Object[] params = new Object[1];
                        String[] sig = new String[]{"long"};
                        params[0] = workerThreadId;
                        Boolean isCancelled = (Boolean)this.mbeanServer.invoke(oname, "cancelThreadExecution", params, sig);
                        if (isCancelled.booleanValue()) {
                            _logger.log(Level.SEVERE, "sgmt.threadhangaction_stopd", new Object[]{msgPrefix, port, uri});
                            continue;
                        }
                        _logger.log(Level.WARNING, "sgtm_threadhangaction_notstopd", new Object[]{msgPrefix, port, uri});
                    }
                    if (potentialCount > 0) {
                        this.sendMailAlert(potentialCount);
                    }
                    _logger.log(Level.INFO, "sgmt.threadhangaction_potentialcount", new Object[]{msgPrefix, potentialCount});
                } else {
                    _logger.log(Level.INFO, "sgmt.threadhangaction_norequests", msgPrefix);
                }
            } else {
                _logger.log(Level.WARNING, "sgmt.threadhangaction_nostats", msgPrefix);
            }
        }
        catch (SecurityException ex) {
            _logger.log(Level.SEVERE, "sgmt.threadhangaction_securityex", ex);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "sgmt.threadhangaction_mbeanex", ex);
        }
    }

    private void sendMailAlert(int potentialCount) {
        String alertMsg = msgPrefix + localStrings.getString("threadhang.potentialcount", (Object)potentialCount);
        if (this.alertRef != null) {
            try {
                ServerContext srCtx = ApplicationServer.getServerContext();
                ConfigContext cfgCtx = srCtx.getConfigContext();
                Domain domain = ServerBeansFactory.getDomainBean((ConfigContext)cfgCtx);
                Applications apps = domain.getApplications();
                Mbean definedMBean = apps.getMbeanByName(this.alertRef);
                ObjectName objName = CustomMBeanRegistrationImpl.getCascadingAwareObjectName((Mbean)definedMBean);
                Object[] params = new Object[2];
                String[] signature = new String[2];
                params[0] = new Notification("thread.hang", (Object)this, 0L, alertMsg);
                params[1] = null;
                signature[0] = Notification.class.getName();
                signature[1] = Object.class.getName();
                this.mbeanServer.invoke(objName, "notification", params, signature);
            }
            catch (InstanceNotFoundException ex) {
                _logger.log(Level.SEVERE, "sgmt.threadhangaction_nosuchobj", new Object[]{msgPrefix, this.alertRef});
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "sgmt.threadhangaction_excep", ex);
            }
        } else {
            _logger.log(Level.WARNING, "threadhangaction.noalertref");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public synchronized void setMailAlertAppRef(String appRef) {
        this.alertRef = appRef;
    }

    public String getMailAlertAppRef() {
        return this.alertRef;
    }

    public synchronized void setStopThread(boolean stop) {
        this.stopThread = stop;
    }

    public boolean getStopThread() {
        return this.stopThread;
    }

    public void preDeregister() {
        this.unregisterMonitoringLevelListener();
    }

    public void unregisterMonitoringLevelListener() {
        MonitoringRegistry monitoringRegistry = ApplicationServer.getServerContext().getMonitoringRegistry();
        monitoringRegistry.unregisterMonitoringLevelListener((MonitoringLevelListener)this);
    }

    public void postDeregister() {
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");
        localStrings = StringManager.getManager(ThreadHangAction.class);
        instanceName = System.getProperty("com.sun.aas.instanceName");
        clusterName = System.getProperty("com.sun.aas.clusterName");
        String domainName = System.getProperty("com.sun.aas.domainName");
        msgPrefix = clusterName != null ? localStrings.getString("threadhang.incluster", (Object)instanceName, (Object)clusterName, (Object)domainName) : localStrings.getString("threadhang.ininstance", (Object)instanceName, (Object)domainName);
    }
}

