/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.server.autotxrecovery;

import com.sun.enterprise.autotxrecovery.TransactionRecovery;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.server.autotxrecovery.core.TxnFailureRecoveryActionFactoryImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EEAutoTransactionRecoveryServiceImpl
implements TransactionRecovery {
    Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.transaction");
    private ConfigContext configContext_ = null;
    private boolean startRecovery;
    private boolean delegatedRecovery;
    private String instanceName;
    private String clusterName;
    private String waitTime = "60";
    private GroupManagementService gms = null;
    private static StringManager sm = StringManager.getManager(EEAutoTransactionRecoveryServiceImpl.class);
    private static final String serviceName = "TRANSACTION-RECOVERY-SERVICE";
    private static final String TXLOGDIR = "TX-LOG-DIR";
    private static final String DELEGATEDRECOVERY = "delegated-recovery";
    private static final String WAITTIMEBEFORERECOVERY = "wait-time-before-recovery-insec";
    private static final String TXLOGLOCATION = "TX_LOG_DIR";
    private static final String ISRECOVERABLE = "IS_RECOVERABLE";
    private static final String WAITTIMEBEFORESTARTINGRECOVERY = "WAIT_TIME";
    private String nfstxLog = "";
    private String txLogDir = "";

    public void start() {
        this.init(ApplicationServer.getServerContext());
    }

    private void init(ServerContext context) {
        block14: {
            try {
                boolean isRecoverable;
                this.configContext_ = context.getConfigContext();
                this.instanceName = context.getInstanceName();
                if (!ServerHelper.isServerClustered((ConfigContext)this.configContext_, (String)this.instanceName)) {
                    return;
                }
                this.clusterName = ClusterHelper.getClusterForInstance((ConfigContext)context.getConfigContext(), (String)this.instanceName).getName();
                if (!GMSFactory.isGMSEnabled((String)this.clusterName)) {
                    return;
                }
                this.startRecovery = ServerHelper.getConfigForServer((ConfigContext)this.configContext_, (String)this.instanceName).getTransactionService().isAutomaticRecovery();
                TransactionService txnService = null;
                txnService = ServerBeansFactory.getTransactionServiceBean((ConfigContext)this.configContext_);
                this.txLogDir = this.getTxLogDir();
                ElementProperty[] eprops = txnService.getElementProperty();
                for (int index = 0; index < eprops.length; ++index) {
                    if (DELEGATEDRECOVERY.equals(eprops[index].getName())) {
                        this.delegatedRecovery = Boolean.parseBoolean(eprops[index].getValue());
                    }
                    if (!WAITTIMEBEFORERECOVERY.equals(eprops[index].getName())) continue;
                    try {
                        this.waitTime = eprops[index].getValue();
                        Integer.parseInt(this.waitTime);
                        continue;
                    }
                    catch (Exception e) {
                        this.waitTime = "60";
                        if (!this._logger.isLoggable(Level.WARNING)) continue;
                        this._logger.log(Level.WARNING, "Invalid wait time for the recovery", e);
                    }
                }
                SystemProperty[] sysArray = ServerHelper.getServerByName((ConfigContext)this.configContext_, (String)this.instanceName).getSystemProperty();
                for (int i = 0; i < sysArray.length; ++i) {
                    if (!sysArray[i].getName().equals(TXLOGDIR)) continue;
                    this.nfstxLog = sysArray[i].getValue();
                }
                if (this.delegatedRecovery && !this.nfstxLog.equals("")) {
                    this.txLogDir = this.nfstxLog;
                }
                boolean bl = isRecoverable = this.delegatedRecovery && this.startRecovery;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.tx_log_info", (Object)this.txLogDir, (Object)this.delegatedRecovery));
                }
                this.gms = GMSFactory.getGMSModule((String)this.clusterName);
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.log(Level.INFO, sm.getString("enterprise_autotxrecovery.registering_updating_member_details"));
                }
                this.gms.addActionFactory(serviceName, (FailureRecoveryActionFactory)new TxnFailureRecoveryActionFactoryImpl());
                this.gms.updateMemberDetails(this.instanceName, (Serializable)((Object)TXLOGLOCATION), (Serializable)((Object)this.txLogDir));
                this.gms.updateMemberDetails(this.instanceName, (Serializable)((Object)ISRECOVERABLE), (Serializable)((Object)(isRecoverable + "")));
                this.gms.updateMemberDetails(this.instanceName, (Serializable)((Object)WAITTIMEBEFORESTARTINGRECOVERY), (Serializable)((Object)this.waitTime));
                this.checkIfFenceLowered();
            }
            catch (ConfigException ce) {
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.config_excep"), ce);
                }
            }
            catch (GMSException e) {
                if (!this._logger.isLoggable(Level.WARNING)) break block14;
                this._logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.gms_excep"), e);
            }
        }
    }

    public void raiseFence() {
        block8: {
            try {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Raising the Fence");
                }
                if (!ServerHelper.isServerClustered((ConfigContext)this.configContext_, (String)this.instanceName)) {
                    return;
                }
                if (this.gms == null) {
                    return;
                }
                GroupHandle gh = this.gms.getGroupHandle();
                gh.raiseFence(serviceName, this.instanceName);
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Raised the Fence");
                }
            }
            catch (GMSException e) {
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.Error_raising_fence"), e);
                }
            }
            catch (Exception ex) {
                if (!this._logger.isLoggable(Level.WARNING)) break block8;
                this._logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.Error_raising_fence"), ex);
            }
        }
    }

    public void lowerFence() {
        block11: {
            try {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Lowering the Fence");
                }
                if (!ServerHelper.isServerClustered((ConfigContext)this.configContext_, (String)this.instanceName)) {
                    return;
                }
                if (this.gms == null) {
                    return;
                }
                GroupHandle gh = this.gms.getGroupHandle();
                gh.lowerFence(serviceName, this.instanceName);
                if (gh.isFenced(serviceName, this.instanceName)) {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.FINE, "There is a fence");
                    }
                } else if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "There is no fence");
                }
            }
            catch (GMSException e) {
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.Error_lowering_fence"), e);
                }
            }
            catch (Exception ex) {
                if (!this._logger.isLoggable(Level.WARNING)) break block11;
                this._logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.Error_lowering_fence"), ex);
            }
        }
    }

    private void checkIfFenceLowered() {
        GroupHandle gh = this.gms.getGroupHandle();
        while (gh.isFenced(serviceName, this.instanceName)) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.waiting_till_fence_lowered"));
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    private String getTxLogDir() throws ConfigException {
        TransactionService txnService = ServerBeansFactory.getTransactionServiceBean((ConfigContext)this.configContext_);
        String logdir = txnService.getTxLogDir();
        if (logdir == null) {
            Domain svr = null;
            svr = ServerBeansFactory.getDomainBean((ConfigContext)this.configContext_);
            logdir = svr.getLogRoot();
            if (logdir == null) {
                logdir = FileUtil.getAbsolutePath((String)(".." + File.separator + "logs"));
            }
        } else if (!new File(logdir).isAbsolute()) {
            Domain svr = null;
            svr = ServerBeansFactory.getDomainBean((ConfigContext)this.configContext_);
            String logroot = svr.getLogRoot();
            logdir = logroot != null ? logroot + File.separator + logdir : FileUtil.getAbsolutePath((String)(".." + File.separator + "logs" + File.separator + logdir));
        }
        logdir = logdir + File.separator + this.instanceName + File.separator + "tx";
        return logdir;
    }
}

