/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.RequestMediator;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.TimestampCommand;
import com.sun.enterprise.ee.synchronization.TimestampRemoveCommand;
import com.sun.enterprise.ee.synchronization.store.StoreException;
import com.sun.enterprise.ee.synchronization.store.SynchronizationMemento;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseRequestMediator
implements RequestMediator {
    protected static final Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    protected SynchronizationRequest _request = null;
    protected Exception _exception = null;
    protected DASPropertyReader _dasProperties = null;
    protected boolean _isException = false;
    protected Transaction _tx = null;
    protected SynchronizationResponse _response = null;
    protected SynchronizationMemento _memento = null;

    public SynchronizationMemento getMemento() {
        return this._memento;
    }

    protected abstract Command getGetCommand();

    protected abstract Command getResponseCommand();

    protected void execute() throws Exception {
        Command cGet = this.getGetCommand();
        cGet.execute();
        this._response = (SynchronizationResponse)cGet.getResult();
        this._memento = new SynchronizationMemento(this._response);
        this._memento.saveState();
        Command cProcess = this.getResponseCommand();
        cProcess.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.execute();
            this._tx.voteCommit();
            _logger.log(Level.FINE, "synchronization.vote_commit", this._request.getMetaFileName());
        }
        catch (Exception e) {
            this._tx.voteRollback();
            _logger.log(Level.INFO, "synchronization.vote_rollback", this._request.getMetaFileName());
            this._exception = e;
            this._isException = true;
        }
        finally {
            this.commit();
        }
    }

    protected void commit() {
        if (this._tx.isCommited()) {
            try {
                if (this._memento != null) {
                    this._memento.commit();
                }
                _logger.log(Level.FINE, "synchronization.tran_commit", this._request.getMetaFileName());
            }
            catch (StoreException se) {
                _logger.log(Level.INFO, "synchronization.store_commit_error", se);
            }
            try {
                TimestampCommand cTimestamp = new TimestampCommand(this._request, this._response);
                cTimestamp.execute();
            }
            catch (SynchronizationException e) {
                _logger.log(Level.INFO, "synchronization.timestamp_command_error", e);
            }
        } else {
            try {
                if (this._memento != null) {
                    this._memento.rollback();
                }
            }
            catch (StoreException se) {
                _logger.log(Level.INFO, "synchronization.store_rollback_error", se);
            }
            try {
                TimestampRemoveCommand cTSRemove = new TimestampRemoveCommand(this._request, this._response);
                cTSRemove.execute();
            }
            catch (SynchronizationException e) {
                _logger.log(Level.INFO, "synchronization.timestamp_command_error", e);
            }
        }
    }

    public int getStatusCode() {
        int status = 1;
        if (!this.isException()) {
            status = 0;
        }
        return status;
    }

    public boolean isException() {
        return this._isException;
    }

    public Exception getException() {
        return this._exception;
    }

    public SynchronizationRequest getRequest() {
        return this._request;
    }

    public SynchronizationResponse getResponse() {
        return this._response;
    }

    File getRequestDir() {
        File reqDir = null;
        try {
            String file;
            File f;
            SynchronizationRequest[] reqs;
            if (this._response != null && (reqs = this._response.getReply())[0] != null && (f = new File(file = reqs[0].getFileName())).isDirectory()) {
                reqDir = f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reqDir;
    }

    public List getCRInventory() {
        List crList = null;
        try {
            SynchronizationRequest[] reqs;
            if (this._response != null && (reqs = this._response.getReply())[0] != null) {
                crList = reqs[0].getInventory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crList;
    }
}

