/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.http;

import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.http.HttpUnzipper;
import com.sun.enterprise.ee.synchronization.http.HttpUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class HttpGetCommand
implements Command {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(HttpGetCommand.class);
    private SynchronizationRequest _request = null;
    private SynchronizationResponse _result = null;
    private DASPropertyReader _dpr = null;
    private String _url = null;
    private static final String NAME = "Synchronization-Get-Command";

    HttpGetCommand(SynchronizationRequest req, DASPropertyReader dpr, String url) {
        this._request = req;
        this._dpr = dpr;
        this._url = url;
    }

    public void execute() throws SynchronizationException {
        URLConnection conn = null;
        BufferedInputStream bis = null;
        try {
            _logger.log(Level.FINE, "synchronization.request_start", this._request.getMetaFileName());
            conn = HttpUtils.getConnection(this._url, true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(this._request.getPostData());
            out.write("\r\n");
            out.flush();
            out.close();
            bis = new BufferedInputStream(conn.getInputStream());
            String baseDir = this._request.getBaseDirectory();
            HttpUnzipper unzipper = new HttpUnzipper(baseDir);
            this._result = unzipper.writeZip(bis, "com.sun.appserv.SynchronizationResponse");
            _logger.log(Level.FINE, "synchronization.file_received", this._request.getMetaFileName());
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("fileRetrieveError", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg, e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
            catch (Exception e) {}
        }
        if (this._result == null) {
            String msg = _localStrMgr.getString("fileRetrieveError", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResponse(File zip) throws IOException, ClassNotFoundException, SynchronizationException {
        ZipFile zipFile = new ZipFile(zip);
        ZipEntry response = zipFile.getEntry("com.sun.appserv.SynchronizationResponse");
        if (response == null) {
            String msg = _localStrMgr.getString("responseEntryNotFound", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg);
        }
        InputStream zis = null;
        ObjectInputStream in = null;
        try {
            zis = zipFile.getInputStream(response);
            in = new ObjectInputStream(zis);
            this._result = (SynchronizationResponse)in.readObject();
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (in != null) {
                in.close();
            }
        }
        this._result.setZipLocation(zip.getCanonicalPath());
        this._result.setLastModifiedOfZip(zip.lastModified());
        zip.deleteOnExit();
        try {
            InetAddress host = InetAddress.getLocalHost();
            this._result.setDasHostName(host.getHostName());
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
    }

    public String getName() {
        return NAME;
    }

    public Object getResult() {
        return this._result;
    }
}

