/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.tx;

import com.sun.enterprise.ee.synchronization.tx.Transaction;
import com.sun.enterprise.util.i18n.StringManager;

public class TransactionManager {
    private static final StringManager sMgr = StringManager.getManager(TransactionManager.class);
    private int activeTx = 0;
    private long timeout = 0L;
    private Object lock = new Object();
    private static TransactionManager tm = new TransactionManager();

    public static TransactionManager getTransactionManager() {
        return tm;
    }

    public Transaction begin(int numParties) {
        if (numParties < 0) {
            throw new IllegalArgumentException(sMgr.getString("zeroTxTimeoutError"));
        }
        ++this.activeTx;
        return new Transaction(this.activeTx, numParties, this.timeout);
    }

    public Transaction begin(int numParties, long msecs) {
        if (msecs < 0L) {
            throw new IllegalArgumentException("Transaction time out should be non zero value");
        }
        ++this.activeTx;
        return new Transaction(this.activeTx, numParties, msecs);
    }

    public int numActiveTransactions() {
        return this.activeTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resolveTransaction(int tx) {
        Object object = this.lock;
        synchronized (object) {
            return this.activeTx--;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTransactionTimeout(long msecs) {
        Object object = this.lock;
        synchronized (object) {
            this.timeout = msecs;
        }
    }

    public long getDefaultTransactionTimeout() {
        return this.timeout;
    }
}

