/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.enterprise.security.web.SingleSignOnEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    public String[] sessionIds = new String[0];
    public boolean dirty = false;
    private long version = 0L;

    public HASingleSignOnEntry(Principal principal, String authType, String username, String password, String realmName) {
        super(principal, authType, username, password, realmName);
    }

    public synchronized void addSessionId(String sessionId) {
        for (int i = 0; i < this.sessionIds.length; ++i) {
            if (!sessionId.equals(this.sessionIds[i])) continue;
            return;
        }
        String[] results = new String[this.sessions.length + 1];
        System.arraycopy(this.sessions, 0, results, 0, this.sessions.length);
        results[this.sessions.length] = sessionId;
        this.sessionIds = results;
    }

    public void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObject(stream);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.authType);
        stream.writeObject(this.username);
        stream.writeObject(this.password);
        stream.writeObject(this.realmName);
        stream.writeObject(new Long(this.lastAccessTime));
        Principal pal = null;
        if (this.principal != null && this.principal instanceof Serializable) {
            pal = this.principal;
        }
        stream.writeObject(pal);
    }

    public void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = (String)stream.readObject();
        this.username = (String)stream.readObject();
        this.password = (String)stream.readObject();
        this.realmName = (String)stream.readObject();
        this.lastAccessTime = (Long)stream.readObject();
        this.principal = (Principal)stream.readObject();
    }

    public void incrementVersion() {
        ++this.version;
    }

    public void decrementVersion() {
        --this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long value) {
        this.version = value;
    }

    public String toString() {
        String str = "HASSOEntry:: principal =" + this.principal + " authType =" + this.authType + " username =" + this.username + "  password =" + this.password;
        return str;
    }
}

