/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.initialization;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebContainer;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerConfigReader
extends ServerConfigLookup {
    private static final int DEFAULT_HASTORE_POOL_SIZE = 100;
    private static final int DEFAULT_HASTORE_POOL_UPPER_SIZE = -1;
    private static final int DEFAULT_HASTORE_POOL_POLL_TIME = 100;
    private static String HASTORE_POOL_SIZE_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ha-store-pool-size']";
    private static String HASTORE_POOL_UPPER_SIZE_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ha-store-upper-pool-size']";
    private static String HASTORE_POOL_POLL_TIME_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ha-store-poll-time']";
    private static String HADB_DBSTATE_CLASS_NAME = "com.sun.hadb.dbstate.DbState";
    protected static boolean _isMonitoringEnabled = false;
    protected static boolean _isHADBInstalled = false;
    private static Logger _logger;

    public ServerConfigReader() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public static boolean isMonitoringEnabled() {
        return ServerConfigReader.isPrivateMonitoringEnabled() || ServerConfigReader.isPublicMonitoringEnabled();
    }

    public static boolean isPrivateMonitoringEnabled() {
        return _isMonitoringEnabled;
    }

    public static boolean isPublicMonitoringEnabled() {
        return WebContainer.isMonitoringEnabled();
    }

    protected static boolean checkMonitoringEnabled() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_WEB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isHADBInstalled() {
        return _isHADBInstalled;
    }

    protected static boolean checkHADBInstalled() {
        boolean result = false;
        Object dbStateInstance = null;
        try {
            dbStateInstance = ServerConfigReader.createHADBObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dbStateInstance != null) {
            result = true;
        }
        return result;
    }

    public int getHAStorePoolSizeFromConfig() {
        return this.getWebContainerAvailabilityPropertyInt(HASTORE_POOL_SIZE_XPATH_STRING, 100);
    }

    public int getHAStorePoolUpperSizeFromConfig() {
        return this.getWebContainerAvailabilityPropertyInt(HASTORE_POOL_UPPER_SIZE_XPATH_STRING, -1);
    }

    public int getHAStorePoolPollTimeFromConfig() {
        return this.getWebContainerAvailabilityPropertyInt(HASTORE_POOL_POLL_TIME_XPATH_STRING, 100);
    }

    public String getConnectionURLFromConfigForOracle() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("URL")) continue;
                sb.append(value);
                url = sb.toString();
            }
        }
        _logger.finest("IN NEW getConnectionURLFromConfigForOracle: url=" + url);
        return url;
    }

    private static Object createHADBObject() {
        Object testInstance = null;
        String className = HADB_DBSTATE_CLASS_NAME;
        _logger.finest("attempting to load DbState class");
        try {
            testInstance = Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            _logger.finest("unable to load DbState - HADB is not installed");
        }
        return testInstance;
    }

    static {
        _isMonitoringEnabled = ServerConfigReader.checkMonitoringEnabled();
        _isHADBInstalled = ServerConfigReader.checkHADBInstalled();
        _logger = null;
    }
}

