/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.AbstractPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.PipePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.PipeEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeWrapper
extends AbstractPipeWrapper
implements PipeMsgListener,
PipeEventListener,
OutgoingMessageEventListener,
PipePoolElement {
    private static final String SenderMessage = "pipe_tutorial";
    private static final String MESSAGE_MODE = "message_mode";
    private static final String BULK_MESSAGE_MODE = "bulk_message_mode";
    private static final String MESSAGE_ID = "message_id";
    static final String MESSAGE_ACK_REQUIRED = "message_ack_required";
    static final String MESSAGE_ACK_LIST_PROPERTY = "message_ack_list_property";
    public static final String MESSAGE_SEND_START_TIME = "message_send_start_time";
    public static final String BULK_MESSAGE_ID = "bulk_message_id";
    private static final String ID = "id";
    private static final int PIPE_QUEUE_CAPACITY = 20;
    private static final Level TRACE_LEVEL = Level.FINE;
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private Boolean _waitForFastAckConfigured = null;
    Boolean _replicationMeasurementEnabled = null;
    int _replicationMeasurementInterval = -1;
    private JxtaBiDiPipe _pipe = null;
    private String _name = null;
    private boolean _pipeClosed = false;
    private final AtomicInteger _locallyQueuedMessages = new AtomicInteger(0);

    public PipeWrapper(String name, String senderOrReceiver, String partnerInstanceName, JxtaBiDiPipe pipe) {
        this._name = name;
        this._senderOrReceiver = senderOrReceiver;
        this._partnerInstanceName = partnerInstanceName;
        this._pipe = pipe;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("PipeWrapper>>pipeMsgEvent");
        }
        Message msg = null;
        try {
            msg = event.getMessage();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("PipeWrapper>>pipeMsgEvent:msg=" + msg);
            }
            if (msg == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Received an empty message, returning");
                }
                return;
            }
            MessageElement msgElement = msg.getMessageElement(SenderMessage, SenderMessage);
            MessageElement idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID);
            MessageElement bulkMsgElement = msg.getMessageElement(BULK_MESSAGE_MODE, BULK_MESSAGE_MODE);
            if (msgElement != null) {
                // empty if block
            }
            if (idMsgElement != null) {
                // empty if block
            }
            if (bulkMsgElement != null) {
                // empty if block
            }
            if (msgElement != null) {
                this.processStartupMessage(msg, msgElement);
            } else if (bulkMsgElement != null) {
                this.processBulkMessage(msg, bulkMsgElement);
            } else if (idMsgElement != null) {
                this.processIdMessage(msg, idMsgElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void processStartupMessage(Message msg, MessageElement msgElement) {
        if (msgElement.toString() == null) {
            System.out.println("null msg received");
        } else {
            System.out.println("Message  :" + msgElement.toString());
            if (!msgElement.toString().startsWith("RETURN_MSG_COMMAND")) {
                Message returnMsg = new Message();
                String returnData = "ReturnMessage  :" + msgElement.toString();
                returnMsg.addMessageElement(SenderMessage, (MessageElement)new StringMessageElement(SenderMessage, returnData, null));
                System.out.println("SendingResponse :" + returnData);
            }
        }
    }

    private void checkSendImmediateAck(Message msg) {
        block5: {
            if (this.isWaitForFastAckConfigured() && !ReplicationState.isHCMessage(msg)) {
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("<<checkSendImmediateAck:isVoidReturnMessage=" + ReplicationState.isVoidMethodReturnMessage(msg));
                _logger.fine("<<checkSendImmediateAck:isAckRequiredForMessage=" + ReplicationState.isAckRequiredForMessage(msg));
            }
            if (ReplicationState.isVoidMethodReturnMessage(msg) && ReplicationState.isAckRequiredForMessage(msg)) {
                Message ackMsg = ReplicationState.createAckMessageFrom(msg);
                JxtaBiDiPipe thePipe = this.getPipe();
                try {
                    thePipe.sendMessage(ackMsg);
                }
                catch (IOException ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block5;
                    _logger.fine("PipeWrapper:IOException sending ack message");
                    ex.printStackTrace();
                }
            }
        }
    }

    private void checkSendImmediateBulkAck(Message msg, List<ReplicationState> states) {
        block4: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("<<checkSendImmediateBulkAck:isVoidReturnMessage=" + ReplicationState.isVoidMethodReturnMessage(msg));
                _logger.fine("<<checkSendImmediateBulkAck:isAckRequiredForMessage=" + ReplicationState.isAckRequiredForMessage(msg));
            }
            if (ReplicationState.isVoidMethodReturnMessage(msg) && ReplicationState.isAckRequiredForMessage(msg)) {
                Message ackMsg = ReplicationState.createBulkAckMessageFrom(msg, states);
                JxtaBiDiPipe thePipe = this.getPipe();
                try {
                    thePipe.sendMessage(ackMsg);
                }
                catch (IOException ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block4;
                    _logger.fine("PipeWrapper:IOException sending ack message");
                    ex.printStackTrace();
                }
            }
        }
    }

    private void processBulkMessage(Message msg, MessageElement idMsgElement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ">>PipeWrapper:  processBulkMessage...");
        }
        this.printMessageReceiptStats(msg);
        ReplicationMessageRouter receiver = ReplicationMessageRouter.createInstance();
        if (!ReplicationState.isAckRequiredForMessage(msg) && !ReplicationState.isVoidMethodReturnMessage(msg) && ReplicationState.isResponseMessage(msg)) {
            List<String> ackIds = ReplicationState.extractAckIdsListFromMessage(msg);
            this.processAcks(ackIds, receiver);
            return;
        }
        List<ReplicationState> states = ReplicationState.extractBulkReplicationStatesFromMessage(msg);
        if (!this.isWaitForFastAckConfigured()) {
            this.checkSendImmediateBulkAck(msg, states);
        }
        for (ReplicationState state : states) {
            if (_logger.isLoggable(TRACE_LEVEL)) {
                _logger.log(TRACE_LEVEL, "<<PipeWrapper:  receiving id: " + state.getId() + "[ver:" + state.getVersion() + "]");
            }
            receiver.processMessage(state);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "<<PipeWrapper:  processBulkMessage complete...");
        }
    }

    private void processAcks(List<String> acksList, ReplicationMessageRouter receiver) {
        for (int i = 0; i < acksList.size(); ++i) {
            ReplicationState nextState = new ReplicationState(acksList.get(i));
            receiver.processResponse(nextState);
        }
    }

    private void processIdMessage(Message msg, MessageElement idMsgElement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("PipeWrapper>>processIdMessage");
        }
        this.printIdMessageReceiptStats(msg);
        if (idMsgElement.toString() == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("PipeWrapper>>processIdMessage:null id msg received");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("PipeWrapper:ID Message id:" + idMsgElement.toString());
        }
        this.checkSendImmediateAck(msg);
        ReplicationState state = this.createReplicationState(msg);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("PipeWrapper>>processIdMessage:incomingState=" + state);
        }
        ReplicationMessageRouter receiver = ReplicationMessageRouter.createInstance();
        receiver.processMessage(state);
    }

    public boolean isWaitForFastAckConfigured() {
        if (this._waitForFastAckConfigured == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            boolean waitForFastAckProp = lookup.getWaitForFastAckPropertyFromConfig();
            this._waitForFastAckConfigured = new Boolean(waitForFastAckProp);
        }
        return this._waitForFastAckConfigured;
    }

    private ReplicationState createReplicationState(Message msg) {
        return ReplicationState.createReplicationState(msg);
    }

    @Override
    public void cleanup() {
        this.cleanup(true);
    }

    public synchronized void cleanup(boolean doClose) {
        block6: {
            if (this.isPipeClosed()) {
                return;
            }
            this._pipe.setPipeEventListener(null);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("PipeWrapper>>cleanup called");
            }
            if (doClose) {
                try {
                    this._pipe.close();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("PipeWrapper>>_pipe.close() called");
                    }
                }
                catch (IOException ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block6;
                    _logger.fine("PipeWrapper:exception closing pipe during cleanup");
                    ex.printStackTrace();
                }
            }
        }
        this.setPipeClosed(true);
        this._pipe = null;
        this._name = null;
    }

    public void pipeEvent(int event) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("PipeWrapper:in pipeEvent: event=" + event);
        }
        if (event == 1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("handling pipe event pipe closed:is this end closed:" + this.isPipeClosed());
                _logger.fine("handling pipe event pipe closed:pipeWrapper:" + this);
            }
            if (!this.isPipeClosed()) {
                this.cleanup();
            }
            if (!ReplicationHealthChecker.isStopping()) {
                String partnerInstanceName = this.getPartnerInstanceName();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("PipeWrapper close event causing pipes reInit:partnerInstance: " + partnerInstanceName);
                }
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "PipeWrapper close event causing pipes reInit:partnerInstance: " + partnerInstanceName);
                }
                JxtaReplicationReceiver jxtaReplicationReceiver = (JxtaReplicationReceiver)ReplicationHealthChecker.getReplicationReceiver();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("PipeWrapper:about to call reInit: jxtaReplicationReceiver: " + jxtaReplicationReceiver + "_senderOrReceiver=" + this._senderOrReceiver);
                }
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "PipeWrapper:about to call reInit: jxtaReplicationReceiver: " + jxtaReplicationReceiver + "_senderOrReceiver=" + this._senderOrReceiver);
                }
                jxtaReplicationReceiver.reInit(this.getSenderOrReceiver(), partnerInstanceName);
            }
        }
    }

    JxtaBiDiPipe getPipe() {
        return this._pipe;
    }

    public synchronized boolean isPipeClosed() {
        return this._pipeClosed;
    }

    private synchronized void setPipeClosed(boolean value) {
        this._pipeClosed = value;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(super.toString());
        sb.append("isPipeClosed=" + this.isPipeClosed() + "\n");
        sb.append("_pipe=" + this._pipe + "\n");
        return sb.toString();
    }

    public void messageSendSucceeded(Message sentMessage) {
        this.decrementQueuedMessageCount();
        String ackRequiredString = (String)sentMessage.getMessageProperty((Object)MESSAGE_ACK_REQUIRED);
        this.printFastAckStats(sentMessage, true);
        if (ackRequiredString.equalsIgnoreCase("Y")) {
            MessageElement bulkMsgElement = sentMessage.getMessageElement(BULK_MESSAGE_MODE, BULK_MESSAGE_MODE);
            if (bulkMsgElement != null) {
                this.doFastBulkAcksFor(sentMessage, bulkMsgElement);
            } else {
                MessageElement idMsgElement = sentMessage.getMessageElement(MESSAGE_ID, MESSAGE_ID);
                if (idMsgElement != null) {
                    this.doFastAckFor(sentMessage, idMsgElement);
                }
            }
        }
    }

    public void messageSendFailed(Message sentMessage) {
        this.printFastAckStats(sentMessage, false);
        this.decrementQueuedMessageCount();
    }

    public void messageSendFailed(OutgoingMessageEvent event) {
        Message sentMessage = (Message)event.getSource();
        this.printFastAckStats(sentMessage, false);
        this.decrementQueuedMessageCount();
    }

    public void messageSendSucceeded(OutgoingMessageEvent event) {
        this.decrementQueuedMessageCount();
        Message sentMessage = (Message)event.getSource();
        String ackRequiredString = (String)sentMessage.getMessageProperty((Object)MESSAGE_ACK_REQUIRED);
        this.printFastAckStats(sentMessage, true);
        if (ackRequiredString.equalsIgnoreCase("Y")) {
            MessageElement bulkMsgElement = sentMessage.getMessageElement(BULK_MESSAGE_MODE, BULK_MESSAGE_MODE);
            if (bulkMsgElement != null) {
                this.doFastBulkAcksFor(sentMessage, bulkMsgElement);
            } else {
                MessageElement idMsgElement = sentMessage.getMessageElement(MESSAGE_ID, MESSAGE_ID);
                if (idMsgElement != null) {
                    this.doFastAckFor(sentMessage, idMsgElement);
                }
            }
        }
    }

    private void doFastBulkAcksFor(Message sentMessage, MessageElement bulkMsgElement) {
        if (ReplicationState.isHCMessage(sentMessage)) {
            if (_logger.isLoggable(TRACE_LEVEL)) {
                _logger.log(TRACE_LEVEL, "HC message do not do fast ack for this...");
            }
            return;
        }
        this.processResponse(sentMessage);
        ReplicationMessageRouter receiver = ReplicationMessageRouter.createInstance();
        List ackIdsList = (List)sentMessage.getMessageProperty((Object)MESSAGE_ACK_LIST_PROPERTY);
        this.processAcks(ackIdsList, receiver);
    }

    private void doFastAckFor(Message sentMessage, MessageElement bulkMsgElement) {
        if (ReplicationState.isHCMessage(sentMessage)) {
            if (_logger.isLoggable(TRACE_LEVEL)) {
                _logger.log(TRACE_LEVEL, "HC message do not do fast ack for this...");
            }
            return;
        }
        this.processResponse(sentMessage);
    }

    private void printFastAckStats(Message sentMessage, boolean succeeded) {
        if (!this.getReplicationMeasurementEnabled()) {
            return;
        }
        boolean useLong = true;
        int measurementInterval = this.getReplicationMeasurementInterval();
        long id = -1L;
        String stringId = "";
        MessageElement idMsgElement = sentMessage.getMessageElement(MESSAGE_ID, MESSAGE_ID);
        if (idMsgElement != null) {
            try {
                id = Long.decode(idMsgElement.toString());
            }
            catch (NumberFormatException ex) {
                useLong = false;
                stringId = idMsgElement.toString();
            }
        }
        if (useLong) {
            stringId = "" + id;
        }
        if (useLong && (id == -1L || id % (long)measurementInterval != 0L)) {
            return;
        }
        String sendStartTimeString = (String)sentMessage.getMessageProperty((Object)MESSAGE_SEND_START_TIME);
        long sendStartTime = Long.decode(sendStartTimeString);
        String prefix = "messageSendSucceeded: id = ";
        if (!succeeded) {
            prefix = "messageSendFailed: id = ";
        }
        _logger.log(Level.INFO, prefix + stringId + " fastAckTime = " + (System.currentTimeMillis() - sendStartTime) + " to partner: " + this.getPartnerInstanceName());
    }

    private void printMessageReceiptStats(Message receivedMessage) {
        if (!this.getReplicationMeasurementEnabled()) {
            return;
        }
        int measurementInterval = this.getReplicationMeasurementInterval();
        long id = -1L;
        MessageElement idMsgElement = receivedMessage.getMessageElement(MESSAGE_ID, MESSAGE_ID);
        if (idMsgElement != null) {
            id = Long.decode(idMsgElement.toString());
        }
        if (id % (long)measurementInterval != 0L) {
            return;
        }
        long sendStartTime = -1L;
        MessageElement sendStartMsgElement = receivedMessage.getMessageElement(MESSAGE_SEND_START_TIME, MESSAGE_SEND_START_TIME);
        if (sendStartMsgElement == null || (sendStartTime = Long.decode(sendStartMsgElement.toString()).longValue()) > 0L) {
            // empty if block
        }
        _logger.log(Level.INFO, "messageReceiptSucceeded: bulkId = " + id + " receiptTime = " + (System.currentTimeMillis() - sendStartTime) + " from partner: " + this.getPartnerInstanceName());
    }

    private void printIdMessageReceiptStats(Message receivedMessage) {
        if (!this.getReplicationMeasurementEnabled()) {
            return;
        }
        String id = "";
        MessageElement idMsgElement = receivedMessage.getMessageElement(MESSAGE_ID, MESSAGE_ID);
        if (idMsgElement != null) {
            id = idMsgElement.toString();
        }
        long sendStartTime = -1L;
        MessageElement sendStartMsgElement = receivedMessage.getMessageElement(MESSAGE_SEND_START_TIME, MESSAGE_SEND_START_TIME);
        if (sendStartMsgElement == null || (sendStartTime = Long.decode(sendStartMsgElement.toString()).longValue()) > 0L) {
            // empty if block
        }
        _logger.log(Level.INFO, "messageReceiptSucceeded: id = " + id + " receiptTime = " + (System.currentTimeMillis() - sendStartTime));
    }

    private boolean getReplicationMeasurementEnabled() {
        if (this._replicationMeasurementEnabled == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this._replicationMeasurementEnabled = new Boolean(lookup.getReplicationMeasurementEnabledFromConfig());
        }
        return this._replicationMeasurementEnabled;
    }

    private int getReplicationMeasurementInterval() {
        if (this._replicationMeasurementInterval == -1) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this._replicationMeasurementInterval = lookup.getReplicationMeasurementIntervalFromConfig();
        }
        return this._replicationMeasurementInterval;
    }

    public void processResponse(Message sentMessage) {
        ReplicationState sentState = this.createReplicationState(sentMessage);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + this.getClass().getName() + ">>processResponse");
        }
        ReplicationResponseRepository.putEntry(sentState);
    }

    public boolean isPipeOverStressed() {
        return this._locallyQueuedMessages.get() > 18;
    }

    int incrementQueuedMessageCount() {
        return this._locallyQueuedMessages.incrementAndGet();
    }

    int decrementQueuedMessageCount() {
        return this._locallyQueuedMessages.decrementAndGet();
    }
}

