/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.admin.monitor.stats.AverageRangeStatistic;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableAverageRangeStatisticImpl;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

public class WebModuleStatistics {
    public static final long DEFAULT_MAX_BOUND = Long.MAX_VALUE;
    public static final String SESSION_SIZE = "SessionSize";
    public static final String SESSION_PERSIST_TIME = "SessionPersistTime";
    public static final String CONTAINER_LATENCY = "ContainerLatency";
    long _valveSaveLow = 0L;
    long _valveSaveHigh = 0L;
    long _valveSaveAverage = 0L;
    long _totalValveSaves = 0L;
    long _totalValveSaveTime = 0L;
    long _backgroundSaveLow = 0L;
    long _backgroundSaveHigh = 0L;
    long _backgroundSaveAverage = 0L;
    long _totalBackgroundSaves = 0L;
    long _totalBackgroundSaveTime = 0L;
    long _pipelineLow = 0L;
    long _pipelineHigh = 0L;
    long _pipelineAverage = 0L;
    long _totalPipelines = 0L;
    long _totalPipelineTime = 0L;
    long _sessionSizeLow = 0L;
    long _sessionSizeHigh = 0L;
    long _sessionSizeAverage = 0L;
    long _totalStoredSessions = 0L;
    long _totalSessionSize = 0L;
    long _cacheHits = 0L;
    long _cacheMisses = 0L;
    long _executeStatementLow = 0L;
    long _executeStatementHigh = 0L;
    long _executeStatementAverage = 0L;
    long _totalExecuteStatements = 0L;
    long _totalExecuteStatementTime = 0L;
    long _commitLow = 0L;
    long _commitHigh = 0L;
    long _commitAverage = 0L;
    long _totalCommits = 0L;
    long _totalCommitTime = 0L;
    long _getConnectionLow = 0L;
    long _getConnectionHigh = 0L;
    long _getConnectionAverage = 0L;
    long _totalGetConnections = 0L;
    long _totalGetConnectionTime = 0L;
    long _putConnectionLow = 0L;
    long _putConnectionHigh = 0L;
    long _putConnectionAverage = 0L;
    long _totalPutConnections = 0L;
    long _totalPutConnectionTime = 0L;
    long _statementPrepLow = 0L;
    long _statementPrepHigh = 0L;
    long _statementPrepAverage = 0L;
    long _totalStatementPreps = 0L;
    long _totalStatementPrepTime = 0L;
    MutableAverageRangeStatisticImpl sessionSizeStat = WebModuleStatistics.createDefaultStat("SessionSize", "byte", "Low/High/Average Session");
    MutableAverageRangeStatisticImpl pipelineStat = null;
    MutableAverageRangeStatisticImpl valveSaveStat = WebModuleStatistics.createDefaultStat("SessionPersistTime", "millisecond", "Low/High/Average Session Persist Time");

    public WebModuleStatistics() {
        this.pipelineStat = WebModuleStatistics.createDefaultStat(CONTAINER_LATENCY, "millisecond", "Low/High/Average Container Latency");
    }

    public static MutableAverageRangeStatisticImpl createDefaultStat(String name, String unit, String description) {
        return new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, Long.MAX_VALUE, 0L, 0L, name, unit, description, System.currentTimeMillis(), System.currentTimeMillis()));
    }

    synchronized void resetStats() {
        this.resetValveSaveStats();
        this.resetBackgroundSaveStats();
        this.resetPipelineStats();
        this.resetSessionSizeStats();
        this.resetCacheStats();
        this.resetExecuteStatementStats();
        this.resetCommitStats();
        this.resetGetConnectionStats();
        this.resetPutConnectionStats();
        this.resetStatementPrepStats();
        this.resetAverageStats();
    }

    void resetAverageStats() {
        this.sessionSizeStat.reset();
        this.pipelineStat.reset();
        this.valveSaveStat.reset();
    }

    synchronized void processValveSave(long elapsedTime) {
        ++this._totalValveSaves;
        this._totalValveSaveTime += elapsedTime;
        this._valveSaveAverage = this._totalValveSaveTime / this._totalValveSaves;
        if (this._valveSaveLow == 0L | elapsedTime < this._valveSaveLow) {
            this._valveSaveLow = elapsedTime;
        }
        if (elapsedTime > this._valveSaveHigh) {
            this._valveSaveHigh = elapsedTime;
        }
        this.valveSaveStat.setCount(elapsedTime);
    }

    void resetValveSaveStats() {
        this._totalValveSaves = 0L;
        this._totalValveSaveTime = 0L;
        this._valveSaveAverage = 0L;
        this._valveSaveLow = 0L;
        this._valveSaveHigh = 0L;
    }

    public long getValveSaveLow() {
        return this._valveSaveLow;
    }

    public long getValveSaveHigh() {
        return this._valveSaveHigh;
    }

    public long getValveSaveAverage() {
        return this._valveSaveAverage;
    }

    synchronized void processBackgroundSave(long elapsedTime) {
        ++this._totalBackgroundSaves;
        this._totalBackgroundSaveTime += elapsedTime;
        this._backgroundSaveAverage = this._totalBackgroundSaveTime / this._totalBackgroundSaves;
        if (this._backgroundSaveLow == 0L | elapsedTime < this._backgroundSaveLow) {
            this._backgroundSaveLow = elapsedTime;
        }
        if (elapsedTime > this._backgroundSaveHigh) {
            this._backgroundSaveHigh = elapsedTime;
        }
    }

    void resetBackgroundSaveStats() {
        this._totalBackgroundSaves = 0L;
        this._totalBackgroundSaveTime = 0L;
        this._backgroundSaveAverage = 0L;
        this._backgroundSaveLow = 0L;
        this._backgroundSaveHigh = 0L;
    }

    long getBackgroundSaveLow() {
        return this._backgroundSaveLow;
    }

    long getBackgroundSaveHigh() {
        return this._backgroundSaveHigh;
    }

    long getBackgroundSaveAverage() {
        return this._backgroundSaveAverage;
    }

    public synchronized void processPipeline(long elapsedTime) {
        ++this._totalPipelines;
        this._totalPipelineTime += elapsedTime;
        this._pipelineAverage = this._totalPipelineTime / this._totalPipelines;
        if (this._pipelineLow == 0L | elapsedTime < this._pipelineLow) {
            this._pipelineLow = elapsedTime;
        }
        if (elapsedTime > this._pipelineHigh) {
            this._pipelineHigh = elapsedTime;
        }
        this.pipelineStat.setCount(elapsedTime);
    }

    void resetPipelineStats() {
        this._totalPipelines = 0L;
        this._totalPipelineTime = 0L;
        this._pipelineAverage = 0L;
        this._pipelineLow = 0L;
        this._pipelineHigh = 0L;
    }

    public long getPipelineLow() {
        return this._pipelineLow;
    }

    public long getPipelineHigh() {
        return this._pipelineHigh;
    }

    public long getPipelineAverage() {
        return this._pipelineAverage;
    }

    synchronized void processSessionSize(long sessionSize) {
        ++this._totalStoredSessions;
        this._totalSessionSize += sessionSize;
        this._sessionSizeAverage = this._totalSessionSize / this._totalStoredSessions;
        if (this._sessionSizeLow == 0L | sessionSize < this._sessionSizeLow) {
            this._sessionSizeLow = sessionSize;
        }
        if (sessionSize > this._sessionSizeHigh) {
            this._sessionSizeHigh = sessionSize;
        }
        this.sessionSizeStat.setCount(sessionSize);
    }

    void resetSessionSizeStats() {
        this._totalStoredSessions = 0L;
        this._totalSessionSize = 0L;
        this._sessionSizeAverage = 0L;
        this._sessionSizeLow = 0L;
        this._sessionSizeHigh = 0L;
    }

    public long getSessionSizeLow() {
        return this._sessionSizeLow;
    }

    public long getSessionSizeHigh() {
        return this._sessionSizeHigh;
    }

    public long getSessionSizeAverage() {
        return this._sessionSizeAverage;
    }

    public synchronized void processCacheHit(boolean cacheWasHit) {
        if (cacheWasHit) {
            ++this._cacheHits;
        }
    }

    void resetCacheStats() {
        this._cacheHits = 0L;
        this._cacheMisses = 0L;
    }

    long getCacheHits() {
        return this._cacheHits;
    }

    long getCacheMisses() {
        return this._cacheMisses;
    }

    synchronized void processExecuteStatement(long elapsedTime) {
        ++this._totalExecuteStatements;
        this._totalExecuteStatementTime += elapsedTime;
        this._executeStatementAverage = this._totalExecuteStatementTime / this._totalExecuteStatements;
        if (this._executeStatementLow == 0L | elapsedTime < this._executeStatementLow) {
            this._executeStatementLow = elapsedTime;
        }
        if (elapsedTime > this._executeStatementHigh) {
            this._executeStatementHigh = elapsedTime;
        }
    }

    void resetExecuteStatementStats() {
        this._totalExecuteStatements = 0L;
        this._totalExecuteStatementTime = 0L;
        this._executeStatementLow = 0L;
        this._executeStatementHigh = 0L;
        this._executeStatementAverage = 0L;
    }

    long getExecuteStatementLow() {
        return this._executeStatementLow;
    }

    long getExecuteStatementHigh() {
        return this._executeStatementHigh;
    }

    long getExecuteStatementAverage() {
        return this._executeStatementAverage;
    }

    synchronized void processCommit(long elapsedTime) {
        ++this._totalCommits;
        this._totalCommitTime += elapsedTime;
        this._commitAverage = this._totalCommitTime / this._totalCommits;
        if (this._commitLow == 0L | elapsedTime < this._commitLow) {
            this._commitLow = elapsedTime;
        }
        if (elapsedTime > this._commitHigh) {
            this._commitHigh = elapsedTime;
        }
    }

    void resetCommitStats() {
        this._totalCommits = 0L;
        this._totalCommitTime = 0L;
        this._commitLow = 0L;
        this._commitHigh = 0L;
        this._commitAverage = 0L;
    }

    long getCommitLow() {
        return this._commitLow;
    }

    long getCommitHigh() {
        return this._commitHigh;
    }

    long getCommitAverage() {
        return this._commitAverage;
    }

    synchronized void processGetConnectionFromPool(long elapsedTime) {
        ++this._totalGetConnections;
        this._totalGetConnectionTime += elapsedTime;
        this._getConnectionAverage = this._totalGetConnectionTime / this._totalGetConnections;
        if (this._getConnectionLow == 0L | elapsedTime < this._getConnectionLow) {
            this._getConnectionLow = elapsedTime;
        }
        if (elapsedTime > this._getConnectionHigh) {
            this._getConnectionHigh = elapsedTime;
        }
    }

    void resetGetConnectionStats() {
        this._totalGetConnections = 0L;
        this._totalGetConnectionTime = 0L;
        this._getConnectionLow = 0L;
        this._getConnectionHigh = 0L;
        this._getConnectionAverage = 0L;
    }

    long getGetConnectionLow() {
        return this._getConnectionLow;
    }

    long getGetConnectionHigh() {
        return this._getConnectionHigh;
    }

    long getGetConnectionAverage() {
        return this._getConnectionAverage;
    }

    synchronized void processPutConnectionIntoPool(long elapsedTime) {
        ++this._totalPutConnections;
        this._totalPutConnectionTime += elapsedTime;
        this._putConnectionAverage = this._totalPutConnectionTime / this._totalPutConnections;
        if (this._putConnectionLow == 0L | elapsedTime < this._putConnectionLow) {
            this._putConnectionLow = elapsedTime;
        }
        if (elapsedTime > this._putConnectionHigh) {
            this._putConnectionHigh = elapsedTime;
        }
    }

    void resetPutConnectionStats() {
        this._totalPutConnections = 0L;
        this._totalPutConnectionTime = 0L;
        this._putConnectionLow = 0L;
        this._putConnectionHigh = 0L;
        this._putConnectionAverage = 0L;
    }

    long getPutConnectionLow() {
        return this._putConnectionLow;
    }

    long getPutConnectionHigh() {
        return this._putConnectionHigh;
    }

    long getPutConnectionAverage() {
        return this._putConnectionAverage;
    }

    synchronized void processStatementPrepBlock(long elapsedTime) {
        ++this._totalStatementPreps;
        this._totalStatementPrepTime += elapsedTime;
        this._statementPrepAverage = this._totalStatementPrepTime / this._totalStatementPreps;
        if (this._statementPrepLow == 0L | elapsedTime < this._statementPrepLow) {
            this._statementPrepLow = elapsedTime;
        }
        if (elapsedTime > this._statementPrepHigh) {
            this._statementPrepHigh = elapsedTime;
        }
    }

    void resetStatementPrepStats() {
        this._totalStatementPreps = 0L;
        this._totalStatementPrepTime = 0L;
        this._statementPrepLow = 0L;
        this._statementPrepHigh = 0L;
        this._statementPrepAverage = 0L;
    }

    long getStatementPrepLow() {
        return this._statementPrepLow;
    }

    long getStatementPrepHigh() {
        return this._statementPrepHigh;
    }

    long getStatementPrepAverage() {
        return this._statementPrepAverage;
    }

    public AverageRangeStatistic getSessionSizeStat() {
        return this.sessionSizeStat;
    }

    public AverageRangeStatistic getPipelineStat() {
        return this.pipelineStat;
    }

    public AverageRangeStatistic getValveSaveStat() {
        return this.valveSaveStat;
    }
}

