/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.NamedObject;
import com.sun.jdmk.Repository;
import com.sun.jdmk.RepositorySupport;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import com.sun.jdmk.internal.ClassLogger;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class DefaultMBeanInterceptor
implements MBeanServerInterceptor {
    private static final ObjectName _MBSDelegateObjectName;
    private transient MBeanInstantiator instantiator = null;
    private transient MBeanServer server = null;
    private transient MetaData meta = null;
    private transient Repository repository = null;
    private transient WeakHashMap listenerWrappers = new WeakHashMap();
    private String domain = null;
    private boolean queryByRepo;
    private static final String dbgTag = "DefaultMBeanInterceptor";
    private static final ClassLogger logger;

    public DefaultMBeanInterceptor(MBeanServer server) {
        this.initialize(server, ((MBeanServerInt)((Object)server)).getMetaData(), ((MBeanServerInt)((Object)server)).getMBeanInstantiator(), null, null);
    }

    public DefaultMBeanInterceptor(MBeanServer server, String domain) {
        this.initialize(server, ((MBeanServerInt)((Object)server)).getMetaData(), ((MBeanServerInt)((Object)server)).getMBeanInstantiator(), domain, null);
    }

    public DefaultMBeanInterceptor(MBeanServer server, String domain, Repository repository) {
        this.initialize(server, ((MBeanServerInt)((Object)server)).getMetaData(), ((MBeanServerInt)((Object)server)).getMBeanInstantiator(), domain, repository);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, name, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectName logicalName = name;
        if (className == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean creation");
        }
        if (name != null && name.isPattern()) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Invalid name->" + name.toString());
            throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean creation");
        }
        String nameMessage = "null";
        if (name != null) {
            nameMessage = name.toString();
        }
        if (logger.finerOn()) {
            logger.finer("createMBean", "ClassName = " + className + ",ObjectName = " + nameMessage);
        }
        Class theClass = this.instantiator.findClassWithDefaultLoaderRepository(className);
        this.instantiator.testCreation(theClass);
        this.meta.testCompliance(theClass);
        Object moi = this.instantiator.instantiate(theClass, params, signature, this.getClass().getClassLoader());
        ObjectName actualName = this.registerCreatedObject(moi, name);
        return this.makeObjectInstance(className, moi, actualName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Class theClass;
        String nameMessage;
        if (className == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean creation");
        }
        if (name != null && name.isPattern()) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Invalid name->" + name.toString());
            throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean registration");
        }
        if (loaderName == null) {
            nameMessage = "null";
            if (name != null) {
                nameMessage = name.toString();
            }
            if (logger.finerOn()) {
                logger.finer("createMBean", "ClassName = " + className + ",ObjectName = " + nameMessage + " Loader name = null");
            }
            theClass = this.instantiator.findClass(className, this.getClass().getClassLoader());
        } else {
            nameMessage = "null";
            if (name != null) {
                nameMessage = name.toString();
            }
            if (logger.finerOn()) {
                logger.finer("createMBean", "ClassName = " + className + ",ObjectName = " + nameMessage + ",Loader name = " + loaderName.toString());
            }
            theClass = this.instantiator.findClass(className, loaderName);
        }
        this.instantiator.testCreation(theClass);
        this.meta.testCompliance(theClass);
        Object moi = this.instantiator.instantiate(theClass, params, signature, this.getClass().getClassLoader());
        ObjectName actualName = this.registerCreatedObject(moi, name);
        return this.makeObjectInstance(className, moi, actualName);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName logicalName = name;
        Class<?> theClass = object.getClass();
        String className = theClass.getName();
        this.meta.testCompliance(theClass);
        ObjectName actualName = this.registerObject(object, name);
        return this.makeObjectInstance(className, object, actualName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (name == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occurred trying to unregister the MBean");
        }
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            ModifiableClassLoaderRepository clr;
            Object object = this.repository.retrieve(name);
            if (object == null) {
                if (logger.finerOn()) {
                    logger.finer("unregisterMBean", name + ": Found no object");
                }
                throw new InstanceNotFoundException(name.toString());
            }
            if (object instanceof MBeanRegistration) {
                this.meta.preDeregisterInvoker(object);
            }
            this.repository.remove(name);
            if (logger.finerOn()) {
                logger.finer("unregisterMBean", "Send delete notification of object " + name.getCanonicalName());
            }
            this.sendNotification("JMX.mbean.unregistered", name);
            if (object instanceof MBeanRegistration) {
                this.meta.postDeregisterInvoker(object);
            }
            if (object instanceof ClassLoader && (clr = this.instantiator.getClassLoaderRepository()) != null) {
                clr.removeClassLoader(name);
            }
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        String className;
        Object obj = this.getMBean(name);
        try {
            className = this.meta.getMBeanClassName(obj);
        }
        catch (IntrospectionException x) {
            logger.finest("getObjectInstance", x);
            throw new JMRuntimeException("Can't obtain class name for " + name + ": " + x);
        }
        catch (NotCompliantMBeanException x) {
            logger.finest("getObjectInstance", x);
            throw new JMRuntimeException("Can't obtain class name for " + name + ": " + x);
        }
        return new ObjectInstance(name, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryMBeans(ObjectName name, QueryExp query) {
        Set list;
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            list = this.repository.query(name, query);
        }
        if (this.queryByRepo) {
            return list;
        }
        return this.filterListOfObjects(list, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        Set nos = this.queryMBeans(name, query);
        Iterator i = nos.iterator();
        while (i.hasNext()) {
            ObjectInstance oi = (ObjectInstance)i.next();
            result.add(oi.getObjectName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        Set names;
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            names = this.repository.query(null, null);
        }
        HashSet<String> tmpSet = new HashSet<String>(1);
        Iterator i = names.iterator();
        while (i.hasNext()) {
            ObjectInstance oi = (ObjectInstance)i.next();
            ObjectName x = oi.getObjectName();
            String domain = x.getDomain();
            if (tmpSet.contains(domain)) continue;
            tmpSet.add(domain);
        }
        String[] result = new String[tmpSet.size()];
        return tmpSet.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            return this.repository.contains(name);
        }
    }

    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (logger.finerOn()) {
            logger.finer("getAttribute", "Attribute= " + attribute + ", obj= " + name);
        }
        Object instance = this.getMBean(name);
        return this.meta.getAttribute(instance, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (attributes.length == 0) {
            return new AttributeList(0);
        }
        if (logger.finerOn()) {
            logger.finer("getAttributes", "Object= " + name);
        }
        Object obj = this.getMBean(name);
        return this.meta.getAttributes(obj, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (logger.finerOn()) {
            logger.finer("setAttribute", "Object= " + name + ", attribute=" + attribute.getName());
        }
        Object instance = this.getMBean(name);
        Object o = this.meta.setAttribute(instance, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attributes.isEmpty()) {
            return attributes;
        }
        Object obj = this.getMBean(name);
        return this.meta.setAttributes(obj, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object obj = this.getMBean(name);
        return this.meta.invoke(obj, operationName, params, signature);
    }

    protected MetaData meta() {
        return this.meta;
    }

    protected ObjectInstance makeObjectInstance(String className, Object object, ObjectName name) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            try {
                className = this.meta.getMBeanClassName(object);
            }
            catch (IntrospectionException x) {
                logger.finest("makeObjectInstance", x);
                throw new NotCompliantMBeanException("Can't obtain class name for " + name + ": " + x);
            }
            catch (JMRuntimeException x) {
                logger.finest("makeObjectInstance", x);
                throw new NotCompliantMBeanException("Can't obtain class name for " + name + ": " + x);
            }
        }
        if (className == null) {
            throw new NotCompliantMBeanException("The class Name returned is null");
        }
        return new ObjectInstance(name, className);
    }

    protected ObjectName registerObject(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName logicalName = name;
        if (object == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(wrapped, "Exception occurred trying to register the MBean");
        }
        String nameMessage = "null";
        if (name != null) {
            nameMessage = name.toString();
        }
        if (logger.finerOn()) {
            logger.finer("registerMBean", "ObjectName = " + nameMessage);
        }
        Object res = null;
        if (object instanceof MBeanRegistration) {
            logicalName = this.meta.preRegisterInvoker(object, name, this.server);
        }
        if (logicalName == null) {
            if (object instanceof MBeanRegistration) {
                this.meta.postRegisterInvoker(object, false);
            }
            IllegalArgumentException wrapped = new IllegalArgumentException("No object name specified");
            throw new RuntimeOperationsException(wrapped, "Exception occurred trying to register the MBean");
        }
        this.internal_addObject(object, logicalName);
        if (object instanceof MBeanRegistration) {
            this.meta.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            ModifiableClassLoaderRepository clr = this.instantiator.getClassLoaderRepository();
            if (clr == null) {
                IllegalArgumentException wrapped = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
                throw new RuntimeOperationsException(wrapped, "Exception occurred trying to register the MBean as a class loader");
            }
            clr.addClassLoader(logicalName, (ClassLoader)object);
        }
        return logicalName;
    }

    protected ObjectName registerCreatedObject(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        return this.registerObject(object, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMBean(ObjectName name) throws InstanceNotFoundException {
        block9: {
            if (name == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to get an MBean");
            }
            if (name.getDomain().equals("")) {
                try {
                    name = new ObjectName(this.domain + name.toString());
                }
                catch (MalformedObjectNameException e) {
                    if (!logger.finestOn()) break block9;
                    logger.finest("getMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        Object obj = null;
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            obj = this.repository.retrieve(name);
            if (obj == null) {
                if (logger.finerOn()) {
                    logger.finer("getMBean", name + ": Found no object");
                }
                throw new InstanceNotFoundException(name.toString());
            }
        }
        return obj;
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Object instance;
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "obj= " + name);
        }
        if (!((instance = this.getMBean(name)) instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(name.getCanonicalName()), "The MBean " + name.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)instance;
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        NotificationListener listenerWrapper = this.getListenerWrapper(listener, name, instance, true);
        broadcaster.addNotificationListener(listenerWrapper, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Object instance = this.getMBean(listener);
        if (!(instance instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(listener.getCanonicalName()), "The MBean " + listener.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "obj= " + name + " listener= " + listener);
        }
        this.addNotificationListener(name, (NotificationListener)instance, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, null, null, true);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, filter, handback, false);
    }

    private void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean removeAll) throws InstanceNotFoundException, ListenerNotFoundException {
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "obj= " + name);
        }
        Object instance = this.getMBean(name);
        NotificationBroadcaster broadcaster = null;
        NotificationEmitter emitter = null;
        if (removeAll) {
            if (!(instance instanceof NotificationBroadcaster)) {
                IllegalArgumentException exc = new IllegalArgumentException(name.getCanonicalName());
                String msg = "MBean " + name.getCanonicalName() + " does not " + "implement " + NotificationBroadcaster.class.getName();
                throw new RuntimeOperationsException(exc, msg);
            }
            broadcaster = (NotificationBroadcaster)instance;
        } else {
            if (!(instance instanceof NotificationEmitter)) {
                IllegalArgumentException exc = new IllegalArgumentException(name.getCanonicalName());
                String msg = "MBean " + name.getCanonicalName() + " does not " + "implement " + NotificationEmitter.class.getName();
                throw new RuntimeOperationsException(exc, msg);
            }
            emitter = (NotificationEmitter)instance;
        }
        NotificationListener listenerWrapper = this.getListenerWrapper(listener, name, instance, false);
        if (listenerWrapper == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        if (removeAll) {
            broadcaster.removeNotificationListener(listenerWrapper);
        } else {
            emitter.removeNotificationListener(listenerWrapper, filter, handback);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, null, null, true);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, filter, handback, false);
    }

    private void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback, boolean removeAll) throws InstanceNotFoundException, ListenerNotFoundException {
        Object instance;
        try {
            instance = this.getMBean(listener);
        }
        catch (InstanceNotFoundException e) {
            throw new ListenerNotFoundException(e.getMessage());
        }
        if (!(instance instanceof NotificationListener)) {
            IllegalArgumentException exc = new IllegalArgumentException(listener.getCanonicalName());
            String msg = "MBean " + name.getCanonicalName() + " does not " + "implement " + NotificationListener.class.getName();
            throw new RuntimeOperationsException(exc, msg);
        }
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "obj= " + name + " listener= " + listener);
        }
        this.removeNotificationListener(name, (NotificationListener)instance, filter, handback, removeAll);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object moi = this.getMBean(name);
        MBeanInfo mbi = this.meta.getMBeanInfo(moi);
        if (mbi == null) {
            throw new JMRuntimeException("MBean " + name + "has no MBeanInfo");
        }
        return mbi;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        Object obj = this.getMBean(name);
        try {
            return this.meta.isInstanceOf(obj, className);
        }
        catch (ReflectionException e) {
            logger.finest("isInstanceOf", e);
            return false;
        }
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        Object obj = this.getMBean(loaderName);
        if (obj == null) {
            throw new InstanceNotFoundException(loaderName.toString());
        }
        if (!(obj instanceof ClassLoader)) {
            throw new InstanceNotFoundException(loaderName.toString() + " is not a ClassLoader");
        }
        return (ClassLoader)obj;
    }

    public final ClassLoader getMBeanClassLoader(ObjectName name) throws InstanceNotFoundException {
        return this.getClassLoaderFor(name);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        Object instance = this.getMBean(name);
        return instance.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internal_addObject(Object object, ObjectName logicalName) throws InstanceAlreadyExistsException {
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            try {
                this.repository.addMBean(object, logicalName);
            }
            catch (InstanceAlreadyExistsException e) {
                if (object instanceof MBeanRegistration) {
                    this.meta.postRegisterInvoker(object, false);
                }
                throw e;
            }
        }
        if (logger.finerOn()) {
            logger.finer("addObject", "Send create notification of object " + logicalName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", logicalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String NotifType, ObjectName name) {
        MBeanServerNotification notif = null;
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            if (logger.finerOn()) {
                logger.finer("sendNotrification", NotifType + " " + name);
            }
            notif = new MBeanServerNotification(NotifType, (Object)_MBSDelegateObjectName, 0L, name);
        }
        MBeanServerDelegate delegate = ((MBeanServerInt)((Object)this.server)).getMBeanServerDelegate();
        delegate.sendNotification(notif);
    }

    private void initialize(MBeanServer mbs, MetaData meta, MBeanInstantiator inst, String domain, Repository repos) {
        this.server = mbs;
        this.meta = meta;
        this.instantiator = inst;
        this.repository = repos;
        if (this.repository == null) {
            this.repository = new RepositorySupport();
        }
        this.domain = domain == null || domain.equals("") ? this.repository.getDefaultDomain() : domain;
        this.repository.setDefaultDomain(this.domain);
        if (logger.finerOn()) {
            logger.finer("new", "Initializing domain " + this.domain);
        }
        try {
            this.queryByRepo = this.repository.isFiltering();
        }
        catch (Exception e) {
            this.queryByRepo = false;
        }
    }

    private Set filterListOfObjects(Set list, QueryExp query) {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (query == null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String className;
                NamedObject no;
                block10: {
                    no = (NamedObject)i.next();
                    Object obj = no.getObject();
                    className = null;
                    try {
                        className = this.meta.getMBeanClassName(obj);
                    }
                    catch (JMException x) {
                        if (!logger.finestOn()) break block10;
                        logger.finest("filterListOfObjects", "Can't obtain class name for " + no.getName() + ": " + x);
                    }
                }
                result.add(new ObjectInstance(no.getName(), className));
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String className;
                NamedObject no;
                block11: {
                    no = (NamedObject)i.next();
                    Object obj = no.getObject();
                    boolean res = false;
                    query.setMBeanServer(this.server);
                    try {
                        res = query.apply(no.getName());
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    if (!res) continue;
                    className = null;
                    try {
                        className = this.meta.getMBeanClassName(obj);
                    }
                    catch (JMException x) {
                        if (!logger.finestOn()) break block11;
                        logger.finest("filterListOfObjects", "Can't obtain class name for " + no.getName() + ": " + x);
                    }
                }
                result.add(new ObjectInstance(no.getName(), className));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationListener getListenerWrapper(NotificationListener l, ObjectName name, Object mbean, boolean create) {
        ListenerWrapper wrapper = new ListenerWrapper(l, name, mbean);
        WeakHashMap weakHashMap = this.listenerWrappers;
        synchronized (weakHashMap) {
            NotificationListener existing;
            WeakReference ref = (WeakReference)this.listenerWrappers.get(wrapper);
            if (ref != null && (existing = (NotificationListener)ref.get()) != null) {
                return existing;
            }
            if (create) {
                this.listenerWrappers.put(wrapper, new WeakReference<ListenerWrapper>(wrapper));
                return wrapper;
            }
            return null;
        }
    }

    static {
        try {
            _MBSDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        logger = new ClassLogger("com.sun.jdmk.mbeanserver", dbgTag);
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener listener;
        private ObjectName name;
        private Object mbean;

        ListenerWrapper(NotificationListener l, ObjectName name, Object mbean) {
            this.listener = l;
            this.name = name;
            this.mbean = mbean;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification != null && notification.getSource() == this.mbean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, handback);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper w = (ListenerWrapper)o;
            return w.listener == this.listener && w.mbean == this.mbean && w.name.equals(this.name);
        }

        public int hashCode() {
            return System.identityHashCode(this.listener) ^ System.identityHashCode(this.mbean);
        }
    }
}

