/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.GenericHttpNotificationReceiverHandler;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpConnectorAddress;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;

abstract class GenericHttpNotificationReceiver
extends CommunicatorServer {
    protected transient GenericHttpSocket sockListen = null;
    protected InetAddress addrLastClient = null;
    private GenericHttpConnectorClient connector = null;
    private GenericHttpConnectorAddress connAddr = null;
    ClientNotificationDispatcher dispatcher = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    abstract GenericHttpSocket createSocket();

    public GenericHttpNotificationReceiver(int connectorType, int port, GenericHttpConnectorClient connector, ClientNotificationDispatcher dispatcher) {
        super(connectorType);
        this.port = port;
        this.connector = connector;
        this.dispatcher = dispatcher;
        this.maxActiveClientCount = 10;
    }

    public void startListening() {
        this.start();
        if (!this.waitState(0, 60000L)) {
            throw new CommunicationException("Notification Server could not be started");
        }
        this.connAddr = new HttpConnectorAddress(this.connector.getHost(), this.sockListen.getLocalPort());
    }

    public void stopListening() {
        this.stop();
    }

    public GenericHttpConnectorAddress getConnectorAddress() {
        return this.connAddr;
    }

    protected void doError(Exception e) throws CommunicationException {
        if (e instanceof CommunicationException) {
            throw (CommunicationException)e;
        }
        throw new CommunicationException(e);
    }

    protected void doBind() throws InterruptedException, CommunicationException {
        try {
            this.sockListen = this.createSocket().createServerSocket(this.port);
            this.sockListen.doBind();
            this.port = this.sockListen.getLocalPort();
            this.dbgTag = this.makeDebugTag();
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", this.sockListen.toString() + " bound to " + this.sockListen.getLocalAddress() + " port " + this.sockListen.getLocalPort());
            }
        }
        catch (SocketException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", "EXCEPTION MSG = '" + e.getMessage() + "'");
            }
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    protected void doReceive() throws InterruptedException, CommunicationException {
        try {
            this.sockListen.doReceive();
            this.addrLastClient = this.sockListen.getRemoteAddress();
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.logger.finerOn()) {
                this.logger.finer("doReceive", "EXCEPTION MSG = '" + e.getMessage() + "'");
            }
            throw new InterruptedException();
        }
    }

    protected void doProcess() throws InterruptedException, CommunicationException {
        if (this.logger.finerOn()) {
            this.logger.finer("doProcess", "Address of last connected client [" + this.addrLastClient + "]");
        }
        GenericHttpNotificationReceiverHandler server = new GenericHttpNotificationReceiverHandler(this, this.getServedClientCount(), (GenericHttpSocket)this.sockListen.clone());
    }

    protected void doUnbind() throws InterruptedException, CommunicationException {
        try {
            if (this.sockListen != null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doUnbind", "Port [" + this.port + "] has been definitively closed");
                }
                this.sockListen.doUnbind();
            }
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    protected String makeDebugTag() {
        return "GenericHttpNotificationReceiver[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void stop() {
        if (this.isActive()) {
            super.stop();
            try {
                GenericHttpSocket sn = this.sockListen.createClientSocket();
                if (System.getProperty("jdmk.hostname") != null) {
                    sn.doConnect(System.getProperty("jdmk.hostname"), this.port);
                } else {
                    sn.doConnect(InetAddress.getLocalHost().getHostAddress(), this.port);
                }
                sn.doSend("", null);
                sn.doDisconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return "unknown";
        }
        return this.addrLastClient.toString();
    }
}

