/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration;

import java.io.File;
import java.util.Properties;

public class JDKServiceTag {
    private static final String ST_NODE_SERVICE_TAG = "service_tag";
    private static final String ST_NODE_INSTANCE_URN = "instance_urn";
    private static final String ST_NODE_PRODUCT_NAME = "product_name";
    private static final String ST_NODE_PRODUCT_VERSION = "product_version";
    private static final String ST_NODE_PRODUCT_URN = "product_urn";
    private static final String ST_NODE_PRODUCT_PARENT_URN = "product_parent_urn";
    private static final String ST_NODE_PRODUCT_PARENT = "product_parent";
    private static final String ST_NODE_PRODUCT_DEFINED_INST_ID = "product_defined_inst_id";
    private static final String ST_NODE_PRODUCT_VENDOR = "product_vendor";
    private static final String ST_NODE_PLATFORM_ARCH = "platform_arch";
    private static final String ST_NODE_CONTAINER = "container";
    private static final String ST_NODE_SOURCE = "source";
    private static final String JDK_6_URN = "urn:uuid:b58ef9a8-5ae8-11db-a023-080020a9ed93";
    private static final String JDK_6_NAME = "Java SE 6 Development Kit";
    private static final String JRE_6_URN = "urn:uuid:92d1de8c-1e59-42c6-a280-1c379526bcbc";
    private static final String JRE_6_NAME = "Java SE 6 Runtime Environment";
    private static final String PARENT_6_URN = "urn:uuid:fdc90b21-018d-4cab-b866-612c7c119ed3";
    private static final String PARENT_6_NAME = "Java Platform Standard Edition 6 (Java SE 6)";
    private static final String JDK_5_URN = "urn:uuid:d5bed446-05f2-42ed-ba0a-153105a52413";
    private static final String JDK_5_NAME = "J2SE 5.0 Development Kit";
    private static final String JRE_5_URN = "urn:uuid:5c6686aa-fd05-46a6-ba3e-700e2d5f7043";
    private static final String JRE_5_NAME = "J2SE 5.0 Runtime Environment";
    private static final String PARENT_5_URN = "urn:uuid:f3c20172-557a-11d7-93d0-d6a41ea318df";
    private static final String PARENT_5_NAME = "Java 2 Platform, Standard Edition 5.0";
    private static int jdkVersion = 0;

    private JDKServiceTag() {
    }

    public static Properties getServiceTagProperties(String bundleOwner) {
        String productName;
        String productURN;
        boolean isJdk;
        if (bundleOwner.length() == 0) {
            throw new IllegalArgumentException("Empty bundleOwner value");
        }
        int version = JDKServiceTag.getJdkVersion();
        if (version != 5 && version != 6) {
            return null;
        }
        Properties svcTagProps = new Properties();
        String javaHome = System.getProperty("java.home");
        String jrePath = javaHome + File.separator + "jre";
        File f = new File(jrePath, "lib");
        if (!f.exists()) {
            jrePath = javaHome;
        }
        if (isJdk = jrePath.endsWith(File.separator + "jre")) {
            productURN = version == 5 ? JDK_5_URN : JDK_6_URN;
            productName = version == 5 ? JDK_5_NAME : JDK_6_NAME;
        } else {
            productURN = version == 5 ? JRE_5_URN : JRE_6_URN;
            productName = version == 5 ? JRE_5_NAME : JRE_6_NAME;
        }
        String parentURN = version == 5 ? PARENT_5_URN : PARENT_6_URN;
        String parentName = version == 5 ? PARENT_5_NAME : PARENT_6_NAME;
        String definedId = JDKServiceTag.getProductDefinedId(jrePath);
        if (definedId.length() > 256) {
            System.err.println("Product defined instance ID exceeds the field limit:");
            System.err.println(definedId);
        }
        svcTagProps.setProperty(ST_NODE_PRODUCT_NAME, productName);
        svcTagProps.setProperty(ST_NODE_PRODUCT_VERSION, System.getProperty("java.version"));
        svcTagProps.setProperty(ST_NODE_PRODUCT_URN, productURN);
        svcTagProps.setProperty(ST_NODE_PRODUCT_PARENT_URN, parentURN);
        svcTagProps.setProperty(ST_NODE_PRODUCT_PARENT, parentName);
        svcTagProps.setProperty(ST_NODE_PRODUCT_DEFINED_INST_ID, definedId);
        svcTagProps.setProperty(ST_NODE_PRODUCT_VENDOR, "Sun Microsystems");
        svcTagProps.setProperty(ST_NODE_PLATFORM_ARCH, System.getProperty("os.arch"));
        svcTagProps.setProperty(ST_NODE_CONTAINER, "global");
        svcTagProps.setProperty(ST_NODE_SOURCE, bundleOwner);
        return svcTagProps;
    }

    private static String getProductDefinedId(String jrePath) {
        StringBuilder definedId = new StringBuilder();
        definedId.append("id=");
        definedId.append(System.getProperty("java.runtime.version"));
        File dir = new File(jrePath + File.separator + "lib");
        if (dir.isDirectory()) {
            String[] children;
            for (String name : children = dir.list()) {
                File f = new File(dir, name + File.separator + "libjava.so");
                if (!f.exists()) continue;
                definedId.append(" " + name);
            }
        }
        definedId.append(",dir=");
        definedId.append(System.getProperty("java.home"));
        return definedId.toString();
    }

    private static synchronized int getJdkVersion() {
        if (jdkVersion > 0) {
            return jdkVersion;
        }
        String cs = System.getProperty("java.runtime.version");
        if (cs.length() >= 5 && Character.isDigit(cs.charAt(0)) && cs.charAt(1) == '.' && Character.isDigit(cs.charAt(2)) && cs.charAt(3) == '.' && Character.isDigit(cs.charAt(4))) {
            jdkVersion = Character.digit(cs.charAt(2), 10);
        }
        return jdkVersion;
    }
}

