// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#include "console.h"

#include "lang.h"
#include "config.h"
#include "program.h"
#include "game_constants.h"
#include "leak_dumper.h"

namespace Glest{ namespace Game{

// =====================================================
// 	class Console
// =====================================================

Console::Console(){
	//config
	maxLines= Config::getInstance().getInt("ConsoleMaxLines");
	timeout= Config::getInstance().getInt("ConsoleTimeout");

	timeElapsed= timeout;
}

void Console::addStdMessage(const string &s){
	addLine(Lang::getInstance().get(s));
}

void Console::addLine(string line){
	timeElapsed= timeout;
	lines.push_front(line);
	if(lines.size()>maxLines){
		lines.pop_back();
	}
}

void Console::update(){
	timeElapsed-= 1.f/GameConstants::updateFps;
    if(timeElapsed<0){
        timeElapsed= timeout;
		if(!lines.empty()){
			lines.pop_back();
		}
    }   
}

bool Console::isEmpty(){
	return lines.empty();   
}
         

}}//end namespace
