// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#include "network_interface.h"

#include <exception>
#include <cassert>

#include "types.h"
#include "conversion.h"
#include "platform_util.h"

using namespace Shared::Platform;
using namespace Shared::Util;
using namespace std;

namespace Glest{ namespace Game{

// =====================================================
//	class NetworkInterface
// =====================================================

const int NetworkInterface::messageWaitTimeout= 10000;	//10 seconds
const int NetworkInterface::readyWaitTimeout= 60000;	//1 minute
const int NetworkInterface::waitSleepTime= 50;

void NetworkInterface::sendMessage(const NetworkMessage* networkMessage){
	Socket* socket= getSocket();

	networkMessage->send(socket);
}

NetworkMessageType NetworkInterface::getNextMessageType(){
	Socket* socket= getSocket();
	int8 messageType= nmtInvalid;

	if(socket->getDataToRead()>=sizeof(messageType)){
		socket->peek(&messageType, sizeof(messageType));
	}

	return static_cast<NetworkMessageType>(messageType);
}

bool NetworkInterface::receiveMessage(NetworkMessage* networkMessage){
	Socket* socket= getSocket();

	return networkMessage->receive(socket);
}

bool NetworkInterface::isConnected(){
	return getSocket()!=NULL && getSocket()->isConnected();
}

void NetworkInterface::waitForMessage(){
	Chrono chrono;

	chrono.start();

	while(getNextMessageType()==nmtInvalid){

		if(!isConnected()){
			throw runtime_error("Disconnected");
		}

		if(chrono.getMillis()>messageWaitTimeout){
			throw runtime_error("Timeout waiting for message");
		}

		sleep(waitSleepTime);
	}
}

}}//end namespace
