#ifdef __cplusplus
extern "C" {
#endif

/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/


#ifndef _DIJKSTRA_H_
#define _DIJKSTRA_H_

#include "defs.h"

#ifdef __cplusplus
void dijkstra(int vertex, vtx_data * graph, int n, DistType * dist);

/* Dijkstra bounded to nodes in *unweighted* radius */
void dijkstra_bounded(int vertex, vtx_data * graph, int n, DistType * dist,
                      int bound, int * visited_nodes, int & num_visited_nodes);

#else
extern void dijkstra(int, vtx_data*, int, DistType*);
extern void dijkstra_f(int, vtx_data*, int, float*);

 /* Dijkstra bounded to nodes in *unweighted* radius */
extern int dijkstra_bounded(int, vtx_data *, int, DistType *, int, int*);
#endif

#endif

#ifdef __cplusplus
}
#endif
