/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression,
Negatable {
    private AtomicComparer comparer;
    private BooleanValue resultWhenEmpty = null;
    private boolean needsRuntimeCheck;

    public ValueComparison(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.resultWhenEmpty != null) {
            this.resultWhenEmpty = this.resultWhenEmpty.getBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return false;
    }

    public void setResultWhenEmpty(BooleanValue value) {
        this.resultWhenEmpty = value;
    }

    public BooleanValue getResultWhenEmpty() {
        return this.resultWhenEmpty;
    }

    public boolean needsRuntimeComparabilityCheck() {
        return this.needsRuntimeCheck;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        BuiltInAtomicType p1;
        NamePool namePool = visitor.getConfiguration().getNamePool();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        if (Literal.isEmptySequence(this.operand0)) {
            return this.resultWhenEmpty == null ? this.operand0 : Literal.makeLiteral(this.resultWhenEmpty);
        }
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (Literal.isEmptySequence(this.operand1)) {
            return this.resultWhenEmpty == null ? this.operand1 : Literal.makeLiteral(this.resultWhenEmpty);
        }
        SequenceType optionalAtomic = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, optionalAtomic, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, optionalAtomic, false, role1, visitor);
        AtomicType t0 = this.operand0.getItemType(th).getAtomizedItemType();
        AtomicType t1 = this.operand1.getItemType(th).getAtomizedItemType();
        if (t0.isExternalType() || t1.isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType p0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        if (p0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p0 = BuiltInAtomicType.STRING;
        }
        if ((p1 = (BuiltInAtomicType)t1.getPrimitiveItemType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p1 = BuiltInAtomicType.STRING;
        }
        boolean bl = this.needsRuntimeCheck = p0.equals(BuiltInAtomicType.ANY_ATOMIC) || p1.equals(BuiltInAtomicType.ANY_ATOMIC);
        if (!this.needsRuntimeCheck && !Type.isComparable(p0, p1, Token.isOrderedOperator(this.operator))) {
            boolean opt0 = Cardinality.allowsZero(this.operand0.getCardinality());
            boolean opt1 = Cardinality.allowsZero(this.operand1.getCardinality());
            if (opt0 || opt1) {
                String which = null;
                if (opt0) {
                    which = "the first operand is";
                }
                if (opt1) {
                    which = "the second operand is";
                }
                if (opt0 && opt1) {
                    which = "one or both operands are";
                }
                visitor.getStaticContext().issueWarning("Comparison of " + t0.toString(namePool) + (opt0 ? "?" : "") + " to " + t1.toString(namePool) + (opt1 ? "?" : "") + " will fail unless " + which + " empty", this);
                this.needsRuntimeCheck = true;
            } else {
                XPathException err = new XPathException("Cannot compare " + t0.toString(namePool) + " to " + t1.toString(namePool));
                err.setIsTypeError(true);
                err.setErrorCode("XPTY0004");
                err.setLocator(this);
                throw err;
            }
        }
        if (this.operator != 50 && this.operator != 51) {
            if (!p0.isOrdered()) {
                XPathException err = new XPathException("Type " + t0.toString(env.getNamePool()) + " is not an ordered type");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
            if (!p1.isOrdered()) {
                XPathException err = new XPathException("Type " + t1.toString(env.getNamePool()) + " is not an ordered type");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        }
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator comp = env.getCollation(defaultCollationName);
            if (comp == null) {
                comp = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(p0, p1, comp, env.getConfiguration().getConversionContext());
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int p1;
        int p0;
        Expression arg;
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        Value value0 = null;
        Value value1 = null;
        if (this.operand0 instanceof Literal) {
            value0 = ((Literal)this.operand0).getValue();
        }
        if (this.operand1 instanceof Literal) {
            value1 = ((Literal)this.operand1).getValue();
        }
        if (value0 != null && value1 != null) {
            try {
                AtomicValue r = (AtomicValue)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext());
                return Literal.makeLiteral(r == null ? EmptySequence.getInstance() : r);
            }
            catch (NoDynamicContextException e) {
                return this;
            }
        }
        if (Aggregate.isCountFunction(this.operand0) && Literal.isAtomic(this.operand1)) {
            if (ValueComparison.isZero(value1)) {
                if (this.operator == 50 || this.operator == 55) {
                    FunctionCall result = SystemFunction.makeSystemFunction("empty", new Expression[]{((FunctionCall)this.operand0).argument[0]});
                    opt.trace("Rewrite count()=0 as:", result);
                    return result;
                }
                if (this.operator == 51 || this.operator == 52) {
                    Expression arg2 = ExpressionTool.unsorted(opt, ((FunctionCall)this.operand0).argument[0], false);
                    FunctionCall result = SystemFunction.makeSystemFunction("exists", new Expression[]{arg2});
                    opt.trace("Rewrite count()>0 as:", result);
                    return result;
                }
                if (this.operator == 54) {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
            if (value1 instanceof Int64Value && (this.operator == 52 || this.operator == 54)) {
                long val = ((Int64Value)value1).longValue();
                if (this.operator == 52) {
                    ++val;
                }
                FilterExpression filter = new FilterExpression(((FunctionCall)this.operand0).argument[0], Literal.makeLiteral(Int64Value.makeIntegerValue(val)));
                ExpressionTool.copyLocationInfo(this, filter);
                FunctionCall result = SystemFunction.makeSystemFunction("exists", new Expression[]{filter});
                opt.trace("Rewrite count()>=N as:", result);
                return result;
            }
        }
        if (Aggregate.isCountFunction(this.operand1) && ValueComparison.isZero(value0)) {
            ValueComparison vc = new ValueComparison(this.operand1, Token.inverse(this.operator), this.operand0);
            ExpressionTool.copyLocationInfo(this, vc);
            return visitor.optimize(visitor.typeCheck(vc, contextItemType), contextItemType);
        }
        if (this.operand0 instanceof StringLength && ((StringLength)this.operand0).getNumberOfArguments() == 1 && ValueComparison.isZero(value1)) {
            arg = ((StringLength)this.operand0).getArguments()[0];
            switch (this.operator) {
                case 50: 
                case 55: {
                    return SystemFunction.makeSystemFunction("not", new Expression[]{arg});
                }
                case 51: 
                case 52: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{arg});
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
            }
        }
        if (this.operand1 instanceof StringLength && ((StringLength)this.operand1).getNumberOfArguments() == 1 && ValueComparison.isZero(value0)) {
            arg = ((StringLength)this.operand1).getArguments()[0];
            switch (this.operator) {
                case 50: 
                case 54: {
                    return SystemFunction.makeSystemFunction("not", new Expression[]{arg});
                }
                case 51: 
                case 53: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{arg});
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
            }
        }
        if (((p0 = this.operand0.getItemType(th).getPrimitiveType()) == 513 || p0 == 529 || p0 == 631) && this.operand1 instanceof Literal && ((Literal)this.operand1).getValue() instanceof StringValue && ((StringValue)((Literal)this.operand1).getValue()).isZeroLength() && this.comparer instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 52: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{this.operand0});
                }
                case 50: 
                case 55: {
                    if (this.operand0.getCardinality() != 16384) break;
                    return SystemFunction.makeSystemFunction("not", new Expression[]{this.operand0});
                }
            }
        }
        if (((p1 = this.operand1.getItemType(th).getPrimitiveType()) == 513 || p1 == 529 || p1 == 631) && this.operand0 instanceof Literal && ((Literal)this.operand0).getValue() instanceof StringValue && ((StringValue)((Literal)this.operand0).getValue()).isZeroLength() && this.comparer instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 53: {
                    return SystemFunction.makeSystemFunction("boolean", new Expression[]{this.operand1});
                }
                case 50: 
                case 54: {
                    if (this.operand1.getCardinality() != 16384) break;
                    return SystemFunction.makeSystemFunction("not", new Expression[]{this.operand1});
                }
            }
        }
        if (this.operand0 instanceof Position && this.operand1 instanceof Last) {
            switch (this.operator) {
                case 50: 
                case 54: {
                    IsLastExpression iletrue = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, iletrue);
                    return iletrue;
                }
                case 51: 
                case 53: {
                    IsLastExpression ilefalse = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, ilefalse);
                    return ilefalse;
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        if (this.operand0 instanceof Last && this.operand1 instanceof Position) {
            switch (this.operator) {
                case 50: 
                case 55: {
                    IsLastExpression iletrue = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, iletrue);
                    return iletrue;
                }
                case 51: 
                case 52: {
                    IsLastExpression ilefalse = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, ilefalse);
                    return ilefalse;
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        if (value1 instanceof Int64Value && this.operand0.getCardinality() == 16384 && th.isSubType(this.operand0.getItemType(th), BuiltInAtomicType.NUMERIC)) {
            return new CompareToIntegerConstant(this.operand0, this.operator, ((Int64Value)value1).longValue());
        }
        if (value0 instanceof Int64Value && this.operand1.getCardinality() == 16384 && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.NUMERIC)) {
            return new CompareToIntegerConstant(this.operand1, Token.inverse(this.operator), ((Int64Value)value0).longValue());
        }
        if (NamePart.isGenerateIdFunction(this.operand0) && NamePart.isGenerateIdFunction(this.operand1)) {
            FunctionCall f0 = (FunctionCall)this.operand0;
            FunctionCall f1 = (FunctionCall)this.operand1;
            if (!Cardinality.allowsMany(f0.argument[0].getCardinality()) && !Cardinality.allowsMany(f1.argument[0].getCardinality()) && this.operator == 50) {
                IdentityComparison id = new IdentityComparison(f0.argument[0], 20, f1.argument[0]);
                id.setGenerateIdEmulation(true);
                ExpressionTool.copyLocationInfo(this, id);
                return visitor.optimize(visitor.typeCheck(visitor.simplify(id), contextItemType), contextItemType);
            }
        }
        return this;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        return !this.maybeNaN(this.operand0, th) && !this.maybeNaN(this.operand1, th);
    }

    private boolean maybeNaN(Expression exp, TypeHierarchy th) {
        return th.relationship(exp.getItemType(th), BuiltInAtomicType.DOUBLE) != 4 || th.relationship(exp.getItemType(th), BuiltInAtomicType.FLOAT) != 4;
    }

    public Expression negate() {
        ValueComparison vc = new ValueComparison(this.operand0, Token.negate(this.operator), this.operand1);
        vc.comparer = this.comparer;
        vc.resultWhenEmpty = this.resultWhenEmpty == null || this.resultWhenEmpty == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        ExpressionTool.copyLocationInfo(this, vc);
        return vc;
    }

    private static boolean isZero(Value v) {
        return v instanceof NumericValue && ((NumericValue)v).compareTo(0L) == 0;
    }

    public Expression copy() {
        ValueComparison vc = new ValueComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        vc.comparer = this.comparer;
        vc.resultWhenEmpty = this.resultWhenEmpty;
        vc.needsRuntimeCheck = this.needsRuntimeCheck;
        return vc;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        try {
            AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
            if (v0 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
            if (v1 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            return ValueComparison.compare(v0, this.operator, v1, this.comparer.provideContext(context), this.needsRuntimeCheck);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    static boolean compare(AtomicValue v0, int op, AtomicValue v1, AtomicComparer collator, boolean checkTypes) throws XPathException {
        if (checkTypes && !Type.isComparable(v0.getPrimitiveType(), v1.getPrimitiveType(), Token.isOrderedOperator(op))) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
        if (v0.isNaN() || v1.isNaN()) {
            return op == 51;
        }
        try {
            switch (op) {
                case 50: {
                    return collator.comparesEqual(v0, v1);
                }
                case 51: {
                    return !collator.comparesEqual(v0, v1);
                }
                case 52: {
                    return collator.compareAtomicValues(v0, v1) > 0;
                }
                case 53: {
                    return collator.compareAtomicValues(v0, v1) < 0;
                }
                case 54: {
                    return collator.compareAtomicValues(v0, v1) >= 0;
                }
                case 55: {
                    return collator.compareAtomicValues(v0, v1) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + op);
        }
        catch (ClassCastException err) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        try {
            AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
            if (v0 == null) {
                return this.resultWhenEmpty;
            }
            AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
            if (v1 == null) {
                return this.resultWhenEmpty;
            }
            return BooleanValue.get(ValueComparison.compare(v0, this.operator, v1, this.comparer.provideContext(context), this.needsRuntimeCheck));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        if (this.resultWhenEmpty != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    protected void explainExtraAttribute(ExpressionPresenter out) {
        out.emitAttribute("on-empty", this.resultWhenEmpty.toString());
    }
}

