/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.config.ClientConfigurationProvider;
import com.amazonaws.services.auth.identity.cli.config.DefaultConfigurator;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.security.BasicAWSCredentialsProvider;
import com.amazonaws.services.awsidentitymanagementv20100508.AWSIdentityManagementV20100508Client;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IAMDriver {
    protected static final String UTF_8 = "UTF-8";
    protected static final String TAB = "\t";
    private static final Log LOG = LogFactory.getLog(IAMDriver.class);
    private AWSIdentityManagementV20100508Client client_;

    public IAMDriver() {
        DefaultConfigurator.getInstance().enableLogging();
    }

    protected final AWSIdentityManagementV20100508Client getClient() {
        return this.client_;
    }

    protected String verifyPathAndAddSlashSuffix(String path) {
        if (path == null) {
            return path;
        }
        StringBuilder pathBuilder = new StringBuilder(path);
        if (!path.endsWith("/")) {
            pathBuilder.append("/");
        }
        return pathBuilder.toString();
    }

    public void invokeRequest(CLIRequest request) {
        ClientConfiguration clientConfig;
        DefaultConfigurator config = DefaultConfigurator.getInstance();
        if (request.isDebug()) {
            config.enableDebugLogging();
        }
        AWSCredentials credentials = null;
        BasicAWSCredentialsProvider credentialsProvider = new BasicAWSCredentialsProvider();
        AWSCredentials aWSCredentials = credentials = request.getAwsCredentialFile() != null ? credentialsProvider.getCredentials(request.getAwsCredentialFile()) : credentialsProvider.getCredentials();
        if (credentials == null) {
            Utils.exit(1, "Unable to load credentials", null);
        }
        String endPoint = request.getEndpointURL() != null ? request.getEndpointURL() : config.getEndPointURL();
        ClientConfigurationProvider configProvider = new ClientConfigurationProvider();
        ClientConfiguration clientConfiguration = clientConfig = request.getClientConfigFile() != null ? configProvider.getClientConfiguration(request.getClientConfigFile()) : configProvider.getClientConfiguration();
        if (clientConfig == null) {
            Utils.exit(1, "Unable to load client configurations", null);
        }
        this.client_ = new AWSIdentityManagementV20100508Client(credentials, clientConfig);
        this.client_.setEndpoint(endPoint);
        try {
            this.invokeRequestImpl(request);
        }
        catch (AmazonServiceException e) {
            LOG.error((Object)(e.getStatusCode() + " " + e.getErrorCode() + " " + e.getMessage()));
        }
        catch (AmazonClientException e) {
            LOG.error((Object)e.getMessage());
        }
    }

    protected abstract void invokeRequestImpl(CLIRequest var1);
}

