/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.policy;

import com.amazonaws.services.auth.identity.cli.policy.Effect;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBuilder {
    private static final String POLICY_START = "{";
    private static final String POLICY_END = "}";
    private static final String VERSION = "\"Version\":\"2008-10-17\",";
    private static final String STATEMENT_START = "\"Statement\":[{";
    private static final String EFFECT = "\"Effect\":";
    private static final String ACTION = "\"Action\":";
    private static final String RESOURCE = "\"Resource\":";
    private static final String STATEMENT_END = "}]";
    private static final String SQUARE_LEFT_BRACE = "[";
    private static final String SQUARE_RIGHT_BRACE = "]";
    private static final String COMMA = ",";
    private static final String DOUBLE_QUOTE = "\"";

    public static String buildPolicy(Effect effect, List<String> actions, List<String> resources) {
        StringBuilder pb = new StringBuilder();
        pb.append(POLICY_START);
        pb.append(VERSION);
        pb.append(STATEMENT_START);
        pb.append(EFFECT).append(PolicyBuilder.wrapWithQuotes(effect.name())).append(COMMA);
        pb.append(PolicyBuilder.getAction(actions)).append(COMMA);
        pb.append(PolicyBuilder.getResource(resources));
        pb.append(STATEMENT_END);
        pb.append(POLICY_END);
        return pb.toString();
    }

    private static String getAction(List<String> actions) {
        StringBuilder ab = new StringBuilder();
        ab.append(ACTION).append(SQUARE_LEFT_BRACE);
        for (int i = 0; i < actions.size(); ++i) {
            if (i > 0) {
                ab.append(COMMA);
            }
            ab.append(PolicyBuilder.wrapWithQuotes(actions.get(i)));
        }
        ab.append(SQUARE_RIGHT_BRACE);
        return ab.toString();
    }

    private static String getResource(List<String> resources) {
        StringBuilder sb = new StringBuilder();
        sb.append(RESOURCE).append(SQUARE_LEFT_BRACE);
        for (int i = 0; i < resources.size(); ++i) {
            if (i > 0) {
                sb.append(COMMA);
            }
            sb.append(PolicyBuilder.wrapWithQuotes(resources.get(i)));
        }
        sb.append(SQUARE_RIGHT_BRACE);
        return sb.toString();
    }

    private static String wrapWithQuotes(String string) {
        StringBuilder sb = new StringBuilder();
        sb.append(DOUBLE_QUOTE).append(string).append(DOUBLE_QUOTE);
        return sb.toString();
    }
}

