/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class StartElementEvent
implements PullEvent {
    PipelineConfiguration pipe;
    private int nameCode;
    private int typeCode;
    private int[] localNamespaces;
    private List attributes;
    private int locationId = -1;

    public StartElementEvent(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setLocalNamespaces(int[] nscodes) {
        this.localNamespaces = nscodes;
    }

    public void addNamespace(int nscode) throws XPathException {
        if (this.localNamespaces == null) {
            this.localNamespaces = new int[]{nscode, -1, -1, -1};
        }
        for (int n = 0; n < this.localNamespaces.length; ++n) {
            int nn = this.localNamespaces[n];
            if (nn == nscode) {
                return;
            }
            if (nn == -1) {
                this.localNamespaces[n] = nscode;
                if (n < this.localNamespaces.length - 1) {
                    this.localNamespaces[n + 1] = -1;
                }
                return;
            }
            if ((nn & 0xFFFF0000) != (nscode & 0xFFFF0000)) continue;
            NamePool pool = this.pipe.getConfiguration().getNamePool();
            String prefix = pool.getPrefixFromNamespaceCode(nscode);
            String uri1 = pool.getURIFromNamespaceCode(nn);
            String uri2 = pool.getURIFromNamespaceCode(nscode);
            XPathException err = new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=" + (prefix.length() == 0 ? "\"\"" : prefix) + ", URI=" + (uri1.length() == 0 ? "\"\"" : uri1) + ", URI=" + (uri2.length() == 0 ? "\"\"" : uri2) + ")");
            err.setErrorCode("XTDE0430");
            throw err;
        }
        int[] n2 = new int[this.localNamespaces.length * 2 + 2];
        System.arraycopy(this.localNamespaces, 0, n2, 0, this.localNamespaces.length);
        n2[this.localNamespaces.length] = nscode;
        n2[this.localNamespaces.length + 1] = -1;
        this.localNamespaces = n2;
    }

    public int[] getLocalNamespaces() {
        if (this.localNamespaces == null) {
            return IntArraySet.EMPTY_INT_ARRAY;
        }
        return this.localNamespaces;
    }

    public void addAttribute(NodeInfo att) throws XPathException {
        if (this.attributes == null) {
            this.attributes = new ArrayList(4);
        }
        int fp = att.getFingerprint();
        for (int a = 0; a < this.attributes.size(); ++a) {
            int fp2 = ((NodeInfo)this.attributes.get(a)).getFingerprint();
            if (fp != fp2) continue;
            if (this.pipe.getHostLanguage() == 51) {
                XPathException err = new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(att.getDisplayName(), 2));
                err.setErrorCode("XQDY0025");
                if (this.locationId != -1) {
                    err.setLocator(new ExpressionLocation(this.pipe.getLocationProvider(), this.locationId));
                }
                throw err;
            }
            this.attributes.set(a, att);
            return;
        }
        this.attributes.add(att);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Iterator iterateAttributes() {
        if (this.attributes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.attributes.iterator();
    }

    public NodeInfo getAttribute(int index) {
        if (this.attributes == null) {
            return null;
        }
        return (NodeInfo)this.attributes.get(index);
    }

    public void namespaceFixup() {
        NamePool pool = this.pipe.getConfiguration().getNamePool();
        this.nameCode = this.fixup(pool, this.nameCode, 0);
        if (this.attributes != null) {
            for (int a = 0; a < this.attributes.size(); ++a) {
                int newCode;
                NodeInfo oldAtt = (NodeInfo)this.attributes.get(a);
                int oldCode = oldAtt.getNameCode();
                if (oldCode == (newCode = this.fixup(pool, oldCode, a))) continue;
                Orphan att = new Orphan(oldAtt.getConfiguration());
                att.setNodeKind((short)2);
                att.setNameCode(newCode);
                att.setStringValue(oldAtt.getStringValue());
                att.setTypeAnnotation(oldAtt.getTypeAnnotation());
                att.setSystemId(oldAtt.getSystemId());
                this.attributes.set(a, att);
            }
        }
    }

    private int fixup(NamePool pool, int nameCode, int seq) {
        int nscode = pool.getNamespaceCode(nameCode);
        if (nscode == 0) {
            return nameCode;
        }
        if (this.localNamespaces != null) {
            for (int n = 0; n < this.localNamespaces.length; ++n) {
                int nn = this.localNamespaces[n];
                if (nn == nscode) {
                    return nameCode;
                }
                if (nn == -1) break;
                if ((nscode & 0xFFFF0000) != (nn & 0xFFFF0000)) continue;
                String local = pool.getLocalName(nameCode);
                String uri = pool.getURI(nameCode);
                String prefix = pool.getPrefix(nameCode) + "_" + seq;
                int newCode = pool.allocate(prefix, uri, local);
                return this.fixup(pool, newCode, seq);
            }
        }
        try {
            this.addNamespace(nscode);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
        return nameCode;
    }

    public void stripTypeAnnotations() {
        this.setTypeCode(630);
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                NodeInfo att = (NodeInfo)this.attributes.get(i);
                if (att.getTypeAnnotation() == 631) continue;
                Orphan o = new Orphan(att.getConfiguration());
                o.setNodeKind((short)2);
                o.setNameCode(att.getNameCode());
                o.setStringValue(att.getStringValue());
                o.setSystemId(att.getSystemId());
                o.setTypeAnnotation(631);
                this.attributes.set(i, o);
            }
        }
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public int getLocationId() {
        return this.locationId;
    }
}

