/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class NamePool
implements Serializable {
    public static final int FP_MASK = 1048575;
    public static final int USER_DEFINED_MASK = 1047552;
    public static final int MAX_PREFIXES_PER_URI = 1023;
    NameEntry[] hashslots = new NameEntry[1024];
    String[] prefixes = new String[100];
    short prefixesUsed = 0;
    String[] uris = new String[100];
    short[][] prefixCodesForUri = new short[100][0];
    short urisUsed = 0;
    private HashMap<Class, Object> clientData;

    public NamePool() {
        this.prefixes[0] = "";
        this.uris[0] = "";
        this.prefixCodesForUri[0] = new short[]{0};
        this.prefixes[1] = "xml";
        this.uris[1] = "http://www.w3.org/XML/1998/namespace";
        this.prefixCodesForUri[1] = new short[]{1};
        this.prefixes[2] = "xsl";
        this.uris[2] = "http://www.w3.org/1999/XSL/Transform";
        this.prefixCodesForUri[2] = new short[]{2};
        this.prefixes[3] = "saxon";
        this.uris[3] = "http://saxon.sf.net/";
        this.prefixCodesForUri[3] = new short[]{3};
        this.prefixes[4] = "xs";
        this.uris[4] = "http://www.w3.org/2001/XMLSchema";
        this.prefixCodesForUri[4] = new short[]{4};
        this.prefixes[5] = "xsi";
        this.uris[5] = "http://www.w3.org/2001/XMLSchema-instance";
        this.prefixCodesForUri[5] = new short[]{5};
        this.prefixesUsed = (short)6;
        this.urisUsed = (short)6;
    }

    private NameEntry getNameEntry(int nameCode) {
        int hash = nameCode & 0x3FF;
        int depth = nameCode >> 10 & 0x3FF;
        NameEntry entry = this.hashslots[hash];
        for (int i = 1; i < depth; ++i) {
            if (entry == null) {
                return null;
            }
            entry = entry.nextEntry;
        }
        return entry;
    }

    public synchronized int allocateNamespaceCode(String prefix, String uri) {
        short[] prefixCodes;
        short prefixCode = this.allocateCodeForPrefix(prefix);
        short uriCode = this.allocateCodeForURIInternal(uri);
        if (prefixCode != 0 && NamePool.search(prefixCodes = this.prefixCodesForUri[uriCode], prefixCode) < 0) {
            if (this.prefixes.length == 1023) {
                throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
            }
            short[] p2 = new short[prefixCodes.length + 1];
            System.arraycopy(prefixCodes, 0, p2, 0, prefixCodes.length);
            p2[prefixCodes.length] = prefixCode;
            this.prefixCodesForUri[uriCode] = p2;
        }
        return (prefixCode << 16) + uriCode;
    }

    public int getNamespaceCode(String prefix, String uri) {
        short[] prefixCodes;
        short prefixCode = this.getCodeForPrefix(prefix);
        if (prefixCode < 0) {
            return -1;
        }
        short uriCode = this.getCodeForURI(uri);
        if (uriCode < 0) {
            return -1;
        }
        if (prefixCode != 0 && NamePool.search(prefixCodes = this.prefixCodesForUri[uriCode], prefixCode) < 0) {
            return -1;
        }
        return (prefixCode << 16) + uriCode;
    }

    private static int search(short[] codes, short value) {
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int getNamespaceCode(int namecode) {
        short uriCode;
        int fp = namecode & 0xFFFFF;
        if ((fp & 0xFFC00) == 0) {
            uriCode = StandardNames.getURICode(fp);
        } else {
            NameEntry entry = this.getNameEntry(namecode);
            if (entry == null) {
                return -1;
            }
            uriCode = entry.uriCode;
        }
        int prefixIndex = namecode >> 20 & 0x3FF;
        short prefixCode = this.getPrefixCodeWithIndex(uriCode, prefixIndex);
        return (prefixCode << 16) + uriCode;
    }

    public static int getPrefixIndex(int nameCode) {
        return nameCode >> 20 & 0x3FF;
    }

    public static boolean isPrefixed(int nameCode) {
        return (nameCode & 0x3FF00000) != 0;
    }

    public synchronized short allocateCodeForURI(String uri) {
        return this.allocateCodeForURIInternal(uri);
    }

    private short allocateCodeForURIInternal(String uri) {
        if (uri == null) {
            return 0;
        }
        for (short j = 0; j < this.urisUsed; j = (short)(j + 1)) {
            if (!this.uris[j].equals(uri)) continue;
            return j;
        }
        if (this.urisUsed >= this.uris.length) {
            if (this.urisUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace URIs");
            }
            short[][] p = new short[this.urisUsed * 2][0];
            String[] u = new String[this.urisUsed * 2];
            System.arraycopy(this.prefixCodesForUri, 0, p, 0, this.urisUsed);
            System.arraycopy(this.uris, 0, u, 0, this.urisUsed);
            this.prefixCodesForUri = p;
            this.uris = u;
        }
        this.uris[this.urisUsed] = uri;
        short s = this.urisUsed;
        this.urisUsed = (short)(s + 1);
        return s;
    }

    public short getCodeForURI(String uri) {
        for (short j = 0; j < this.urisUsed; j = (short)(j + 1)) {
            if (!this.uris[j].equals(uri)) continue;
            return j;
        }
        return -1;
    }

    private short allocateCodeForPrefix(String prefix) {
        if (prefix.length() == 0) {
            return 0;
        }
        short start = 1;
        if (prefix.charAt(0) != 'x') {
            if (prefix.equals("saxon")) {
                return 3;
            }
            start = 6;
        }
        for (short i = start; i < this.prefixesUsed; i = (short)(i + 1)) {
            if (!this.prefixes[i].equals(prefix)) continue;
            return i;
        }
        if (this.prefixesUsed >= this.prefixes.length) {
            if (this.prefixesUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace prefixes");
            }
            String[] p = new String[this.prefixesUsed * 2];
            System.arraycopy(this.prefixes, 0, p, 0, this.prefixesUsed);
            this.prefixes = p;
        }
        this.prefixes[this.prefixesUsed] = prefix;
        short s = this.prefixesUsed;
        this.prefixesUsed = (short)(s + 1);
        return s;
    }

    public short getCodeForPrefix(String prefix) {
        for (short i = 0; i < this.prefixesUsed; i = (short)(i + 1)) {
            if (!this.prefixes[i].equals(prefix)) continue;
            return i;
        }
        return -1;
    }

    public String suggestPrefixForURI(String URI2) {
        if (URI2.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        short uriCode = this.getCodeForURI(URI2);
        if (uriCode == -1) {
            return null;
        }
        if (this.prefixCodesForUri[uriCode].length >= 1) {
            return this.prefixes[this.prefixCodesForUri[uriCode][0]];
        }
        return null;
    }

    private short getPrefixCodeWithIndex(short uriCode, int index) {
        if (index == 0) {
            return 0;
        }
        return this.prefixCodesForUri[uriCode][index - 1];
    }

    private String getPrefixWithIndex(short uriCode, int index) {
        if (index == 0) {
            return "";
        }
        return this.prefixes[this.prefixCodesForUri[uriCode][index - 1]];
    }

    public synchronized int allocate(String prefix, String uri, String localName) {
        int prefixIndex;
        int fp;
        short prefixCode = this.allocateCodeForPrefix(prefix);
        if ((NamespaceConstant.isReserved(uri) || "http://saxon.sf.net/".equals(uri)) && (fp = StandardNames.getFingerprint(uri, localName)) != -1) {
            int pindex;
            short uriCode = StandardNames.getURICode(fp);
            if (prefix.length() == 0) {
                pindex = 0;
            } else {
                short[] prefixCodes = this.prefixCodesForUri[uriCode];
                int prefixPosition = NamePool.search(prefixCodes, prefixCode);
                if (prefixPosition < 0) {
                    if (prefixCodes.length == 1023) {
                        throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
                    }
                    short[] p2 = new short[prefixCodes.length + 1];
                    System.arraycopy(prefixCodes, 0, p2, 0, prefixCodes.length);
                    p2[prefixCodes.length] = prefixCode;
                    this.prefixCodesForUri[uriCode] = p2;
                    prefixPosition = prefixCodes.length;
                }
                pindex = prefixPosition + 1;
            }
            return (pindex << 20) + fp;
        }
        short uriCode = this.allocateCodeForURIInternal(uri);
        int hash = (localName.hashCode() & Integer.MAX_VALUE) % 1023;
        int depth = 1;
        short[] prefixCodes = this.prefixCodesForUri[uriCode];
        if (prefix.length() == 0) {
            prefixIndex = 0;
        } else {
            int prefixPosition = NamePool.search(prefixCodes, prefixCode);
            if (prefixPosition < 0) {
                if (prefixCodes.length == 1023) {
                    throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
                }
                short[] p2 = new short[prefixCodes.length + 1];
                System.arraycopy(prefixCodes, 0, p2, 0, prefixCodes.length);
                p2[prefixCodes.length] = prefixCode;
                this.prefixCodesForUri[uriCode] = p2;
                prefixPosition = prefixCodes.length;
            }
            prefixIndex = prefixPosition + 1;
        }
        if (this.hashslots[hash] == null) {
            NameEntry entry;
            this.hashslots[hash] = entry = new NameEntry(uriCode, localName);
        } else {
            NameEntry entry = this.hashslots[hash];
            while (true) {
                boolean sameURI;
                boolean sameLocalName = entry.localName.equals(localName);
                boolean bl = sameURI = entry.uriCode == uriCode;
                if (sameLocalName && sameURI) break;
                NameEntry next = entry.nextEntry;
                if (++depth >= 1024) {
                    throw new NamePoolLimitException("Saxon name pool is full");
                }
                if (next == null) {
                    entry.nextEntry = new NameEntry(uriCode, localName);
                    break;
                }
                entry = next;
            }
        }
        return (prefixIndex << 20) + (depth << 10) + hash;
    }

    public String getURI(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getURI(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            this.unknownNameCode(nameCode);
            return null;
        }
        return this.uris[entry.uriCode];
    }

    public short getURICode(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getURICode(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            this.unknownNameCode(nameCode);
            return -1;
        }
        return entry.uriCode;
    }

    public String getLocalName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getLocalName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            this.unknownNameCode(nameCode);
            return null;
        }
        return entry.localName;
    }

    public String getPrefix(int nameCode) {
        int prefixIndex = nameCode >> 20 & 0x3FF;
        if (prefixIndex == 0) {
            return "";
        }
        short uriCode = this.getURICode(nameCode);
        return this.prefixes[this.prefixCodesForUri[uriCode][prefixIndex - 1]];
    }

    public String getDisplayName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            short uriCode = this.getURICode(nameCode);
            if (uriCode == 1) {
                return "xml:" + StandardNames.getLocalName(nameCode & 0xFFFFF);
            }
            if (NamePool.isPrefixed(nameCode)) {
                return this.getPrefix(nameCode) + ':' + StandardNames.getLocalName(nameCode & 0xFFFFF);
            }
            return StandardNames.getLocalName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            this.unknownNameCode(nameCode);
            return null;
        }
        if (NamePool.isPrefixed(nameCode)) {
            return this.getPrefix(nameCode) + ':' + entry.localName;
        }
        return entry.localName;
    }

    public String getClarkName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getClarkName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            this.unknownNameCode(nameCode);
            return null;
        }
        if (entry.uriCode == 0) {
            return entry.localName;
        }
        String n = '{' + this.getURIFromURICode(entry.uriCode) + '}' + entry.localName;
        return n.intern();
    }

    public int allocateClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return this.allocate("", namespace, localName);
    }

    public static String[] parseClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return new String[]{namespace, localName};
    }

    private void unknownNameCode(int nameCode) {
        throw new IllegalArgumentException("Unknown name code " + nameCode);
    }

    public int getFingerprint(String uri, String localName) {
        short uriCode;
        if (uri.length() == 0) {
            uriCode = 0;
        } else {
            int fp;
            if ((NamespaceConstant.isReserved(uri) || uri.equals("http://saxon.sf.net/")) && (fp = StandardNames.getFingerprint(uri, localName)) != -1) {
                return fp;
            }
            uriCode = -1;
            for (short j = 0; j < this.urisUsed; j = (short)(j + 1)) {
                if (!this.uris[j].equals(uri)) continue;
                uriCode = j;
                break;
            }
            if (uriCode == -1) {
                return -1;
            }
        }
        int hash = (localName.hashCode() & Integer.MAX_VALUE) % 1023;
        int depth = 1;
        if (this.hashslots[hash] == null) {
            return -1;
        }
        NameEntry entry = this.hashslots[hash];
        while (entry.uriCode != uriCode || !entry.localName.equals(localName)) {
            NameEntry next = entry.nextEntry;
            ++depth;
            if (next == null) {
                return -1;
            }
            entry = next;
        }
        return (depth << 10) + hash;
    }

    public String getURIFromNamespaceCode(int code) {
        return this.uris[code & 0xFFFF];
    }

    public String getURIFromURICode(short code) {
        return this.uris[code];
    }

    public String getPrefixFromNamespaceCode(int code) {
        return this.prefixes[code >> 16];
    }

    public int allocateLexicalQName(CharSequence qname, boolean useDefault, NamespaceResolver resolver, NameChecker checker) throws XPathException {
        try {
            String[] parts = checker.getQNameParts(Whitespace.trimWhitespace(qname));
            String uri = resolver.getURIForPrefix(parts[0], useDefault);
            if (uri == null) {
                throw new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
            }
            return this.allocate(parts[0], uri, parts[1]);
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage());
        }
    }

    public void setClientData(Class key, Object value) {
        if (this.clientData == null) {
            this.clientData = new HashMap(10);
        }
        this.clientData.put(key, value);
    }

    public Object getClientData(Class key) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.get(key);
    }

    public synchronized void diagnosticDump() {
        System.err.println("Contents of NamePool " + this);
        for (int i = 0; i < 1024; ++i) {
            NameEntry entry = this.hashslots[i];
            int depth = 0;
            while (entry != null) {
                System.err.println("Fingerprint " + depth + '/' + i);
                System.err.println("  local name = " + entry.localName + " uri code = " + entry.uriCode);
                entry = entry.nextEntry;
                ++depth;
            }
        }
        for (int p = 0; p < this.prefixesUsed; ++p) {
            System.err.println("Prefix " + p + " = " + this.prefixes[p]);
        }
        for (int u = 0; u < this.urisUsed; ++u) {
            System.err.println("URI " + u + " = " + this.uris[u]);
            FastStringBuffer fsb = new FastStringBuffer(64);
            for (int p = 0; p < this.prefixCodesForUri[u].length; ++p) {
                fsb.append(this.prefixCodesForUri[u][p] + ", ");
            }
            System.err.println("Prefix codes for URI " + u + " = " + fsb.toString());
        }
    }

    public synchronized void statistics() {
        int slots = 0;
        int entries = 0;
        for (int i = 0; i < 1024; ++i) {
            NameEntry entry = this.hashslots[i];
            if (entry != null) {
                ++slots;
            }
            while (entry != null) {
                entry = entry.nextEntry;
                ++entries;
            }
        }
        System.err.println("NamePool contents: " + entries + " entries in " + slots + " chains. " + this.prefixesUsed + " prefixes, " + this.urisUsed + " URIs");
    }

    public static class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String message) {
            super(message);
        }
    }

    private static class NameEntry
    implements Serializable {
        String localName;
        short uriCode;
        NameEntry nextEntry;

        public NameEntry(short uriCode, String localName) {
            this.uriCode = uriCode;
            this.localName = localName.intern();
            this.nextEntry = null;
        }
    }
}

