/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLDecimalFormat
extends StyleElement {
    boolean prepared = false;
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;

    public void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                this.name = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("decimal-separator")) {
                this.decimalSeparator = atts.getValue(a);
                continue;
            }
            if (f.equals("grouping-separator")) {
                this.groupingSeparator = atts.getValue(a);
                continue;
            }
            if (f.equals("infinity")) {
                this.infinity = atts.getValue(a);
                continue;
            }
            if (f.equals("minus-sign")) {
                this.minusSign = atts.getValue(a);
                continue;
            }
            if (f.equals("NaN")) {
                this.NaN = atts.getValue(a);
                continue;
            }
            if (f.equals("percent")) {
                this.percent = atts.getValue(a);
                continue;
            }
            if (f.equals("per-mille")) {
                this.perMille = atts.getValue(a);
                continue;
            }
            if (f.equals("zero-digit")) {
                this.zeroDigit = atts.getValue(a);
                continue;
            }
            if (f.equals("digit")) {
                this.digit = atts.getValue(a);
                continue;
            }
            if (f.equals("pattern-separator")) {
                this.patternSeparator = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public DecimalSymbols makeDecimalFormatSymbols() throws XPathException {
        DecimalSymbols d = new DecimalSymbols();
        if (this.decimalSeparator != null) {
            d.decimalSeparator = this.toChar(this.decimalSeparator);
        }
        if (this.groupingSeparator != null) {
            d.groupingSeparator = this.toChar(this.groupingSeparator);
        }
        if (this.infinity != null) {
            d.infinity = this.infinity;
        }
        if (this.minusSign != null) {
            d.minusSign = this.toChar(this.minusSign);
        }
        if (this.NaN != null) {
            d.NaN = this.NaN;
        }
        if (this.percent != null) {
            d.percent = this.toChar(this.percent);
        }
        if (this.perMille != null) {
            d.permill = this.toChar(this.perMille);
        }
        if (this.zeroDigit != null) {
            d.zeroDigit = this.toChar(this.zeroDigit);
            if (!d.isValidZeroDigit()) {
                this.compileError("The value of the zero-digit attribute must be a Unicode digit with value zero", "XTSE1295");
            }
        }
        if (this.digit != null) {
            d.digit = this.toChar(this.digit);
        }
        if (this.patternSeparator != null) {
            d.patternSeparator = this.toChar(this.patternSeparator);
        }
        try {
            d.checkDistinctRoles();
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), "XTSE1300");
        }
        return d;
    }

    public void index(XSLStylesheet top) throws XPathException {
        this.prepareAttributes();
        DecimalSymbols d = this.makeDecimalFormatSymbols();
        DecimalFormatManager dfm = this.getPreparedStylesheet().getDecimalFormatManager();
        if (this.name == null) {
            try {
                dfm.setDefaultDecimalFormat(d, this.getPrecedence());
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), err.getErrorCodeQName());
            }
        } else {
            try {
                StructuredQName formatName = this.makeQName(this.name);
                try {
                    dfm.setNamedDecimalFormat(formatName, d, this.getPrecedence());
                }
                catch (XPathException err) {
                    this.compileError(err.getMessage(), err.getErrorCodeQName());
                }
            }
            catch (XPathException err) {
                this.compileError("Invalid decimal format name. " + err.getMessage(), "XTSE0020");
            }
            catch (NamespaceException err) {
                this.compileError("Invalid decimal format name. " + err.getMessage(), "XTSE0280");
            }
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return null;
    }

    private int toChar(String s) throws XPathException {
        int[] e = StringValue.expand(s);
        if (e.length != 1) {
            this.compileError("Attribute \"" + s + "\" should be a single character", "XTSE0020");
        }
        return e[0];
    }
}

