/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.log4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.DummyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StandardTests
extends TestCase {
    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public abstract void setUpTestAppender(List var1) throws Exception;

    public void testCreateFactory() {
        LogFactory factory = LogFactory.getFactory();
        Assert.assertNotNull((String)"LogFactory exists", (Object)factory);
        Assert.assertEquals((String)"LogFactory class", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)factory.getClass().getName());
        String[] names = factory.getAttributeNames();
        Assert.assertNotNull((String)"Names exists", (Object)names);
        Assert.assertEquals((String)"Names empty", (int)0, (int)names.length);
    }

    public void testPlainMessages() throws Exception {
        ArrayList logEvents = new ArrayList();
        this.setUpTestAppender(logEvents);
        Log log = LogFactory.getLog((String)"test-category");
        this.logPlainMessages(log);
        this.checkLoggingEvents(logEvents, false);
    }

    public void testExceptionMessages() throws Exception {
        ArrayList logEvents = new ArrayList();
        this.setUpTestAppender(logEvents);
        Log log = LogFactory.getLog((String)"test-category");
        this.logExceptionMessages(log);
        this.checkLoggingEvents(logEvents, true);
    }

    public void testSerializable() throws Exception {
        ArrayList logEvents = new ArrayList();
        this.setUpTestAppender(logEvents);
        Log log = LogFactory.getLog((String)"test-category");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Log newLog = (Log)ois.readObject();
        ois.close();
        this.logExceptionMessages(newLog);
        this.checkLoggingEvents(logEvents, true);
    }

    private void checkLoggingEvents(List logEvents, boolean thrown) {
        Assert.assertEquals((String)"Unexpected number of log events", (int)4, (int)logEvents.size());
        LogEvent ev = (LogEvent)logEvents.get(0);
        Assert.assertEquals((String)"Info message expected", (String)"info", (String)ev.msg);
        Assert.assertEquals((String)"Info level expected", (String)"INFO", (String)ev.level);
        Assert.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
        ev = (LogEvent)logEvents.get(1);
        Assert.assertEquals((String)"Warn message expected", (String)"warn", (String)ev.msg);
        Assert.assertEquals((String)"Warn level expected", (String)"WARN", (String)ev.level);
        Assert.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
        ev = (LogEvent)logEvents.get(2);
        Assert.assertEquals((String)"Error message expected", (String)"error", (String)ev.msg);
        Assert.assertEquals((String)"Error level expected", (String)"ERROR", (String)ev.level);
        Assert.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
        ev = (LogEvent)logEvents.get(3);
        Assert.assertEquals((String)"Fatal message expected", (String)"fatal", (String)ev.msg);
        Assert.assertEquals((String)"Fatal level expected", (String)"FATAL", (String)ev.level);
        Assert.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
    }

    private void logPlainMessages(Log log) {
        log.trace((Object)"trace");
        log.debug((Object)"debug");
        log.info((Object)"info");
        log.warn((Object)"warn");
        log.error((Object)"error");
        log.fatal((Object)"fatal");
    }

    private void logExceptionMessages(Log log) {
        DummyException t = new DummyException();
        log.trace((Object)"trace", (Throwable)t);
        log.debug((Object)"debug", (Throwable)t);
        log.info((Object)"info", (Throwable)t);
        log.warn((Object)"warn", (Throwable)t);
        log.error((Object)"error", (Throwable)t);
        log.fatal((Object)"fatal", (Throwable)t);
    }

    public static class LogEvent {
        public String msg;
        public String level;
        public Throwable throwable;
    }
}

