/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * ColorBlocks.java
 *
 * Created on November 17, 2007, 2:56 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package demos;

/**
 *
 * @author jrobinso
 */

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Rectangle2D;

public class ColorBlocks extends JPanel {
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;

        Dimension d = getSize();
        g2.translate(d.width / 2, d.height / 2);
        Color[] colors = {
                Color.white, Color.lightGray, Color.gray, Color.darkGray,
                Color.black, Color.red, Color.pink, Color.orange,
                Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue
        };
        float size = 25;
        float x = -size * colors.length / 2;
        float y = -size * 3 / 2;
        // Show all the predefined colors.
        for (int i = 0; i < colors.length; i++) {
            Rectangle2D r = new Rectangle2D.Float(
                    x + size * (float) i, y, size, size);
            g2.setPaint(colors[i]);
            g2.fill(r);
        }
        //a linear gradient.
        y += size;
        Color c1 = Color.yellow;
        Color c2 = Color.blue;
        for (int i = 0; i < colors.length; i++) {
            float ratio = (float) i / (float) colors.length;
            int red = (int) (c2.getRed() * ratio + c1.getRed() * (1 - ratio));
            int green = (int) (c2.getGreen() * ratio +
                    c1.getGreen() * (1 - ratio));
            int blue = (int) (c2.getBlue() * ratio +
                    c1.getBlue() * (1 - ratio));
            Color c = new Color(red, green, blue);
            Rectangle2D r = new Rectangle2D.Float(
                    x + size * (float) i, y, size, size);
            g2.setPaint(c);
            g2.fill(r);
        }
        // Show an alpha gradient.
        y += size;
        c1 = Color.red;
        for (int i = 0; i < colors.length; i++) {
            int alpha = (int) (255 * (float) i / (float) colors.length);
            Color c = new Color(c1.getRed(), c1.getGreen(),
                    c1.getBlue(), alpha);
            Rectangle2D r = new Rectangle2D.Float(
                    x + size * (float) i, y, size, size);
            g2.setPaint(c);
            g2.fill(r);
        }
        // Draw a frame around the whole thing.
        y -= size * 2;
        Rectangle2D frame = new Rectangle2D.Float(x, y, size * colors.length, size * 3);
        g2.setPaint(Color.black);
        g2.draw(frame);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().add(new ColorBlocks());
        f.setSize(350, 250);
        f.setVisible(true);
    }
}
